/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse;

public class ListBusinessReportSchedulesPublisher
implements SdkPublisher<ListBusinessReportSchedulesResponse> {
    private final AlexaForBusinessAsyncClient client;
    private final ListBusinessReportSchedulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBusinessReportSchedulesPublisher(AlexaForBusinessAsyncClient client, ListBusinessReportSchedulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBusinessReportSchedulesPublisher(AlexaForBusinessAsyncClient client, ListBusinessReportSchedulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBusinessReportSchedulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBusinessReportSchedulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBusinessReportSchedulesResponseFetcher
    implements AsyncPageFetcher<ListBusinessReportSchedulesResponse> {
        private ListBusinessReportSchedulesResponseFetcher() {
        }

        public boolean hasNextPage(ListBusinessReportSchedulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBusinessReportSchedulesResponse> nextPage(ListBusinessReportSchedulesResponse previousPage) {
            if (previousPage == null) {
                return ListBusinessReportSchedulesPublisher.this.client.listBusinessReportSchedules(ListBusinessReportSchedulesPublisher.this.firstRequest);
            }
            return ListBusinessReportSchedulesPublisher.this.client.listBusinessReportSchedules((ListBusinessReportSchedulesRequest)((Object)ListBusinessReportSchedulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

