/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A room with attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Room implements SdkPojo, Serializable, ToCopyableBuilder<Room.Builder, Room> {
    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Room::roomArn)).setter(setter(Builder::roomArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()).build();

    private static final SdkField<String> ROOM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Room::roomName)).setter(setter(Builder::roomName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Room::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PROVIDER_CALENDAR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Room::providerCalendarId)).setter(setter(Builder::providerCalendarId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderCalendarId").build())
            .build();

    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Room::profileArn)).setter(setter(Builder::profileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_ARN_FIELD,
            ROOM_NAME_FIELD, DESCRIPTION_FIELD, PROVIDER_CALENDAR_ID_FIELD, PROFILE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roomArn;

    private final String roomName;

    private final String description;

    private final String providerCalendarId;

    private final String profileArn;

    private Room(BuilderImpl builder) {
        this.roomArn = builder.roomArn;
        this.roomName = builder.roomName;
        this.description = builder.description;
        this.providerCalendarId = builder.providerCalendarId;
        this.profileArn = builder.profileArn;
    }

    /**
     * <p>
     * The ARN of a room.
     * </p>
     * 
     * @return The ARN of a room.
     */
    public String roomArn() {
        return roomArn;
    }

    /**
     * <p>
     * The name of a room.
     * </p>
     * 
     * @return The name of a room.
     */
    public String roomName() {
        return roomName;
    }

    /**
     * <p>
     * The description of a room.
     * </p>
     * 
     * @return The description of a room.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The provider calendar ARN of a room.
     * </p>
     * 
     * @return The provider calendar ARN of a room.
     */
    public String providerCalendarId() {
        return providerCalendarId;
    }

    /**
     * <p>
     * The profile ARN of a room.
     * </p>
     * 
     * @return The profile ARN of a room.
     */
    public String profileArn() {
        return profileArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(roomName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(providerCalendarId());
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Room)) {
            return false;
        }
        Room other = (Room) obj;
        return Objects.equals(roomArn(), other.roomArn()) && Objects.equals(roomName(), other.roomName())
                && Objects.equals(description(), other.description())
                && Objects.equals(providerCalendarId(), other.providerCalendarId())
                && Objects.equals(profileArn(), other.profileArn());
    }

    @Override
    public String toString() {
        return ToString.builder("Room").add("RoomArn", roomArn()).add("RoomName", roomName()).add("Description", description())
                .add("ProviderCalendarId", providerCalendarId()).add("ProfileArn", profileArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomArn":
            return Optional.ofNullable(clazz.cast(roomArn()));
        case "RoomName":
            return Optional.ofNullable(clazz.cast(roomName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ProviderCalendarId":
            return Optional.ofNullable(clazz.cast(providerCalendarId()));
        case "ProfileArn":
            return Optional.ofNullable(clazz.cast(profileArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Room, T> g) {
        return obj -> g.apply((Room) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Room> {
        /**
         * <p>
         * The ARN of a room.
         * </p>
         * 
         * @param roomArn
         *        The ARN of a room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomArn(String roomArn);

        /**
         * <p>
         * The name of a room.
         * </p>
         * 
         * @param roomName
         *        The name of a room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomName(String roomName);

        /**
         * <p>
         * The description of a room.
         * </p>
         * 
         * @param description
         *        The description of a room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The provider calendar ARN of a room.
         * </p>
         * 
         * @param providerCalendarId
         *        The provider calendar ARN of a room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerCalendarId(String providerCalendarId);

        /**
         * <p>
         * The profile ARN of a room.
         * </p>
         * 
         * @param profileArn
         *        The profile ARN of a room.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);
    }

    static final class BuilderImpl implements Builder {
        private String roomArn;

        private String roomName;

        private String description;

        private String providerCalendarId;

        private String profileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Room model) {
            roomArn(model.roomArn);
            roomName(model.roomName);
            description(model.description);
            providerCalendarId(model.providerCalendarId);
            profileArn(model.profileArn);
        }

        public final String getRoomArn() {
            return roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getRoomName() {
            return roomName;
        }

        @Override
        public final Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public final void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getProviderCalendarId() {
            return providerCalendarId;
        }

        @Override
        public final Builder providerCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
            return this;
        }

        public final void setProviderCalendarId(String providerCalendarId) {
            this.providerCalendarId = providerCalendarId;
        }

        public final String getProfileArn() {
            return profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public Room build() {
            return new Room(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
