/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBusinessReportScheduleResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<CreateBusinessReportScheduleResponse.Builder, CreateBusinessReportScheduleResponse> {
    private static final SdkField<String> SCHEDULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBusinessReportScheduleResponse::scheduleArn)).setter(setter(Builder::scheduleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_ARN_FIELD));

    private final String scheduleArn;

    private CreateBusinessReportScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.scheduleArn = builder.scheduleArn;
    }

    /**
     * <p>
     * The ARN of the business report schedule.
     * </p>
     * 
     * @return The ARN of the business report schedule.
     */
    public String scheduleArn() {
        return scheduleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBusinessReportScheduleResponse)) {
            return false;
        }
        CreateBusinessReportScheduleResponse other = (CreateBusinessReportScheduleResponse) obj;
        return Objects.equals(scheduleArn(), other.scheduleArn());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateBusinessReportScheduleResponse").add("ScheduleArn", scheduleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleArn":
            return Optional.ofNullable(clazz.cast(scheduleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBusinessReportScheduleResponse, T> g) {
        return obj -> g.apply((CreateBusinessReportScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateBusinessReportScheduleResponse> {
        /**
         * <p>
         * The ARN of the business report schedule.
         * </p>
         * 
         * @param scheduleArn
         *        The ARN of the business report schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleArn(String scheduleArn);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private String scheduleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBusinessReportScheduleResponse model) {
            super(model);
            scheduleArn(model.scheduleArn);
        }

        public final String getScheduleArn() {
            return scheduleArn;
        }

        @Override
        public final Builder scheduleArn(String scheduleArn) {
            this.scheduleArn = scheduleArn;
            return this;
        }

        public final void setScheduleArn(String scheduleArn) {
            this.scheduleArn = scheduleArn;
        }

        @Override
        public CreateBusinessReportScheduleResponse build() {
            return new CreateBusinessReportScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
