/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse;

public class SearchRoomsPublisher
implements SdkPublisher<SearchRoomsResponse> {
    private final AlexaForBusinessAsyncClient client;
    private final SearchRoomsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchRoomsPublisher(AlexaForBusinessAsyncClient client, SearchRoomsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchRoomsPublisher(AlexaForBusinessAsyncClient client, SearchRoomsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchRoomsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchRoomsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final SearchRoomsPublisher resume(SearchRoomsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new SearchRoomsPublisher(this.client, (SearchRoomsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new SearchRoomsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super SearchRoomsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class SearchRoomsResponseFetcher
    implements AsyncPageFetcher<SearchRoomsResponse> {
        private SearchRoomsResponseFetcher() {
        }

        public boolean hasNextPage(SearchRoomsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchRoomsResponse> nextPage(SearchRoomsResponse previousPage) {
            if (previousPage == null) {
                return SearchRoomsPublisher.this.client.searchRooms(SearchRoomsPublisher.this.firstRequest);
            }
            return SearchRoomsPublisher.this.client.searchRooms((SearchRoomsRequest)((Object)SearchRoomsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

