/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateSkillWithUsersRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<AssociateSkillWithUsersRequest.Builder, AssociateSkillWithUsersRequest> {
    private static final SdkField<String> ORGANIZATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateSkillWithUsersRequest::organizationArn)).setter(setter(Builder::organizationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationArn").build()).build();

    private static final SdkField<String> SKILL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateSkillWithUsersRequest::skillId)).setter(setter(Builder::skillId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ARN_FIELD,
            SKILL_ID_FIELD));

    private final String organizationArn;

    private final String skillId;

    private AssociateSkillWithUsersRequest(BuilderImpl builder) {
        super(builder);
        this.organizationArn = builder.organizationArn;
        this.skillId = builder.skillId;
    }

    /**
     * <p>
     * The ARN of the organization.
     * </p>
     * 
     * @return The ARN of the organization.
     */
    public String organizationArn() {
        return organizationArn;
    }

    /**
     * <p>
     * The private skill ID you want to make available to enrolled users.&gt;
     * </p>
     * 
     * @return The private skill ID you want to make available to enrolled users.&gt;
     */
    public String skillId() {
        return skillId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationArn());
        hashCode = 31 * hashCode + Objects.hashCode(skillId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSkillWithUsersRequest)) {
            return false;
        }
        AssociateSkillWithUsersRequest other = (AssociateSkillWithUsersRequest) obj;
        return Objects.equals(organizationArn(), other.organizationArn()) && Objects.equals(skillId(), other.skillId());
    }

    @Override
    public String toString() {
        return ToString.builder("AssociateSkillWithUsersRequest").add("OrganizationArn", organizationArn())
                .add("SkillId", skillId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationArn":
            return Optional.ofNullable(clazz.cast(organizationArn()));
        case "SkillId":
            return Optional.ofNullable(clazz.cast(skillId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateSkillWithUsersRequest, T> g) {
        return obj -> g.apply((AssociateSkillWithUsersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateSkillWithUsersRequest> {
        /**
         * <p>
         * The ARN of the organization.
         * </p>
         * 
         * @param organizationArn
         *        The ARN of the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationArn(String organizationArn);

        /**
         * <p>
         * The private skill ID you want to make available to enrolled users.&gt;
         * </p>
         * 
         * @param skillId
         *        The private skill ID you want to make available to enrolled users.&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillId(String skillId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String organizationArn;

        private String skillId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSkillWithUsersRequest model) {
            super(model);
            organizationArn(model.organizationArn);
            skillId(model.skillId);
        }

        public final String getOrganizationArn() {
            return organizationArn;
        }

        @Override
        public final Builder organizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
            return this;
        }

        public final void setOrganizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
        }

        public final String getSkillId() {
            return skillId;
        }

        @Override
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSkillWithUsersRequest build() {
            return new AssociateSkillWithUsersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
