/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConferenceProviderRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<CreateConferenceProviderRequest.Builder, CreateConferenceProviderRequest> {
    private static final SdkField<String> CONFERENCE_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateConferenceProviderRequest::conferenceProviderName))
            .setter(setter(Builder::conferenceProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConferenceProviderName").build())
            .build();

    private static final SdkField<String> CONFERENCE_PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateConferenceProviderRequest::conferenceProviderTypeAsString))
            .setter(setter(Builder::conferenceProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConferenceProviderType").build())
            .build();

    private static final SdkField<IPDialIn> IP_DIAL_IN_FIELD = SdkField.<IPDialIn> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateConferenceProviderRequest::ipDialIn)).setter(setter(Builder::ipDialIn))
            .constructor(IPDialIn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPDialIn").build()).build();

    private static final SdkField<PSTNDialIn> PSTN_DIAL_IN_FIELD = SdkField.<PSTNDialIn> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateConferenceProviderRequest::pstnDialIn)).setter(setter(Builder::pstnDialIn))
            .constructor(PSTNDialIn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PSTNDialIn").build()).build();

    private static final SdkField<MeetingSetting> MEETING_SETTING_FIELD = SdkField
            .<MeetingSetting> builder(MarshallingType.SDK_POJO).getter(getter(CreateConferenceProviderRequest::meetingSetting))
            .setter(setter(Builder::meetingSetting)).constructor(MeetingSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingSetting").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateConferenceProviderRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFERENCE_PROVIDER_NAME_FIELD, CONFERENCE_PROVIDER_TYPE_FIELD, IP_DIAL_IN_FIELD, PSTN_DIAL_IN_FIELD,
            MEETING_SETTING_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String conferenceProviderName;

    private final String conferenceProviderType;

    private final IPDialIn ipDialIn;

    private final PSTNDialIn pstnDialIn;

    private final MeetingSetting meetingSetting;

    private final String clientRequestToken;

    private CreateConferenceProviderRequest(BuilderImpl builder) {
        super(builder);
        this.conferenceProviderName = builder.conferenceProviderName;
        this.conferenceProviderType = builder.conferenceProviderType;
        this.ipDialIn = builder.ipDialIn;
        this.pstnDialIn = builder.pstnDialIn;
        this.meetingSetting = builder.meetingSetting;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the conference provider.
     * </p>
     * 
     * @return The name of the conference provider.
     */
    public String conferenceProviderName() {
        return conferenceProviderName;
    }

    /**
     * <p>
     * Represents a type within a list of predefined types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conferenceProviderType} will return {@link ConferenceProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conferenceProviderTypeAsString}.
     * </p>
     * 
     * @return Represents a type within a list of predefined types.
     * @see ConferenceProviderType
     */
    public ConferenceProviderType conferenceProviderType() {
        return ConferenceProviderType.fromValue(conferenceProviderType);
    }

    /**
     * <p>
     * Represents a type within a list of predefined types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conferenceProviderType} will return {@link ConferenceProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conferenceProviderTypeAsString}.
     * </p>
     * 
     * @return Represents a type within a list of predefined types.
     * @see ConferenceProviderType
     */
    public String conferenceProviderTypeAsString() {
        return conferenceProviderType;
    }

    /**
     * <p>
     * The IP endpoint and protocol for calling.
     * </p>
     * 
     * @return The IP endpoint and protocol for calling.
     */
    public IPDialIn ipDialIn() {
        return ipDialIn;
    }

    /**
     * <p>
     * The information for PSTN conferencing.
     * </p>
     * 
     * @return The information for PSTN conferencing.
     */
    public PSTNDialIn pstnDialIn() {
        return pstnDialIn;
    }

    /**
     * <p>
     * The meeting settings for the conference provider.
     * </p>
     * 
     * @return The meeting settings for the conference provider.
     */
    public MeetingSetting meetingSetting() {
        return meetingSetting;
    }

    /**
     * <p>
     * The request token of the client.
     * </p>
     * 
     * @return The request token of the client.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conferenceProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(conferenceProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipDialIn());
        hashCode = 31 * hashCode + Objects.hashCode(pstnDialIn());
        hashCode = 31 * hashCode + Objects.hashCode(meetingSetting());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConferenceProviderRequest)) {
            return false;
        }
        CreateConferenceProviderRequest other = (CreateConferenceProviderRequest) obj;
        return Objects.equals(conferenceProviderName(), other.conferenceProviderName())
                && Objects.equals(conferenceProviderTypeAsString(), other.conferenceProviderTypeAsString())
                && Objects.equals(ipDialIn(), other.ipDialIn()) && Objects.equals(pstnDialIn(), other.pstnDialIn())
                && Objects.equals(meetingSetting(), other.meetingSetting())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateConferenceProviderRequest").add("ConferenceProviderName", conferenceProviderName())
                .add("ConferenceProviderType", conferenceProviderTypeAsString()).add("IPDialIn", ipDialIn())
                .add("PSTNDialIn", pstnDialIn()).add("MeetingSetting", meetingSetting())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConferenceProviderName":
            return Optional.ofNullable(clazz.cast(conferenceProviderName()));
        case "ConferenceProviderType":
            return Optional.ofNullable(clazz.cast(conferenceProviderTypeAsString()));
        case "IPDialIn":
            return Optional.ofNullable(clazz.cast(ipDialIn()));
        case "PSTNDialIn":
            return Optional.ofNullable(clazz.cast(pstnDialIn()));
        case "MeetingSetting":
            return Optional.ofNullable(clazz.cast(meetingSetting()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConferenceProviderRequest, T> g) {
        return obj -> g.apply((CreateConferenceProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConferenceProviderRequest> {
        /**
         * <p>
         * The name of the conference provider.
         * </p>
         * 
         * @param conferenceProviderName
         *        The name of the conference provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conferenceProviderName(String conferenceProviderName);

        /**
         * <p>
         * Represents a type within a list of predefined types.
         * </p>
         * 
         * @param conferenceProviderType
         *        Represents a type within a list of predefined types.
         * @see ConferenceProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConferenceProviderType
         */
        Builder conferenceProviderType(String conferenceProviderType);

        /**
         * <p>
         * Represents a type within a list of predefined types.
         * </p>
         * 
         * @param conferenceProviderType
         *        Represents a type within a list of predefined types.
         * @see ConferenceProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConferenceProviderType
         */
        Builder conferenceProviderType(ConferenceProviderType conferenceProviderType);

        /**
         * <p>
         * The IP endpoint and protocol for calling.
         * </p>
         * 
         * @param ipDialIn
         *        The IP endpoint and protocol for calling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipDialIn(IPDialIn ipDialIn);

        /**
         * <p>
         * The IP endpoint and protocol for calling.
         * </p>
         * This is a convenience that creates an instance of the {@link IPDialIn.Builder} avoiding the need to create
         * one manually via {@link IPDialIn#builder()}.
         *
         * When the {@link Consumer} completes, {@link IPDialIn.Builder#build()} is called immediately and its result is
         * passed to {@link #ipDialIn(IPDialIn)}.
         * 
         * @param ipDialIn
         *        a consumer that will call methods on {@link IPDialIn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipDialIn(IPDialIn)
         */
        default Builder ipDialIn(Consumer<IPDialIn.Builder> ipDialIn) {
            return ipDialIn(IPDialIn.builder().applyMutation(ipDialIn).build());
        }

        /**
         * <p>
         * The information for PSTN conferencing.
         * </p>
         * 
         * @param pstnDialIn
         *        The information for PSTN conferencing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pstnDialIn(PSTNDialIn pstnDialIn);

        /**
         * <p>
         * The information for PSTN conferencing.
         * </p>
         * This is a convenience that creates an instance of the {@link PSTNDialIn.Builder} avoiding the need to create
         * one manually via {@link PSTNDialIn#builder()}.
         *
         * When the {@link Consumer} completes, {@link PSTNDialIn.Builder#build()} is called immediately and its result
         * is passed to {@link #pstnDialIn(PSTNDialIn)}.
         * 
         * @param pstnDialIn
         *        a consumer that will call methods on {@link PSTNDialIn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pstnDialIn(PSTNDialIn)
         */
        default Builder pstnDialIn(Consumer<PSTNDialIn.Builder> pstnDialIn) {
            return pstnDialIn(PSTNDialIn.builder().applyMutation(pstnDialIn).build());
        }

        /**
         * <p>
         * The meeting settings for the conference provider.
         * </p>
         * 
         * @param meetingSetting
         *        The meeting settings for the conference provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingSetting(MeetingSetting meetingSetting);

        /**
         * <p>
         * The meeting settings for the conference provider.
         * </p>
         * This is a convenience that creates an instance of the {@link MeetingSetting.Builder} avoiding the need to
         * create one manually via {@link MeetingSetting#builder()}.
         *
         * When the {@link Consumer} completes, {@link MeetingSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #meetingSetting(MeetingSetting)}.
         * 
         * @param meetingSetting
         *        a consumer that will call methods on {@link MeetingSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meetingSetting(MeetingSetting)
         */
        default Builder meetingSetting(Consumer<MeetingSetting.Builder> meetingSetting) {
            return meetingSetting(MeetingSetting.builder().applyMutation(meetingSetting).build());
        }

        /**
         * <p>
         * The request token of the client.
         * </p>
         * 
         * @param clientRequestToken
         *        The request token of the client.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String conferenceProviderName;

        private String conferenceProviderType;

        private IPDialIn ipDialIn;

        private PSTNDialIn pstnDialIn;

        private MeetingSetting meetingSetting;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConferenceProviderRequest model) {
            super(model);
            conferenceProviderName(model.conferenceProviderName);
            conferenceProviderType(model.conferenceProviderType);
            ipDialIn(model.ipDialIn);
            pstnDialIn(model.pstnDialIn);
            meetingSetting(model.meetingSetting);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getConferenceProviderName() {
            return conferenceProviderName;
        }

        @Override
        public final Builder conferenceProviderName(String conferenceProviderName) {
            this.conferenceProviderName = conferenceProviderName;
            return this;
        }

        public final void setConferenceProviderName(String conferenceProviderName) {
            this.conferenceProviderName = conferenceProviderName;
        }

        public final String getConferenceProviderTypeAsString() {
            return conferenceProviderType;
        }

        @Override
        public final Builder conferenceProviderType(String conferenceProviderType) {
            this.conferenceProviderType = conferenceProviderType;
            return this;
        }

        @Override
        public final Builder conferenceProviderType(ConferenceProviderType conferenceProviderType) {
            this.conferenceProviderType(conferenceProviderType.toString());
            return this;
        }

        public final void setConferenceProviderType(String conferenceProviderType) {
            this.conferenceProviderType = conferenceProviderType;
        }

        public final IPDialIn.Builder getIpDialIn() {
            return ipDialIn != null ? ipDialIn.toBuilder() : null;
        }

        @Override
        public final Builder ipDialIn(IPDialIn ipDialIn) {
            this.ipDialIn = ipDialIn;
            return this;
        }

        public final void setIpDialIn(IPDialIn.BuilderImpl ipDialIn) {
            this.ipDialIn = ipDialIn != null ? ipDialIn.build() : null;
        }

        public final PSTNDialIn.Builder getPstnDialIn() {
            return pstnDialIn != null ? pstnDialIn.toBuilder() : null;
        }

        @Override
        public final Builder pstnDialIn(PSTNDialIn pstnDialIn) {
            this.pstnDialIn = pstnDialIn;
            return this;
        }

        public final void setPstnDialIn(PSTNDialIn.BuilderImpl pstnDialIn) {
            this.pstnDialIn = pstnDialIn != null ? pstnDialIn.build() : null;
        }

        public final MeetingSetting.Builder getMeetingSetting() {
            return meetingSetting != null ? meetingSetting.toBuilder() : null;
        }

        @Override
        public final Builder meetingSetting(MeetingSetting meetingSetting) {
            this.meetingSetting = meetingSetting;
            return this;
        }

        public final void setMeetingSetting(MeetingSetting.BuilderImpl meetingSetting) {
            this.meetingSetting = meetingSetting != null ? meetingSetting.build() : null;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConferenceProviderRequest build() {
            return new CreateConferenceProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
