/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContactRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<CreateContactRequest.Builder, CreateContactRequest> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateContactRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateContactRequest::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateContactRequest::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateContactRequest::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateContactRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD,
            FIRST_NAME_FIELD, LAST_NAME_FIELD, PHONE_NUMBER_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String displayName;

    private final String firstName;

    private final String lastName;

    private final String phoneNumber;

    private final String clientRequestToken;

    private CreateContactRequest(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.phoneNumber = builder.phoneNumber;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the contact to display on the console.
     * </p>
     * 
     * @return The name of the contact to display on the console.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The first name of the contact that is used to call the contact on the device.
     * </p>
     * 
     * @return The first name of the contact that is used to call the contact on the device.
     */
    public String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The last name of the contact that is used to call the contact on the device.
     * </p>
     * 
     * @return The last name of the contact that is used to call the contact on the device.
     */
    public String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The phone number of the contact in E.164 format.
     * </p>
     * 
     * @return The phone number of the contact in E.164 format.
     */
    public String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * A unique, user-specified identifier for this request that ensures idempotency.
     * </p>
     * 
     * @return A unique, user-specified identifier for this request that ensures idempotency.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactRequest)) {
            return false;
        }
        CreateContactRequest other = (CreateContactRequest) obj;
        return Objects.equals(displayName(), other.displayName()) && Objects.equals(firstName(), other.firstName())
                && Objects.equals(lastName(), other.lastName()) && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateContactRequest").add("DisplayName", displayName()).add("FirstName", firstName())
                .add("LastName", lastName()).add("PhoneNumber", phoneNumber()).add("ClientRequestToken", clientRequestToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContactRequest, T> g) {
        return obj -> g.apply((CreateContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateContactRequest> {
        /**
         * <p>
         * The name of the contact to display on the console.
         * </p>
         * 
         * @param displayName
         *        The name of the contact to display on the console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The first name of the contact that is used to call the contact on the device.
         * </p>
         * 
         * @param firstName
         *        The first name of the contact that is used to call the contact on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The last name of the contact that is used to call the contact on the device.
         * </p>
         * 
         * @param lastName
         *        The last name of the contact that is used to call the contact on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The phone number of the contact in E.164 format.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number of the contact in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * A unique, user-specified identifier for this request that ensures idempotency.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, user-specified identifier for this request that ensures idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String displayName;

        private String firstName;

        private String lastName;

        private String phoneNumber;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactRequest model) {
            super(model);
            displayName(model.displayName);
            firstName(model.firstName);
            lastName(model.lastName);
            phoneNumber(model.phoneNumber);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getFirstName() {
            return firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public final String getLastName() {
            return lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContactRequest build() {
            return new CreateContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
