/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConferenceProviderResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<GetConferenceProviderResponse.Builder, GetConferenceProviderResponse> {
    private static final SdkField<ConferenceProvider> CONFERENCE_PROVIDER_FIELD = SdkField
            .<ConferenceProvider> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetConferenceProviderResponse::conferenceProvider)).setter(setter(Builder::conferenceProvider))
            .constructor(ConferenceProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConferenceProvider").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFERENCE_PROVIDER_FIELD));

    private final ConferenceProvider conferenceProvider;

    private GetConferenceProviderResponse(BuilderImpl builder) {
        super(builder);
        this.conferenceProvider = builder.conferenceProvider;
    }

    /**
     * <p>
     * The conference provider.
     * </p>
     * 
     * @return The conference provider.
     */
    public ConferenceProvider conferenceProvider() {
        return conferenceProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conferenceProvider());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConferenceProviderResponse)) {
            return false;
        }
        GetConferenceProviderResponse other = (GetConferenceProviderResponse) obj;
        return Objects.equals(conferenceProvider(), other.conferenceProvider());
    }

    @Override
    public String toString() {
        return ToString.builder("GetConferenceProviderResponse").add("ConferenceProvider", conferenceProvider()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConferenceProvider":
            return Optional.ofNullable(clazz.cast(conferenceProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConferenceProviderResponse, T> g) {
        return obj -> g.apply((GetConferenceProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConferenceProviderResponse> {
        /**
         * <p>
         * The conference provider.
         * </p>
         * 
         * @param conferenceProvider
         *        The conference provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conferenceProvider(ConferenceProvider conferenceProvider);

        /**
         * <p>
         * The conference provider.
         * </p>
         * This is a convenience that creates an instance of the {@link ConferenceProvider.Builder} avoiding the need to
         * create one manually via {@link ConferenceProvider#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConferenceProvider.Builder#build()} is called immediately and its
         * result is passed to {@link #conferenceProvider(ConferenceProvider)}.
         * 
         * @param conferenceProvider
         *        a consumer that will call methods on {@link ConferenceProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conferenceProvider(ConferenceProvider)
         */
        default Builder conferenceProvider(Consumer<ConferenceProvider.Builder> conferenceProvider) {
            return conferenceProvider(ConferenceProvider.builder().applyMutation(conferenceProvider).build());
        }
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private ConferenceProvider conferenceProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConferenceProviderResponse model) {
            super(model);
            conferenceProvider(model.conferenceProvider);
        }

        public final ConferenceProvider.Builder getConferenceProvider() {
            return conferenceProvider != null ? conferenceProvider.toBuilder() : null;
        }

        @Override
        public final Builder conferenceProvider(ConferenceProvider conferenceProvider) {
            this.conferenceProvider = conferenceProvider;
            return this;
        }

        public final void setConferenceProvider(ConferenceProvider.BuilderImpl conferenceProvider) {
            this.conferenceProvider = conferenceProvider != null ? conferenceProvider.build() : null;
        }

        @Override
        public GetConferenceProviderResponse build() {
            return new GetConferenceProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
