/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The IP endpoint and protocol for calling.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IPDialIn implements SdkPojo, Serializable, ToCopyableBuilder<IPDialIn.Builder, IPDialIn> {
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IPDialIn::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<String> COMMS_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IPDialIn::commsProtocolAsString)).setter(setter(Builder::commsProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommsProtocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_FIELD,
            COMMS_PROTOCOL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpoint;

    private final String commsProtocol;

    private IPDialIn(BuilderImpl builder) {
        this.endpoint = builder.endpoint;
        this.commsProtocol = builder.commsProtocol;
    }

    /**
     * <p>
     * The IP address.
     * </p>
     * 
     * @return The IP address.
     */
    public String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The protocol, including SIP, SIPS, and H323.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #commsProtocol}
     * will return {@link CommsProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #commsProtocolAsString}.
     * </p>
     * 
     * @return The protocol, including SIP, SIPS, and H323.
     * @see CommsProtocol
     */
    public CommsProtocol commsProtocol() {
        return CommsProtocol.fromValue(commsProtocol);
    }

    /**
     * <p>
     * The protocol, including SIP, SIPS, and H323.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #commsProtocol}
     * will return {@link CommsProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #commsProtocolAsString}.
     * </p>
     * 
     * @return The protocol, including SIP, SIPS, and H323.
     * @see CommsProtocol
     */
    public String commsProtocolAsString() {
        return commsProtocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(commsProtocolAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPDialIn)) {
            return false;
        }
        IPDialIn other = (IPDialIn) obj;
        return Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(commsProtocolAsString(), other.commsProtocolAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("IPDialIn").add("Endpoint", endpoint()).add("CommsProtocol", commsProtocolAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "CommsProtocol":
            return Optional.ofNullable(clazz.cast(commsProtocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IPDialIn, T> g) {
        return obj -> g.apply((IPDialIn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IPDialIn> {
        /**
         * <p>
         * The IP address.
         * </p>
         * 
         * @param endpoint
         *        The IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The protocol, including SIP, SIPS, and H323.
         * </p>
         * 
         * @param commsProtocol
         *        The protocol, including SIP, SIPS, and H323.
         * @see CommsProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommsProtocol
         */
        Builder commsProtocol(String commsProtocol);

        /**
         * <p>
         * The protocol, including SIP, SIPS, and H323.
         * </p>
         * 
         * @param commsProtocol
         *        The protocol, including SIP, SIPS, and H323.
         * @see CommsProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommsProtocol
         */
        Builder commsProtocol(CommsProtocol commsProtocol);
    }

    static final class BuilderImpl implements Builder {
        private String endpoint;

        private String commsProtocol;

        private BuilderImpl() {
        }

        private BuilderImpl(IPDialIn model) {
            endpoint(model.endpoint);
            commsProtocol(model.commsProtocol);
        }

        public final String getEndpoint() {
            return endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getCommsProtocolAsString() {
            return commsProtocol;
        }

        @Override
        public final Builder commsProtocol(String commsProtocol) {
            this.commsProtocol = commsProtocol;
            return this;
        }

        @Override
        public final Builder commsProtocol(CommsProtocol commsProtocol) {
            this.commsProtocol(commsProtocol.toString());
            return this;
        }

        public final void setCommsProtocol(String commsProtocol) {
            this.commsProtocol = commsProtocol;
        }

        @Override
        public IPDialIn build() {
            return new IPDialIn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
