/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse;

public class SearchProfilesPublisher
implements SdkPublisher<SearchProfilesResponse> {
    private final AlexaForBusinessAsyncClient client;
    private final SearchProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchProfilesPublisher(AlexaForBusinessAsyncClient client, SearchProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchProfilesPublisher(AlexaForBusinessAsyncClient client, SearchProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final SearchProfilesPublisher resume(SearchProfilesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new SearchProfilesPublisher(this.client, (SearchProfilesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new SearchProfilesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super SearchProfilesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class SearchProfilesResponseFetcher
    implements AsyncPageFetcher<SearchProfilesResponse> {
        private SearchProfilesResponseFetcher() {
        }

        public boolean hasNextPage(SearchProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchProfilesResponse> nextPage(SearchProfilesResponse previousPage) {
            if (previousPage == null) {
                return SearchProfilesPublisher.this.client.searchProfiles(SearchProfilesPublisher.this.firstRequest);
            }
            return SearchProfilesPublisher.this.client.searchProfiles((SearchProfilesRequest)((Object)SearchProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

