/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse;

public class ListSkillsIterable
implements SdkIterable<ListSkillsResponse> {
    private final AlexaForBusinessClient client;
    private final ListSkillsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSkillsIterable(AlexaForBusinessClient client, ListSkillsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSkillsResponseFetcher();
    }

    public Iterator<ListSkillsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListSkillsIterable resume(ListSkillsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSkillsIterable(this.client, (ListSkillsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListSkillsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListSkillsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListSkillsResponseFetcher
    implements SyncPageFetcher<ListSkillsResponse> {
        private ListSkillsResponseFetcher() {
        }

        public boolean hasNextPage(ListSkillsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSkillsResponse nextPage(ListSkillsResponse previousPage) {
            if (previousPage == null) {
                return ListSkillsIterable.this.client.listSkills(ListSkillsIterable.this.firstRequest);
            }
            return ListSkillsIterable.this.client.listSkills((ListSkillsRequest)((Object)ListSkillsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

