/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse;

public class ListSkillsPublisher
implements SdkPublisher<ListSkillsResponse> {
    private final AlexaForBusinessAsyncClient client;
    private final ListSkillsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSkillsPublisher(AlexaForBusinessAsyncClient client, ListSkillsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSkillsPublisher(AlexaForBusinessAsyncClient client, ListSkillsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSkillsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSkillsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListSkillsPublisher resume(ListSkillsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSkillsPublisher(this.client, (ListSkillsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListSkillsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListSkillsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListSkillsResponseFetcher
    implements AsyncPageFetcher<ListSkillsResponse> {
        private ListSkillsResponseFetcher() {
        }

        public boolean hasNextPage(ListSkillsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSkillsResponse> nextPage(ListSkillsResponse previousPage) {
            if (previousPage == null) {
                return ListSkillsPublisher.this.client.listSkills(ListSkillsPublisher.this.firstRequest);
            }
            return ListSkillsPublisher.this.client.listSkills((ListSkillsRequest)((Object)ListSkillsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

