/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSkillsRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<ListSkillsRequest.Builder, ListSkillsRequest> {
    private static final SdkField<String> SKILL_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSkillsRequest::skillGroupArn)).setter(setter(Builder::skillGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillGroupArn").build()).build();

    private static final SdkField<String> ENABLEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSkillsRequest::enablementTypeAsString)).setter(setter(Builder::enablementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablementType").build()).build();

    private static final SdkField<String> SKILL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSkillsRequest::skillTypeAsString)).setter(setter(Builder::skillType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSkillsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListSkillsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILL_GROUP_ARN_FIELD,
            ENABLEMENT_TYPE_FIELD, SKILL_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String skillGroupArn;

    private final String enablementType;

    private final String skillType;

    private final String nextToken;

    private final Integer maxResults;

    private ListSkillsRequest(BuilderImpl builder) {
        super(builder);
        this.skillGroupArn = builder.skillGroupArn;
        this.enablementType = builder.enablementType;
        this.skillType = builder.skillType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ARN of the skill group for which to list enabled skills.
     * </p>
     * 
     * @return The ARN of the skill group for which to list enabled skills.
     */
    public String skillGroupArn() {
        return skillGroupArn;
    }

    /**
     * <p>
     * Whether the skill is enabled under the user's account, or if it requires linking to be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enablementType}
     * will return {@link EnablementTypeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #enablementTypeAsString}.
     * </p>
     * 
     * @return Whether the skill is enabled under the user's account, or if it requires linking to be used.
     * @see EnablementTypeFilter
     */
    public EnablementTypeFilter enablementType() {
        return EnablementTypeFilter.fromValue(enablementType);
    }

    /**
     * <p>
     * Whether the skill is enabled under the user's account, or if it requires linking to be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enablementType}
     * will return {@link EnablementTypeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #enablementTypeAsString}.
     * </p>
     * 
     * @return Whether the skill is enabled under the user's account, or if it requires linking to be used.
     * @see EnablementTypeFilter
     */
    public String enablementTypeAsString() {
        return enablementType;
    }

    /**
     * <p>
     * Whether the skill is publicly available or is a private skill.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #skillType} will
     * return {@link SkillTypeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #skillTypeAsString}.
     * </p>
     * 
     * @return Whether the skill is publicly available or is a private skill.
     * @see SkillTypeFilter
     */
    public SkillTypeFilter skillType() {
        return SkillTypeFilter.fromValue(skillType);
    }

    /**
     * <p>
     * Whether the skill is publicly available or is a private skill.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #skillType} will
     * return {@link SkillTypeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #skillTypeAsString}.
     * </p>
     * 
     * @return Whether the skill is publicly available or is a private skill.
     * @see SkillTypeFilter
     */
    public String skillTypeAsString() {
        return skillType;
    }

    /**
     * <p>
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If
     * this parameter is specified, the response includes only results beyond the token, up to the value specified by
     * <code>MaxResults</code>.
     * </p>
     * 
     * @return An optional token returned from a prior request. Use this token for pagination of results from this
     *         action. If this parameter is specified, the response includes only results beyond the token, up to the
     *         value specified by <code>MaxResults</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to include in the response. If more results exist than the specified
     * <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
     * retrieved.
     * </p>
     * 
     * @return The maximum number of results to include in the response. If more results exist than the specified
     *         <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
     *         retrieved.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skillGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(enablementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(skillTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSkillsRequest)) {
            return false;
        }
        ListSkillsRequest other = (ListSkillsRequest) obj;
        return Objects.equals(skillGroupArn(), other.skillGroupArn())
                && Objects.equals(enablementTypeAsString(), other.enablementTypeAsString())
                && Objects.equals(skillTypeAsString(), other.skillTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSkillsRequest").add("SkillGroupArn", skillGroupArn())
                .add("EnablementType", enablementTypeAsString()).add("SkillType", skillTypeAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillGroupArn":
            return Optional.ofNullable(clazz.cast(skillGroupArn()));
        case "EnablementType":
            return Optional.ofNullable(clazz.cast(enablementTypeAsString()));
        case "SkillType":
            return Optional.ofNullable(clazz.cast(skillTypeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSkillsRequest, T> g) {
        return obj -> g.apply((ListSkillsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSkillsRequest> {
        /**
         * <p>
         * The ARN of the skill group for which to list enabled skills.
         * </p>
         * 
         * @param skillGroupArn
         *        The ARN of the skill group for which to list enabled skills.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillGroupArn(String skillGroupArn);

        /**
         * <p>
         * Whether the skill is enabled under the user's account, or if it requires linking to be used.
         * </p>
         * 
         * @param enablementType
         *        Whether the skill is enabled under the user's account, or if it requires linking to be used.
         * @see EnablementTypeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnablementTypeFilter
         */
        Builder enablementType(String enablementType);

        /**
         * <p>
         * Whether the skill is enabled under the user's account, or if it requires linking to be used.
         * </p>
         * 
         * @param enablementType
         *        Whether the skill is enabled under the user's account, or if it requires linking to be used.
         * @see EnablementTypeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnablementTypeFilter
         */
        Builder enablementType(EnablementTypeFilter enablementType);

        /**
         * <p>
         * Whether the skill is publicly available or is a private skill.
         * </p>
         * 
         * @param skillType
         *        Whether the skill is publicly available or is a private skill.
         * @see SkillTypeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SkillTypeFilter
         */
        Builder skillType(String skillType);

        /**
         * <p>
         * Whether the skill is publicly available or is a private skill.
         * </p>
         * 
         * @param skillType
         *        Whether the skill is publicly available or is a private skill.
         * @see SkillTypeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SkillTypeFilter
         */
        Builder skillType(SkillTypeFilter skillType);

        /**
         * <p>
         * An optional token returned from a prior request. Use this token for pagination of results from this action.
         * If this parameter is specified, the response includes only results beyond the token, up to the value
         * specified by <code>MaxResults</code>.
         * </p>
         * 
         * @param nextToken
         *        An optional token returned from a prior request. Use this token for pagination of results from this
         *        action. If this parameter is specified, the response includes only results beyond the token, up to the
         *        value specified by <code>MaxResults</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to include in the response. If more results exist than the specified
         * <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
         * retrieved.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to include in the response. If more results exist than the specified
         *        <code>MaxResults</code> value, a token is included in the response so that the remaining results can
         *        be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String skillGroupArn;

        private String enablementType;

        private String skillType;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSkillsRequest model) {
            super(model);
            skillGroupArn(model.skillGroupArn);
            enablementType(model.enablementType);
            skillType(model.skillType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getSkillGroupArn() {
            return skillGroupArn;
        }

        @Override
        public final Builder skillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
            return this;
        }

        public final void setSkillGroupArn(String skillGroupArn) {
            this.skillGroupArn = skillGroupArn;
        }

        public final String getEnablementTypeAsString() {
            return enablementType;
        }

        @Override
        public final Builder enablementType(String enablementType) {
            this.enablementType = enablementType;
            return this;
        }

        @Override
        public final Builder enablementType(EnablementTypeFilter enablementType) {
            this.enablementType(enablementType.toString());
            return this;
        }

        public final void setEnablementType(String enablementType) {
            this.enablementType = enablementType;
        }

        public final String getSkillTypeAsString() {
            return skillType;
        }

        @Override
        public final Builder skillType(String skillType) {
            this.skillType = skillType;
            return this;
        }

        @Override
        public final Builder skillType(SkillTypeFilter skillType) {
            this.skillType(skillType.toString());
            return this;
        }

        public final void setSkillType(String skillType) {
            this.skillType = skillType;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSkillsRequest build() {
            return new ListSkillsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
