/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse;

public class ListBusinessReportSchedulesIterable
implements SdkIterable<ListBusinessReportSchedulesResponse> {
    private final AlexaForBusinessClient client;
    private final ListBusinessReportSchedulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBusinessReportSchedulesIterable(AlexaForBusinessClient client, ListBusinessReportSchedulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBusinessReportSchedulesResponseFetcher();
    }

    public Iterator<ListBusinessReportSchedulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListBusinessReportSchedulesIterable resume(ListBusinessReportSchedulesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListBusinessReportSchedulesIterable(this.client, (ListBusinessReportSchedulesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListBusinessReportSchedulesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListBusinessReportSchedulesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListBusinessReportSchedulesResponseFetcher
    implements SyncPageFetcher<ListBusinessReportSchedulesResponse> {
        private ListBusinessReportSchedulesResponseFetcher() {
        }

        public boolean hasNextPage(ListBusinessReportSchedulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBusinessReportSchedulesResponse nextPage(ListBusinessReportSchedulesResponse previousPage) {
            if (previousPage == null) {
                return ListBusinessReportSchedulesIterable.this.client.listBusinessReportSchedules(ListBusinessReportSchedulesIterable.this.firstRequest);
            }
            return ListBusinessReportSchedulesIterable.this.client.listBusinessReportSchedules((ListBusinessReportSchedulesRequest)((Object)ListBusinessReportSchedulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

