/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse;

public class ListConferenceProvidersPublisher
implements SdkPublisher<ListConferenceProvidersResponse> {
    private final AlexaForBusinessAsyncClient client;
    private final ListConferenceProvidersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConferenceProvidersPublisher(AlexaForBusinessAsyncClient client, ListConferenceProvidersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConferenceProvidersPublisher(AlexaForBusinessAsyncClient client, ListConferenceProvidersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConferenceProvidersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConferenceProvidersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListConferenceProvidersPublisher resume(ListConferenceProvidersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListConferenceProvidersPublisher(this.client, (ListConferenceProvidersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListConferenceProvidersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListConferenceProvidersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListConferenceProvidersResponseFetcher
    implements AsyncPageFetcher<ListConferenceProvidersResponse> {
        private ListConferenceProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListConferenceProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConferenceProvidersResponse> nextPage(ListConferenceProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListConferenceProvidersPublisher.this.client.listConferenceProviders(ListConferenceProvidersPublisher.this.firstRequest);
            }
            return ListConferenceProvidersPublisher.this.client.listConferenceProviders((ListConferenceProvidersRequest)((Object)ListConferenceProvidersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

