/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse;

public class ListTagsIterable
implements SdkIterable<ListTagsResponse> {
    private final AlexaForBusinessClient client;
    private final ListTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTagsIterable(AlexaForBusinessClient client, ListTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTagsResponseFetcher();
    }

    public Iterator<ListTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListTagsIterable resume(ListTagsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTagsIterable(this.client, (ListTagsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTagsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListTagsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListTagsResponseFetcher
    implements SyncPageFetcher<ListTagsResponse> {
        private ListTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTagsResponse nextPage(ListTagsResponse previousPage) {
            if (previousPage == null) {
                return ListTagsIterable.this.client.listTags(ListTagsIterable.this.firstRequest);
            }
            return ListTagsIterable.this.client.listTags((ListTagsRequest)((Object)ListTagsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

