/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content range of the report.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BusinessReportContentRange implements SdkPojo, Serializable,
        ToCopyableBuilder<BusinessReportContentRange.Builder, BusinessReportContentRange> {
    private static final SdkField<String> INTERVAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BusinessReportContentRange::intervalAsString)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERVAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String interval;

    private BusinessReportContentRange(BuilderImpl builder) {
        this.interval = builder.interval;
    }

    /**
     * <p>
     * The interval of the content range.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interval} will
     * return {@link BusinessReportInterval#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #intervalAsString}.
     * </p>
     * 
     * @return The interval of the content range.
     * @see BusinessReportInterval
     */
    public BusinessReportInterval interval() {
        return BusinessReportInterval.fromValue(interval);
    }

    /**
     * <p>
     * The interval of the content range.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interval} will
     * return {@link BusinessReportInterval#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #intervalAsString}.
     * </p>
     * 
     * @return The interval of the content range.
     * @see BusinessReportInterval
     */
    public String intervalAsString() {
        return interval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intervalAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BusinessReportContentRange)) {
            return false;
        }
        BusinessReportContentRange other = (BusinessReportContentRange) obj;
        return Objects.equals(intervalAsString(), other.intervalAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BusinessReportContentRange").add("Interval", intervalAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Interval":
            return Optional.ofNullable(clazz.cast(intervalAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BusinessReportContentRange, T> g) {
        return obj -> g.apply((BusinessReportContentRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BusinessReportContentRange> {
        /**
         * <p>
         * The interval of the content range.
         * </p>
         * 
         * @param interval
         *        The interval of the content range.
         * @see BusinessReportInterval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BusinessReportInterval
         */
        Builder interval(String interval);

        /**
         * <p>
         * The interval of the content range.
         * </p>
         * 
         * @param interval
         *        The interval of the content range.
         * @see BusinessReportInterval
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BusinessReportInterval
         */
        Builder interval(BusinessReportInterval interval);
    }

    static final class BuilderImpl implements Builder {
        private String interval;

        private BuilderImpl() {
        }

        private BuilderImpl(BusinessReportContentRange model) {
            interval(model.interval);
        }

        public final String getIntervalAsString() {
            return interval;
        }

        @Override
        public final Builder interval(String interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public final Builder interval(BusinessReportInterval interval) {
            this.interval(interval.toString());
            return this;
        }

        public final void setInterval(String interval) {
            this.interval = interval;
        }

        @Override
        public BusinessReportContentRange build() {
            return new BusinessReportContentRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
