/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse;

public class ListSkillsStoreCategoriesIterable
implements SdkIterable<ListSkillsStoreCategoriesResponse> {
    private final AlexaForBusinessClient client;
    private final ListSkillsStoreCategoriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSkillsStoreCategoriesIterable(AlexaForBusinessClient client, ListSkillsStoreCategoriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSkillsStoreCategoriesResponseFetcher();
    }

    public Iterator<ListSkillsStoreCategoriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListSkillsStoreCategoriesIterable resume(ListSkillsStoreCategoriesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSkillsStoreCategoriesIterable(this.client, (ListSkillsStoreCategoriesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListSkillsStoreCategoriesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListSkillsStoreCategoriesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListSkillsStoreCategoriesResponseFetcher
    implements SyncPageFetcher<ListSkillsStoreCategoriesResponse> {
        private ListSkillsStoreCategoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListSkillsStoreCategoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSkillsStoreCategoriesResponse nextPage(ListSkillsStoreCategoriesResponse previousPage) {
            if (previousPage == null) {
                return ListSkillsStoreCategoriesIterable.this.client.listSkillsStoreCategories(ListSkillsStoreCategoriesIterable.this.firstRequest);
            }
            return ListSkillsStoreCategoriesIterable.this.client.listSkillsStoreCategories((ListSkillsStoreCategoriesRequest)((Object)ListSkillsStoreCategoriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

