/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse;

public class SearchDevicesPublisher
implements SdkPublisher<SearchDevicesResponse> {
    private final AlexaForBusinessAsyncClient client;
    private final SearchDevicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchDevicesPublisher(AlexaForBusinessAsyncClient client, SearchDevicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchDevicesPublisher(AlexaForBusinessAsyncClient client, SearchDevicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchDevicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchDevicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final SearchDevicesPublisher resume(SearchDevicesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new SearchDevicesPublisher(this.client, (SearchDevicesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new SearchDevicesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super SearchDevicesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class SearchDevicesResponseFetcher
    implements AsyncPageFetcher<SearchDevicesResponse> {
        private SearchDevicesResponseFetcher() {
        }

        public boolean hasNextPage(SearchDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchDevicesResponse> nextPage(SearchDevicesResponse previousPage) {
            if (previousPage == null) {
                return SearchDevicesPublisher.this.client.searchDevices(SearchDevicesPublisher.this.firstRequest);
            }
            return SearchDevicesPublisher.this.client.searchDevices((SearchDevicesRequest)((Object)SearchDevicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

