/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse;

public class SearchUsersIterable
implements SdkIterable<SearchUsersResponse> {
    private final AlexaForBusinessClient client;
    private final SearchUsersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchUsersIterable(AlexaForBusinessClient client, SearchUsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchUsersResponseFetcher();
    }

    public Iterator<SearchUsersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final SearchUsersIterable resume(SearchUsersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new SearchUsersIterable(this.client, (SearchUsersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new SearchUsersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<SearchUsersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class SearchUsersResponseFetcher
    implements SyncPageFetcher<SearchUsersResponse> {
        private SearchUsersResponseFetcher() {
        }

        public boolean hasNextPage(SearchUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchUsersResponse nextPage(SearchUsersResponse previousPage) {
            if (previousPage == null) {
                return SearchUsersIterable.this.client.searchUsers(SearchUsersIterable.this.firstRequest);
            }
            return SearchUsersIterable.this.client.searchUsers((SearchUsersRequest)((Object)SearchUsersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

