/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse;

public class SearchRoomsIterable
implements SdkIterable<SearchRoomsResponse> {
    private final AlexaForBusinessClient client;
    private final SearchRoomsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchRoomsIterable(AlexaForBusinessClient client, SearchRoomsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchRoomsResponseFetcher();
    }

    public Iterator<SearchRoomsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class SearchRoomsResponseFetcher
    implements SyncPageFetcher<SearchRoomsResponse> {
        private SearchRoomsResponseFetcher() {
        }

        public boolean hasNextPage(SearchRoomsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchRoomsResponse nextPage(SearchRoomsResponse previousPage) {
            if (previousPage == null) {
                return SearchRoomsIterable.this.client.searchRooms(SearchRoomsIterable.this.firstRequest);
            }
            return SearchRoomsIterable.this.client.searchRooms((SearchRoomsRequest)((Object)SearchRoomsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

