/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessException;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AlreadyExistsException;
import software.amazon.awssdk.services.alexaforbusiness.model.ApproveSkillRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ApproveSkillResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateContactWithAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateContactWithAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithUsersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ConcurrentModificationException;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateUserRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateUserResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteBusinessReportScheduleRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteBusinessReportScheduleResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillAuthorizationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillAuthorizationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceNotRegisteredException;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateContactFromAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateContactFromAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromUsersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ForgetSmartHomeAppliancesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferencePreferenceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferencePreferenceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetInvitationConfigurationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetInvitationConfigurationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.InvalidCertificateAuthorityException;
import software.amazon.awssdk.services.alexaforbusiness.model.InvalidDeviceException;
import software.amazon.awssdk.services.alexaforbusiness.model.InvalidUserStatusException;
import software.amazon.awssdk.services.alexaforbusiness.model.LimitExceededException;
import software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.NameInUseException;
import software.amazon.awssdk.services.alexaforbusiness.model.NotFoundException;
import software.amazon.awssdk.services.alexaforbusiness.model.PutConferencePreferenceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutConferencePreferenceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.PutInvitationConfigurationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutInvitationConfigurationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.PutSkillAuthorizationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutSkillAuthorizationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.RejectSkillRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.RejectSkillResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ResourceAssociatedException;
import software.amazon.awssdk.services.alexaforbusiness.model.ResourceInUseException;
import software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillNotLinkedException;
import software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.TagResourceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.TagResourceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UnauthorizedException;
import software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateBusinessReportScheduleRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateBusinessReportScheduleResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsIterable;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersIterable;
import software.amazon.awssdk.services.alexaforbusiness.transform.ApproveSkillRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.AssociateContactWithAddressBookRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.AssociateDeviceWithRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.AssociateSkillGroupWithRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.AssociateSkillWithSkillGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.AssociateSkillWithUsersRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateAddressBookRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateBusinessReportScheduleRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateConferenceProviderRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateContactRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateGatewayGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateSkillGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteAddressBookRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteBusinessReportScheduleRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteConferenceProviderRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteContactRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteDeviceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteGatewayGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteRoomSkillParameterRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteSkillAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteSkillGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DisassociateContactFromAddressBookRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DisassociateDeviceFromRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DisassociateSkillFromSkillGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DisassociateSkillFromUsersRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DisassociateSkillGroupFromRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ForgetSmartHomeAppliancesRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetAddressBookRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetConferencePreferenceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetConferenceProviderRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetContactRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetDeviceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetGatewayGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetGatewayRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetInvitationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetRoomSkillParameterRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetSkillGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListBusinessReportSchedulesRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListConferenceProvidersRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListDeviceEventsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListGatewayGroupsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListGatewaysRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListSkillsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListSkillsStoreCategoriesRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListSkillsStoreSkillsByCategoryRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListSmartHomeAppliancesRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.PutConferencePreferenceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.PutInvitationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.PutRoomSkillParameterRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.PutSkillAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.RegisterAvsDeviceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.RejectSkillRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ResolveRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.RevokeInvitationRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchAddressBooksRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchContactsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchDevicesRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchProfilesRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchRoomsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchSkillGroupsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchUsersRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SendInvitationRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.StartDeviceSyncRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.StartSmartHomeApplianceDiscoveryRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateAddressBookRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateBusinessReportScheduleRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateConferenceProviderRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateContactRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateDeviceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateGatewayGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateGatewayRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateSkillGroupRequestMarshaller;

/**
 * Internal implementation of {@link AlexaForBusinessClient}.
 *
 * @see AlexaForBusinessClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultAlexaForBusinessClient implements AlexaForBusinessClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAlexaForBusinessClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Associates a skill with the organization under the customer's AWS account. If a skill is private, the user
     * implicitly accepts access to this skill during enablement.
     * </p>
     *
     * @param approveSkillRequest
     * @return Result of the ApproveSkill operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ApproveSkill
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ApproveSkill" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ApproveSkillResponse approveSkill(ApproveSkillRequest approveSkillRequest) throws LimitExceededException,
            NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ApproveSkillResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ApproveSkillResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ApproveSkillRequest, ApproveSkillResponse>()
                .withOperationName("ApproveSkill").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(approveSkillRequest)
                .withMarshaller(new ApproveSkillRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Associates a contact with a given address book.
     * </p>
     *
     * @param associateContactWithAddressBookRequest
     * @return Result of the AssociateContactWithAddressBook operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateContactWithAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateContactWithAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateContactWithAddressBookResponse associateContactWithAddressBook(
            AssociateContactWithAddressBookRequest associateContactWithAddressBookRequest) throws LimitExceededException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateContactWithAddressBookResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateContactWithAddressBookResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<AssociateContactWithAddressBookRequest, AssociateContactWithAddressBookResponse>()
                        .withOperationName("AssociateContactWithAddressBook").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(associateContactWithAddressBookRequest)
                        .withMarshaller(new AssociateContactWithAddressBookRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Associates a device with a given room. This applies all the settings from the room profile to the device, and all
     * the skills in any skill groups added to that room. This operation requires the device to be online, or else a
     * manual sync is required.
     * </p>
     *
     * @param associateDeviceWithRoomRequest
     * @return Result of the AssociateDeviceWithRoom operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateDeviceWithRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateDeviceWithRoomResponse associateDeviceWithRoom(AssociateDeviceWithRoomRequest associateDeviceWithRoomRequest)
            throws LimitExceededException, ConcurrentModificationException, DeviceNotRegisteredException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateDeviceWithRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateDeviceWithRoomResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<AssociateDeviceWithRoomRequest, AssociateDeviceWithRoomResponse>()
                .withOperationName("AssociateDeviceWithRoom").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(associateDeviceWithRoomRequest)
                .withMarshaller(new AssociateDeviceWithRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Associates a skill group with a given room. This enables all skills in the associated skill group on all devices
     * in the room.
     * </p>
     *
     * @param associateSkillGroupWithRoomRequest
     * @return Result of the AssociateSkillGroupWithRoom operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateSkillGroupWithRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillGroupWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateSkillGroupWithRoomResponse associateSkillGroupWithRoom(
            AssociateSkillGroupWithRoomRequest associateSkillGroupWithRoomRequest) throws ConcurrentModificationException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateSkillGroupWithRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateSkillGroupWithRoomResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<AssociateSkillGroupWithRoomRequest, AssociateSkillGroupWithRoomResponse>()
                        .withOperationName("AssociateSkillGroupWithRoom").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(associateSkillGroupWithRoomRequest)
                        .withMarshaller(new AssociateSkillGroupWithRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Associates a skill with a skill group.
     * </p>
     *
     * @param associateSkillWithSkillGroupRequest
     * @return Result of the AssociateSkillWithSkillGroup operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SkillNotLinkedException
     *         The skill must be linked to a third-party account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateSkillWithSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateSkillWithSkillGroupResponse associateSkillWithSkillGroup(
            AssociateSkillWithSkillGroupRequest associateSkillWithSkillGroupRequest) throws ConcurrentModificationException,
            NotFoundException, SkillNotLinkedException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateSkillWithSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateSkillWithSkillGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<AssociateSkillWithSkillGroupRequest, AssociateSkillWithSkillGroupResponse>()
                        .withOperationName("AssociateSkillWithSkillGroup").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(associateSkillWithSkillGroupRequest)
                        .withMarshaller(new AssociateSkillWithSkillGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Makes a private skill available for enrolled users to enable on their devices.
     * </p>
     *
     * @param associateSkillWithUsersRequest
     * @return Result of the AssociateSkillWithUsers operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.AssociateSkillWithUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithUsers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateSkillWithUsersResponse associateSkillWithUsers(AssociateSkillWithUsersRequest associateSkillWithUsersRequest)
            throws ConcurrentModificationException, NotFoundException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateSkillWithUsersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateSkillWithUsersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<AssociateSkillWithUsersRequest, AssociateSkillWithUsersResponse>()
                .withOperationName("AssociateSkillWithUsers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(associateSkillWithUsersRequest)
                .withMarshaller(new AssociateSkillWithUsersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates an address book with the specified details.
     * </p>
     *
     * @param createAddressBookRequest
     * @return Result of the CreateAddressBook operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAddressBookResponse createAddressBook(CreateAddressBookRequest createAddressBookRequest)
            throws AlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAddressBookResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAddressBookResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateAddressBookRequest, CreateAddressBookResponse>()
                .withOperationName("CreateAddressBook").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createAddressBookRequest)
                .withMarshaller(new CreateAddressBookRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a recurring schedule for usage reports to deliver to the specified S3 location with a specified daily or
     * weekly interval.
     * </p>
     *
     * @param createBusinessReportScheduleRequest
     * @return Result of the CreateBusinessReportSchedule operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateBusinessReportSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBusinessReportScheduleResponse createBusinessReportSchedule(
            CreateBusinessReportScheduleRequest createBusinessReportScheduleRequest) throws AlreadyExistsException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBusinessReportScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBusinessReportScheduleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateBusinessReportScheduleRequest, CreateBusinessReportScheduleResponse>()
                        .withOperationName("CreateBusinessReportSchedule").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createBusinessReportScheduleRequest)
                        .withMarshaller(new CreateBusinessReportScheduleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds a new conference provider under the user's AWS account.
     * </p>
     *
     * @param createConferenceProviderRequest
     * @return Result of the CreateConferenceProvider operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateConferenceProviderResponse createConferenceProvider(
            CreateConferenceProviderRequest createConferenceProviderRequest) throws AlreadyExistsException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConferenceProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateConferenceProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateConferenceProviderRequest, CreateConferenceProviderResponse>()
                        .withOperationName("CreateConferenceProvider").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createConferenceProviderRequest)
                        .withMarshaller(new CreateConferenceProviderRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a contact with the specified details.
     * </p>
     *
     * @param createContactRequest
     * @return Result of the CreateContact operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateContact" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateContactResponse createContact(CreateContactRequest createContactRequest) throws AlreadyExistsException,
            LimitExceededException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateContactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateContactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateContactRequest, CreateContactResponse>()
                .withOperationName("CreateContact").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createContactRequest)
                .withMarshaller(new CreateContactRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a gateway group with the specified details.
     * </p>
     *
     * @param createGatewayGroupRequest
     * @return Result of the CreateGatewayGroup operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateGatewayGroupResponse createGatewayGroup(CreateGatewayGroupRequest createGatewayGroupRequest)
            throws AlreadyExistsException, LimitExceededException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGatewayGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateGatewayGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateGatewayGroupRequest, CreateGatewayGroupResponse>()
                .withOperationName("CreateGatewayGroup").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createGatewayGroupRequest)
                .withMarshaller(new CreateGatewayGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new room profile with the specified details.
     * </p>
     *
     * @param createProfileRequest
     * @return Result of the CreateProfile operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateProfileResponse createProfile(CreateProfileRequest createProfileRequest) throws LimitExceededException,
            AlreadyExistsException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProfileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateProfileRequest, CreateProfileResponse>()
                .withOperationName("CreateProfile").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createProfileRequest)
                .withMarshaller(new CreateProfileRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a room with the specified details.
     * </p>
     *
     * @param createRoomRequest
     * @return Result of the CreateRoom operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateRoomResponse createRoom(CreateRoomRequest createRoomRequest) throws AlreadyExistsException,
            LimitExceededException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRoomResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRoomResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateRoomRequest, CreateRoomResponse>()
                .withOperationName("CreateRoom").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createRoomRequest)
                .withMarshaller(new CreateRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a skill group with a specified name and description.
     * </p>
     *
     * @param createSkillGroupRequest
     * @return Result of the CreateSkillGroup operation returned by the service.
     * @throws AlreadyExistsException
     *         The resource being created already exists.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSkillGroupResponse createSkillGroup(CreateSkillGroupRequest createSkillGroupRequest)
            throws AlreadyExistsException, LimitExceededException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSkillGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateSkillGroupRequest, CreateSkillGroupResponse>()
                .withOperationName("CreateSkillGroup").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createSkillGroupRequest)
                .withMarshaller(new CreateSkillGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a user.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws ResourceInUseException
     *         The resource in the request is already in use.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.CreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws ResourceInUseException,
            LimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>()
                .withOperationName("CreateUser").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createUserRequest)
                .withMarshaller(new CreateUserRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes an address book by the address book ARN.
     * </p>
     *
     * @param deleteAddressBookRequest
     * @return Result of the DeleteAddressBook operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAddressBookResponse deleteAddressBook(DeleteAddressBookRequest deleteAddressBookRequest)
            throws NotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAddressBookResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAddressBookResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteAddressBookRequest, DeleteAddressBookResponse>()
                .withOperationName("DeleteAddressBook").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteAddressBookRequest)
                .withMarshaller(new DeleteAddressBookRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the recurring report delivery schedule with the specified schedule ARN.
     * </p>
     *
     * @param deleteBusinessReportScheduleRequest
     * @return Result of the DeleteBusinessReportSchedule operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteBusinessReportSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBusinessReportScheduleResponse deleteBusinessReportSchedule(
            DeleteBusinessReportScheduleRequest deleteBusinessReportScheduleRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBusinessReportScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBusinessReportScheduleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteBusinessReportScheduleRequest, DeleteBusinessReportScheduleResponse>()
                        .withOperationName("DeleteBusinessReportSchedule").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteBusinessReportScheduleRequest)
                        .withMarshaller(new DeleteBusinessReportScheduleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a conference provider.
     * </p>
     *
     * @param deleteConferenceProviderRequest
     * @return Result of the DeleteConferenceProvider operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConferenceProviderResponse deleteConferenceProvider(
            DeleteConferenceProviderRequest deleteConferenceProviderRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConferenceProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConferenceProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteConferenceProviderRequest, DeleteConferenceProviderResponse>()
                        .withOperationName("DeleteConferenceProvider").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteConferenceProviderRequest)
                        .withMarshaller(new DeleteConferenceProviderRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a contact by the contact ARN.
     * </p>
     *
     * @param deleteContactRequest
     * @return Result of the DeleteContact operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteContact" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteContactResponse deleteContact(DeleteContactRequest deleteContactRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteContactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteContactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteContactRequest, DeleteContactResponse>()
                .withOperationName("DeleteContact").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteContactRequest)
                .withMarshaller(new DeleteContactRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes a device from Alexa For Business.
     * </p>
     *
     * @param deleteDeviceRequest
     * @return Result of the DeleteDevice operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws InvalidCertificateAuthorityException
     *         The Certificate Authority can't issue or revoke a certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDeviceResponse deleteDevice(DeleteDeviceRequest deleteDeviceRequest) throws NotFoundException,
            ConcurrentModificationException, InvalidCertificateAuthorityException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteDeviceRequest, DeleteDeviceResponse>()
                .withOperationName("DeleteDevice").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteDeviceRequest)
                .withMarshaller(new DeleteDeviceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a gateway group.
     * </p>
     *
     * @param deleteGatewayGroupRequest
     * @return Result of the DeleteGatewayGroup operation returned by the service.
     * @throws ResourceAssociatedException
     *         Another resource is associated with the resource in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteGatewayGroupResponse deleteGatewayGroup(DeleteGatewayGroupRequest deleteGatewayGroupRequest)
            throws ResourceAssociatedException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGatewayGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteGatewayGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteGatewayGroupRequest, DeleteGatewayGroupResponse>()
                .withOperationName("DeleteGatewayGroup").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteGatewayGroupRequest)
                .withMarshaller(new DeleteGatewayGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a room profile by the profile ARN.
     * </p>
     *
     * @param deleteProfileRequest
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteProfileResponse deleteProfile(DeleteProfileRequest deleteProfileRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteProfileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteProfileRequest, DeleteProfileResponse>()
                .withOperationName("DeleteProfile").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteProfileRequest)
                .withMarshaller(new DeleteProfileRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a room by the room ARN.
     * </p>
     *
     * @param deleteRoomRequest
     * @return Result of the DeleteRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoom" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteRoomResponse deleteRoom(DeleteRoomRequest deleteRoomRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRoomResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRoomResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteRoomRequest, DeleteRoomResponse>()
                .withOperationName("DeleteRoom").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteRoomRequest)
                .withMarshaller(new DeleteRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes room skill parameter details by room, skill, and parameter key ID.
     * </p>
     *
     * @param deleteRoomSkillParameterRequest
     * @return Result of the DeleteRoomSkillParameter operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRoomSkillParameterResponse deleteRoomSkillParameter(
            DeleteRoomSkillParameterRequest deleteRoomSkillParameterRequest) throws ConcurrentModificationException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRoomSkillParameterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRoomSkillParameterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteRoomSkillParameterRequest, DeleteRoomSkillParameterResponse>()
                        .withOperationName("DeleteRoomSkillParameter").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteRoomSkillParameterRequest)
                        .withMarshaller(new DeleteRoomSkillParameterRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Unlinks a third-party account from a skill.
     * </p>
     *
     * @param deleteSkillAuthorizationRequest
     * @return Result of the DeleteSkillAuthorization operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteSkillAuthorization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSkillAuthorizationResponse deleteSkillAuthorization(
            DeleteSkillAuthorizationRequest deleteSkillAuthorizationRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSkillAuthorizationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSkillAuthorizationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteSkillAuthorizationRequest, DeleteSkillAuthorizationResponse>()
                        .withOperationName("DeleteSkillAuthorization").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteSkillAuthorizationRequest)
                        .withMarshaller(new DeleteSkillAuthorizationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a skill group by skill group ARN.
     * </p>
     *
     * @param deleteSkillGroupRequest
     * @return Result of the DeleteSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSkillGroupResponse deleteSkillGroup(DeleteSkillGroupRequest deleteSkillGroupRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSkillGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteSkillGroupRequest, DeleteSkillGroupResponse>()
                .withOperationName("DeleteSkillGroup").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteSkillGroupRequest)
                .withMarshaller(new DeleteSkillGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a specified user by user ARN and enrollment ARN.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>()
                .withOperationName("DeleteUser").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteUserRequest)
                .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disassociates a contact from a given address book.
     * </p>
     *
     * @param disassociateContactFromAddressBookRequest
     * @return Result of the DisassociateContactFromAddressBook operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateContactFromAddressBook
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateContactFromAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateContactFromAddressBookResponse disassociateContactFromAddressBook(
            DisassociateContactFromAddressBookRequest disassociateContactFromAddressBookRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateContactFromAddressBookResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateContactFromAddressBookResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateContactFromAddressBookRequest, DisassociateContactFromAddressBookResponse>()
                        .withOperationName("DisassociateContactFromAddressBook").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(disassociateContactFromAddressBookRequest)
                        .withMarshaller(new DisassociateContactFromAddressBookRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disassociates a device from its current room. The device continues to be connected to the Wi-Fi network and is
     * still registered to the account. The device settings and skills are removed from the room.
     * </p>
     *
     * @param disassociateDeviceFromRoomRequest
     * @return Result of the DisassociateDeviceFromRoom operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateDeviceFromRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateDeviceFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateDeviceFromRoomResponse disassociateDeviceFromRoom(
            DisassociateDeviceFromRoomRequest disassociateDeviceFromRoomRequest) throws ConcurrentModificationException,
            DeviceNotRegisteredException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateDeviceFromRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateDeviceFromRoomResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateDeviceFromRoomRequest, DisassociateDeviceFromRoomResponse>()
                        .withOperationName("DisassociateDeviceFromRoom").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(disassociateDeviceFromRoomRequest)
                        .withMarshaller(new DisassociateDeviceFromRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disassociates a skill from a skill group.
     * </p>
     *
     * @param disassociateSkillFromSkillGroupRequest
     * @return Result of the DisassociateSkillFromSkillGroup operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateSkillFromSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateSkillFromSkillGroupResponse disassociateSkillFromSkillGroup(
            DisassociateSkillFromSkillGroupRequest disassociateSkillFromSkillGroupRequest)
            throws ConcurrentModificationException, NotFoundException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateSkillFromSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateSkillFromSkillGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateSkillFromSkillGroupRequest, DisassociateSkillFromSkillGroupResponse>()
                        .withOperationName("DisassociateSkillFromSkillGroup").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(disassociateSkillFromSkillGroupRequest)
                        .withMarshaller(new DisassociateSkillFromSkillGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Makes a private skill unavailable for enrolled users and prevents them from enabling it on their devices.
     * </p>
     *
     * @param disassociateSkillFromUsersRequest
     * @return Result of the DisassociateSkillFromUsers operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateSkillFromUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromUsers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateSkillFromUsersResponse disassociateSkillFromUsers(
            DisassociateSkillFromUsersRequest disassociateSkillFromUsersRequest) throws ConcurrentModificationException,
            NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateSkillFromUsersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateSkillFromUsersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateSkillFromUsersRequest, DisassociateSkillFromUsersResponse>()
                        .withOperationName("DisassociateSkillFromUsers").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(disassociateSkillFromUsersRequest)
                        .withMarshaller(new DisassociateSkillFromUsersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disassociates a skill group from a specified room. This disables all skills in the skill group on all devices in
     * the room.
     * </p>
     *
     * @param disassociateSkillGroupFromRoomRequest
     * @return Result of the DisassociateSkillGroupFromRoom operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.DisassociateSkillGroupFromRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillGroupFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateSkillGroupFromRoomResponse disassociateSkillGroupFromRoom(
            DisassociateSkillGroupFromRoomRequest disassociateSkillGroupFromRoomRequest) throws ConcurrentModificationException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateSkillGroupFromRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateSkillGroupFromRoomResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateSkillGroupFromRoomRequest, DisassociateSkillGroupFromRoomResponse>()
                        .withOperationName("DisassociateSkillGroupFromRoom").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(disassociateSkillGroupFromRoomRequest)
                        .withMarshaller(new DisassociateSkillGroupFromRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Forgets smart home appliances associated to a room.
     * </p>
     *
     * @param forgetSmartHomeAppliancesRequest
     * @return Result of the ForgetSmartHomeAppliances operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ForgetSmartHomeAppliances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ForgetSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ForgetSmartHomeAppliancesResponse forgetSmartHomeAppliances(
            ForgetSmartHomeAppliancesRequest forgetSmartHomeAppliancesRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ForgetSmartHomeAppliancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ForgetSmartHomeAppliancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ForgetSmartHomeAppliancesRequest, ForgetSmartHomeAppliancesResponse>()
                        .withOperationName("ForgetSmartHomeAppliances").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(forgetSmartHomeAppliancesRequest)
                        .withMarshaller(new ForgetSmartHomeAppliancesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets address the book details by the address book ARN.
     * </p>
     *
     * @param getAddressBookRequest
     * @return Result of the GetAddressBook operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAddressBookResponse getAddressBook(GetAddressBookRequest getAddressBookRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAddressBookResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAddressBookResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetAddressBookRequest, GetAddressBookResponse>()
                .withOperationName("GetAddressBook").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getAddressBookRequest)
                .withMarshaller(new GetAddressBookRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the existing conference preferences.
     * </p>
     *
     * @param getConferencePreferenceRequest
     * @return Result of the GetConferencePreference operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetConferencePreference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferencePreference"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetConferencePreferenceResponse getConferencePreference(GetConferencePreferenceRequest getConferencePreferenceRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConferencePreferenceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetConferencePreferenceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetConferencePreferenceRequest, GetConferencePreferenceResponse>()
                .withOperationName("GetConferencePreference").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getConferencePreferenceRequest)
                .withMarshaller(new GetConferencePreferenceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets details about a specific conference provider.
     * </p>
     *
     * @param getConferenceProviderRequest
     * @return Result of the GetConferenceProvider operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetConferenceProviderResponse getConferenceProvider(GetConferenceProviderRequest getConferenceProviderRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConferenceProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetConferenceProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetConferenceProviderRequest, GetConferenceProviderResponse>()
                .withOperationName("GetConferenceProvider").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getConferenceProviderRequest)
                .withMarshaller(new GetConferenceProviderRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets the contact details by the contact ARN.
     * </p>
     *
     * @param getContactRequest
     * @return Result of the GetContact operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetContact" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetContactResponse getContact(GetContactRequest getContactRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetContactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetContactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetContactRequest, GetContactResponse>()
                .withOperationName("GetContact").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getContactRequest)
                .withMarshaller(new GetContactRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets the details of a device by device ARN.
     * </p>
     *
     * @param getDeviceRequest
     * @return Result of the GetDevice operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDeviceResponse getDevice(GetDeviceRequest getDeviceRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetDeviceRequest, GetDeviceResponse>()
                .withOperationName("GetDevice").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDeviceRequest)
                .withMarshaller(new GetDeviceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the details of a gateway.
     * </p>
     *
     * @param getGatewayRequest
     * @return Result of the GetGateway operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGateway" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetGatewayResponse getGateway(GetGatewayRequest getGatewayRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetGatewayRequest, GetGatewayResponse>()
                .withOperationName("GetGateway").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getGatewayRequest)
                .withMarshaller(new GetGatewayRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the details of a gateway group.
     * </p>
     *
     * @param getGatewayGroupRequest
     * @return Result of the GetGatewayGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetGatewayGroupResponse getGatewayGroup(GetGatewayGroupRequest getGatewayGroupRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGatewayGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetGatewayGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetGatewayGroupRequest, GetGatewayGroupResponse>()
                .withOperationName("GetGatewayGroup").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getGatewayGroupRequest)
                .withMarshaller(new GetGatewayGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the configured values for the user enrollment invitation email template.
     * </p>
     *
     * @param getInvitationConfigurationRequest
     * @return Result of the GetInvitationConfiguration operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetInvitationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetInvitationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetInvitationConfigurationResponse getInvitationConfiguration(
            GetInvitationConfigurationRequest getInvitationConfigurationRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetInvitationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetInvitationConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetInvitationConfigurationRequest, GetInvitationConfigurationResponse>()
                        .withOperationName("GetInvitationConfiguration").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getInvitationConfigurationRequest)
                        .withMarshaller(new GetInvitationConfigurationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets the details of a room profile by profile ARN.
     * </p>
     *
     * @param getProfileRequest
     * @return Result of the GetProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetProfileResponse getProfile(GetProfileRequest getProfileRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetProfileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetProfileRequest, GetProfileResponse>()
                .withOperationName("GetProfile").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getProfileRequest)
                .withMarshaller(new GetProfileRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets room details by room ARN.
     * </p>
     *
     * @param getRoomRequest
     * @return Result of the GetRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoom" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRoomResponse getRoom(GetRoomRequest getRoomRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRoomResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRoomResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetRoomRequest, GetRoomResponse>().withOperationName("GetRoom")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getRoomRequest)
                .withMarshaller(new GetRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets room skill parameter details by room, skill, and parameter key ARN.
     * </p>
     *
     * @param getRoomSkillParameterRequest
     * @return Result of the GetRoomSkillParameter operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRoomSkillParameterResponse getRoomSkillParameter(GetRoomSkillParameterRequest getRoomSkillParameterRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRoomSkillParameterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRoomSkillParameterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetRoomSkillParameterRequest, GetRoomSkillParameterResponse>()
                .withOperationName("GetRoomSkillParameter").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getRoomSkillParameterRequest)
                .withMarshaller(new GetRoomSkillParameterRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets skill group details by skill group ARN.
     * </p>
     *
     * @param getSkillGroupRequest
     * @return Result of the GetSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.GetSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetSkillGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSkillGroupResponse getSkillGroup(GetSkillGroupRequest getSkillGroupRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSkillGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetSkillGroupRequest, GetSkillGroupResponse>()
                .withOperationName("GetSkillGroup").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getSkillGroupRequest)
                .withMarshaller(new GetSkillGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the details of the schedules that a user configured.
     * </p>
     *
     * @param listBusinessReportSchedulesRequest
     * @return Result of the ListBusinessReportSchedules operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListBusinessReportSchedules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBusinessReportSchedulesResponse listBusinessReportSchedules(
            ListBusinessReportSchedulesRequest listBusinessReportSchedulesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBusinessReportSchedulesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBusinessReportSchedulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListBusinessReportSchedulesRequest, ListBusinessReportSchedulesResponse>()
                        .withOperationName("ListBusinessReportSchedules").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(listBusinessReportSchedulesRequest)
                        .withMarshaller(new ListBusinessReportSchedulesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the details of the schedules that a user configured.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBusinessReportSchedules(software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesIterable responses = client.listBusinessReportSchedulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesIterable responses = client
     *             .listBusinessReportSchedulesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesIterable responses = client.listBusinessReportSchedulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBusinessReportSchedules(software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBusinessReportSchedulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListBusinessReportSchedules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBusinessReportSchedulesIterable listBusinessReportSchedulesPaginator(
            ListBusinessReportSchedulesRequest listBusinessReportSchedulesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return new ListBusinessReportSchedulesIterable(this, applyPaginatorUserAgent(listBusinessReportSchedulesRequest));
    }

    /**
     * <p>
     * Lists conference providers under a specific AWS account.
     * </p>
     *
     * @param listConferenceProvidersRequest
     * @return Result of the ListConferenceProviders operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListConferenceProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListConferenceProviders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListConferenceProvidersResponse listConferenceProviders(ListConferenceProvidersRequest listConferenceProvidersRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListConferenceProvidersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListConferenceProvidersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListConferenceProvidersRequest, ListConferenceProvidersResponse>()
                .withOperationName("ListConferenceProviders").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listConferenceProvidersRequest)
                .withMarshaller(new ListConferenceProvidersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists conference providers under a specific AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConferenceProviders(software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersIterable responses = client.listConferenceProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersIterable responses = client
     *             .listConferenceProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersIterable responses = client.listConferenceProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConferenceProviders(software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConferenceProvidersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListConferenceProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListConferenceProviders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListConferenceProvidersIterable listConferenceProvidersPaginator(
            ListConferenceProvidersRequest listConferenceProvidersRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return new ListConferenceProvidersIterable(this, applyPaginatorUserAgent(listConferenceProvidersRequest));
    }

    /**
     * <p>
     * Lists the device event history, including device connection status, for up to 30 days.
     * </p>
     *
     * @param listDeviceEventsRequest
     * @return Result of the ListDeviceEvents operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListDeviceEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListDeviceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDeviceEventsResponse listDeviceEvents(ListDeviceEventsRequest listDeviceEventsRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDeviceEventsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDeviceEventsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListDeviceEventsRequest, ListDeviceEventsResponse>()
                .withOperationName("ListDeviceEvents").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listDeviceEventsRequest)
                .withMarshaller(new ListDeviceEventsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the device event history, including device connection status, for up to 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceEvents(software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsIterable responses = client.listDeviceEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsIterable responses = client
     *             .listDeviceEventsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsIterable responses = client.listDeviceEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceEvents(software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListDeviceEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListDeviceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDeviceEventsIterable listDeviceEventsPaginator(ListDeviceEventsRequest listDeviceEventsRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        return new ListDeviceEventsIterable(this, applyPaginatorUserAgent(listDeviceEventsRequest));
    }

    /**
     * <p>
     * Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.
     * </p>
     *
     * @param listGatewayGroupsRequest
     * @return Result of the ListGatewayGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListGatewayGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListGatewayGroupsResponse listGatewayGroups(ListGatewayGroupsRequest listGatewayGroupsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGatewayGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGatewayGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListGatewayGroupsRequest, ListGatewayGroupsResponse>()
                .withOperationName("ListGatewayGroups").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listGatewayGroupsRequest)
                .withMarshaller(new ListGatewayGroupsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGatewayGroups(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsIterable responses = client.listGatewayGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsIterable responses = client
     *             .listGatewayGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsIterable responses = client.listGatewayGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayGroups(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGatewayGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListGatewayGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListGatewayGroupsIterable listGatewayGroupsPaginator(ListGatewayGroupsRequest listGatewayGroupsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return new ListGatewayGroupsIterable(this, applyPaginatorUserAgent(listGatewayGroupsRequest));
    }

    /**
     * <p>
     * Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional
     * gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that
     * gateway group ARN.
     * </p>
     *
     * @param listGatewaysRequest
     * @return Result of the ListGateways operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListGatewaysResponse listGateways(ListGatewaysRequest listGatewaysRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGatewaysResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListGatewaysRequest, ListGatewaysResponse>()
                .withOperationName("ListGateways").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listGatewaysRequest)
                .withMarshaller(new ListGatewaysRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional
     * gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that
     * gateway group ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysIterable responses = client
     *             .listGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysIterable responses = client.listGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest)} operation.</b>
     * </p>
     *
     * @param listGatewaysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListGatewaysIterable listGatewaysPaginator(ListGatewaysRequest listGatewaysRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return new ListGatewaysIterable(this, applyPaginatorUserAgent(listGatewaysRequest));
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     *
     * @param listSkillsRequest
     * @return Result of the ListSkills operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkills
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListSkillsResponse listSkills(ListSkillsRequest listSkillsRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSkillsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSkillsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListSkillsRequest, ListSkillsResponse>()
                .withOperationName("ListSkills").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listSkillsRequest)
                .withMarshaller(new ListSkillsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsIterable responses = client.listSkillsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsIterable responses = client
     *             .listSkillsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsIterable responses = client.listSkillsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation.</b>
     * </p>
     *
     * @param listSkillsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkills
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListSkillsIterable listSkillsPaginator(ListSkillsRequest listSkillsRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return new ListSkillsIterable(this, applyPaginatorUserAgent(listSkillsRequest));
    }

    /**
     * <p>
     * Lists all categories in the Alexa skill store.
     * </p>
     *
     * @param listSkillsStoreCategoriesRequest
     * @return Result of the ListSkillsStoreCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkillsStoreCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreCategories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSkillsStoreCategoriesResponse listSkillsStoreCategories(
            ListSkillsStoreCategoriesRequest listSkillsStoreCategoriesRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSkillsStoreCategoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSkillsStoreCategoriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListSkillsStoreCategoriesRequest, ListSkillsStoreCategoriesResponse>()
                        .withOperationName("ListSkillsStoreCategories").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(listSkillsStoreCategoriesRequest)
                        .withMarshaller(new ListSkillsStoreCategoriesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all categories in the Alexa skill store.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkillsStoreCategories(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesIterable responses = client.listSkillsStoreCategoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesIterable responses = client
     *             .listSkillsStoreCategoriesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesIterable responses = client.listSkillsStoreCategoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkillsStoreCategories(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSkillsStoreCategoriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkillsStoreCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreCategories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSkillsStoreCategoriesIterable listSkillsStoreCategoriesPaginator(
            ListSkillsStoreCategoriesRequest listSkillsStoreCategoriesRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        return new ListSkillsStoreCategoriesIterable(this, applyPaginatorUserAgent(listSkillsStoreCategoriesRequest));
    }

    /**
     * <p>
     * Lists all skills in the Alexa skill store by category.
     * </p>
     *
     * @param listSkillsStoreSkillsByCategoryRequest
     * @return Result of the ListSkillsStoreSkillsByCategory operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkillsStoreSkillsByCategory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSkillsStoreSkillsByCategoryResponse listSkillsStoreSkillsByCategory(
            ListSkillsStoreSkillsByCategoryRequest listSkillsStoreSkillsByCategoryRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSkillsStoreSkillsByCategoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSkillsStoreSkillsByCategoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListSkillsStoreSkillsByCategoryRequest, ListSkillsStoreSkillsByCategoryResponse>()
                        .withOperationName("ListSkillsStoreSkillsByCategory").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(listSkillsStoreSkillsByCategoryRequest)
                        .withMarshaller(new ListSkillsStoreSkillsByCategoryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all skills in the Alexa skill store by category.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkillsStoreSkillsByCategory(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryIterable responses = client.listSkillsStoreSkillsByCategoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryIterable responses = client
     *             .listSkillsStoreSkillsByCategoryPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryIterable responses = client.listSkillsStoreSkillsByCategoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkillsStoreSkillsByCategory(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSkillsStoreSkillsByCategoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSkillsStoreSkillsByCategory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSkillsStoreSkillsByCategoryIterable listSkillsStoreSkillsByCategoryPaginator(
            ListSkillsStoreSkillsByCategoryRequest listSkillsStoreSkillsByCategoryRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return new ListSkillsStoreSkillsByCategoryIterable(this, applyPaginatorUserAgent(listSkillsStoreSkillsByCategoryRequest));
    }

    /**
     * <p>
     * Lists all of the smart home appliances associated with a room.
     * </p>
     *
     * @param listSmartHomeAppliancesRequest
     * @return Result of the ListSmartHomeAppliances operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSmartHomeAppliances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSmartHomeAppliancesResponse listSmartHomeAppliances(ListSmartHomeAppliancesRequest listSmartHomeAppliancesRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSmartHomeAppliancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSmartHomeAppliancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListSmartHomeAppliancesRequest, ListSmartHomeAppliancesResponse>()
                .withOperationName("ListSmartHomeAppliances").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listSmartHomeAppliancesRequest)
                .withMarshaller(new ListSmartHomeAppliancesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all of the smart home appliances associated with a room.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSmartHomeAppliances(software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesIterable responses = client.listSmartHomeAppliancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesIterable responses = client
     *             .listSmartHomeAppliancesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesIterable responses = client.listSmartHomeAppliancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSmartHomeAppliances(software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSmartHomeAppliancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListSmartHomeAppliances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSmartHomeAppliancesIterable listSmartHomeAppliancesPaginator(
            ListSmartHomeAppliancesRequest listSmartHomeAppliancesRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return new ListSmartHomeAppliancesIterable(this, applyPaginatorUserAgent(listSmartHomeAppliancesRequest));
    }

    /**
     * <p>
     * Lists all tags for the specified resource.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListTagsRequest, ListTagsResponse>().withOperationName("ListTags")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(listTagsRequest)
                .withMarshaller(new ListTagsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)} operation.</b>
     * </p>
     *
     * @param listTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsIterable listTagsPaginator(ListTagsRequest listTagsRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return new ListTagsIterable(this, applyPaginatorUserAgent(listTagsRequest));
    }

    /**
     * <p>
     * Sets the conference preferences on a specific conference provider at the account level.
     * </p>
     *
     * @param putConferencePreferenceRequest
     * @return Result of the PutConferencePreference operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.PutConferencePreference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutConferencePreference"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutConferencePreferenceResponse putConferencePreference(PutConferencePreferenceRequest putConferencePreferenceRequest)
            throws NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutConferencePreferenceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutConferencePreferenceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PutConferencePreferenceRequest, PutConferencePreferenceResponse>()
                .withOperationName("PutConferencePreference").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putConferencePreferenceRequest)
                .withMarshaller(new PutConferencePreferenceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Configures the email template for the user enrollment invitation with the specified attributes.
     * </p>
     *
     * @param putInvitationConfigurationRequest
     * @return Result of the PutInvitationConfiguration operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.PutInvitationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutInvitationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutInvitationConfigurationResponse putInvitationConfiguration(
            PutInvitationConfigurationRequest putInvitationConfigurationRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutInvitationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutInvitationConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<PutInvitationConfigurationRequest, PutInvitationConfigurationResponse>()
                        .withOperationName("PutInvitationConfiguration").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(putInvitationConfigurationRequest)
                        .withMarshaller(new PutInvitationConfigurationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates room skill parameter details by room, skill, and parameter key ID. Not all skills have a room skill
     * parameter.
     * </p>
     *
     * @param putRoomSkillParameterRequest
     * @return Result of the PutRoomSkillParameter operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.PutRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutRoomSkillParameterResponse putRoomSkillParameter(PutRoomSkillParameterRequest putRoomSkillParameterRequest)
            throws ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutRoomSkillParameterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutRoomSkillParameterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PutRoomSkillParameterRequest, PutRoomSkillParameterResponse>()
                .withOperationName("PutRoomSkillParameter").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putRoomSkillParameterRequest)
                .withMarshaller(new PutRoomSkillParameterRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Links a user's account to a third-party skill provider. If this API operation is called by an assumed IAM role,
     * the skill being linked must be a private skill. Also, the skill must be owned by the AWS account that assumed the
     * IAM role.
     * </p>
     *
     * @param putSkillAuthorizationRequest
     * @return Result of the PutSkillAuthorization operation returned by the service.
     * @throws UnauthorizedException
     *         The caller has no permissions to operate on the resource involved in the API call.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.PutSkillAuthorization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutSkillAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutSkillAuthorizationResponse putSkillAuthorization(PutSkillAuthorizationRequest putSkillAuthorizationRequest)
            throws UnauthorizedException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutSkillAuthorizationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutSkillAuthorizationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PutSkillAuthorizationRequest, PutSkillAuthorizationResponse>()
                .withOperationName("PutSkillAuthorization").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putSkillAuthorizationRequest)
                .withMarshaller(new PutSkillAuthorizationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Registers an Alexa-enabled device built by an Original Equipment Manufacturer (OEM) using Alexa Voice Service
     * (AVS).
     * </p>
     *
     * @param registerAvsDeviceRequest
     * @return Result of the RegisterAVSDevice operation returned by the service.
     * @throws LimitExceededException
     *         You are performing an action that would put you beyond your account's limits.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws InvalidDeviceException
     *         The device is in an invalid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.RegisterAVSDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RegisterAVSDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterAvsDeviceResponse registerAVSDevice(RegisterAvsDeviceRequest registerAvsDeviceRequest)
            throws LimitExceededException, ConcurrentModificationException, InvalidDeviceException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterAvsDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RegisterAvsDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<RegisterAvsDeviceRequest, RegisterAvsDeviceResponse>()
                .withOperationName("RegisterAVSDevice").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(registerAvsDeviceRequest)
                .withMarshaller(new RegisterAvsDeviceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disassociates a skill from the organization under a user's AWS account. If the skill is a private skill, it moves
     * to an AcceptStatus of PENDING. Any private or public skill that is rejected can be added later by calling the
     * ApproveSkill API.
     * </p>
     *
     * @param rejectSkillRequest
     * @return Result of the RejectSkill operation returned by the service.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.RejectSkill
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RejectSkill" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RejectSkillResponse rejectSkill(RejectSkillRequest rejectSkillRequest) throws ConcurrentModificationException,
            NotFoundException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RejectSkillResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RejectSkillResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<RejectSkillRequest, RejectSkillResponse>()
                .withOperationName("RejectSkill").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(rejectSkillRequest)
                .withMarshaller(new RejectSkillRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Determines the details for the room from which a skill request was invoked. This operation is used by skill
     * developers.
     * </p>
     *
     * @param resolveRoomRequest
     * @return Result of the ResolveRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.ResolveRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ResolveRoom" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ResolveRoomResponse resolveRoom(ResolveRoomRequest resolveRoomRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ResolveRoomResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ResolveRoomResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ResolveRoomRequest, ResolveRoomResponse>()
                .withOperationName("ResolveRoom").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(resolveRoomRequest)
                .withMarshaller(new ResolveRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Revokes an invitation and invalidates the enrollment URL.
     * </p>
     *
     * @param revokeInvitationRequest
     * @return Result of the RevokeInvitation operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.RevokeInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RevokeInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RevokeInvitationResponse revokeInvitation(RevokeInvitationRequest revokeInvitationRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RevokeInvitationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RevokeInvitationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<RevokeInvitationRequest, RevokeInvitationResponse>()
                .withOperationName("RevokeInvitation").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(revokeInvitationRequest)
                .withMarshaller(new RevokeInvitationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches address books and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchAddressBooksRequest
     * @return Result of the SearchAddressBooks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchAddressBooks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchAddressBooksResponse searchAddressBooks(SearchAddressBooksRequest searchAddressBooksRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchAddressBooksResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SearchAddressBooksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<SearchAddressBooksRequest, SearchAddressBooksResponse>()
                .withOperationName("SearchAddressBooks").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(searchAddressBooksRequest)
                .withMarshaller(new SearchAddressBooksRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches address books and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchAddressBooks(software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksIterable responses = client.searchAddressBooksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksIterable responses = client
     *             .searchAddressBooksPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksIterable responses = client.searchAddressBooksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchAddressBooks(software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchAddressBooksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchAddressBooks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchAddressBooksIterable searchAddressBooksPaginator(SearchAddressBooksRequest searchAddressBooksRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return new SearchAddressBooksIterable(this, applyPaginatorUserAgent(searchAddressBooksRequest));
    }

    /**
     * <p>
     * Searches contacts and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchContactsRequest
     * @return Result of the SearchContacts operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchContacts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchContactsResponse searchContacts(SearchContactsRequest searchContactsRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchContactsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchContactsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<SearchContactsRequest, SearchContactsResponse>()
                .withOperationName("SearchContacts").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(searchContactsRequest)
                .withMarshaller(new SearchContactsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches contacts and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchContacts(software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsIterable responses = client.searchContactsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsIterable responses = client
     *             .searchContactsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsIterable responses = client.searchContactsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchContacts(software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchContactsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchContacts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchContactsIterable searchContactsPaginator(SearchContactsRequest searchContactsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return new SearchContactsIterable(this, applyPaginatorUserAgent(searchContactsRequest));
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     *
     * @param searchDevicesRequest
     * @return Result of the SearchDevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchDevicesResponse searchDevices(SearchDevicesRequest searchDevicesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchDevicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchDevicesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<SearchDevicesRequest, SearchDevicesResponse>()
                .withOperationName("SearchDevices").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(searchDevicesRequest)
                .withMarshaller(new SearchDevicesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesIterable responses = client.searchDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesIterable responses = client
     *             .searchDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesIterable responses = client.searchDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchDevicesIterable searchDevicesPaginator(SearchDevicesRequest searchDevicesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return new SearchDevicesIterable(this, applyPaginatorUserAgent(searchDevicesRequest));
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     *
     * @param searchProfilesRequest
     * @return Result of the SearchProfiles operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchProfilesResponse searchProfiles(SearchProfilesRequest searchProfilesRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchProfilesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchProfilesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<SearchProfilesRequest, SearchProfilesResponse>()
                .withOperationName("SearchProfiles").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(searchProfilesRequest)
                .withMarshaller(new SearchProfilesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesIterable responses = client.searchProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesIterable responses = client
     *             .searchProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesIterable responses = client.searchProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchProfilesIterable searchProfilesPaginator(SearchProfilesRequest searchProfilesRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return new SearchProfilesIterable(this, applyPaginatorUserAgent(searchProfilesRequest));
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchRoomsRequest
     * @return Result of the SearchRooms operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchRoomsResponse searchRooms(SearchRoomsRequest searchRoomsRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchRoomsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchRoomsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<SearchRoomsRequest, SearchRoomsResponse>()
                .withOperationName("SearchRooms").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(searchRoomsRequest)
                .withMarshaller(new SearchRoomsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsIterable responses = client.searchRoomsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsIterable responses = client
     *             .searchRoomsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsIterable responses = client.searchRoomsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation.</b>
     * </p>
     *
     * @param searchRoomsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchRoomsIterable searchRoomsPaginator(SearchRoomsRequest searchRoomsRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return new SearchRoomsIterable(this, applyPaginatorUserAgent(searchRoomsRequest));
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchSkillGroupsRequest
     * @return Result of the SearchSkillGroups operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchSkillGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchSkillGroupsResponse searchSkillGroups(SearchSkillGroupsRequest searchSkillGroupsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchSkillGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchSkillGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<SearchSkillGroupsRequest, SearchSkillGroupsResponse>()
                .withOperationName("SearchSkillGroups").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(searchSkillGroupsRequest)
                .withMarshaller(new SearchSkillGroupsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsIterable responses = client.searchSkillGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsIterable responses = client
     *             .searchSkillGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsIterable responses = client.searchSkillGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchSkillGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchSkillGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchSkillGroupsIterable searchSkillGroupsPaginator(SearchSkillGroupsRequest searchSkillGroupsRequest)
            throws AwsServiceException, SdkClientException, AlexaForBusinessException {
        return new SearchSkillGroupsIterable(this, applyPaginatorUserAgent(searchSkillGroupsRequest));
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchUsersRequest
     * @return Result of the SearchUsers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchUsersResponse searchUsers(SearchUsersRequest searchUsersRequest) throws AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchUsersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<SearchUsersRequest, SearchUsersResponse>()
                .withOperationName("SearchUsers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(searchUsersRequest)
                .withMarshaller(new SearchUsersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersIterable responses = client.searchUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersIterable responses = client
     *             .searchUsersPaginator(request);
     *     for (software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersIterable responses = client.searchUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation.</b>
     * </p>
     *
     * @param searchUsersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SearchUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchUsersIterable searchUsersPaginator(SearchUsersRequest searchUsersRequest) throws AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        return new SearchUsersIterable(this, applyPaginatorUserAgent(searchUsersRequest));
    }

    /**
     * <p>
     * Sends an enrollment invitation email with a URL to a user. The URL is valid for 72 hours or until you call this
     * operation again, whichever comes first.
     * </p>
     *
     * @param sendInvitationRequest
     * @return Result of the SendInvitation operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws InvalidUserStatusException
     *         The attempt to update a user is invalid due to the user's current status.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.SendInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SendInvitationResponse sendInvitation(SendInvitationRequest sendInvitationRequest) throws NotFoundException,
            InvalidUserStatusException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendInvitationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SendInvitationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<SendInvitationRequest, SendInvitationResponse>()
                .withOperationName("SendInvitation").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(sendInvitationRequest)
                .withMarshaller(new SendInvitationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Resets a device and its account to the known default settings, by clearing all information and settings set by
     * previous users.
     * </p>
     *
     * @param startDeviceSyncRequest
     * @return Result of the StartDeviceSync operation returned by the service.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.StartDeviceSync
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartDeviceSync"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartDeviceSyncResponse startDeviceSync(StartDeviceSyncRequest startDeviceSyncRequest)
            throws DeviceNotRegisteredException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartDeviceSyncResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartDeviceSyncResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<StartDeviceSyncRequest, StartDeviceSyncResponse>()
                .withOperationName("StartDeviceSync").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(startDeviceSyncRequest)
                .withMarshaller(new StartDeviceSyncRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Initiates the discovery of any smart home appliances associated with the room.
     * </p>
     *
     * @param startSmartHomeApplianceDiscoveryRequest
     * @return Result of the StartSmartHomeApplianceDiscovery operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.StartSmartHomeApplianceDiscovery
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartSmartHomeApplianceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartSmartHomeApplianceDiscoveryResponse startSmartHomeApplianceDiscovery(
            StartSmartHomeApplianceDiscoveryRequest startSmartHomeApplianceDiscoveryRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartSmartHomeApplianceDiscoveryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartSmartHomeApplianceDiscoveryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<StartSmartHomeApplianceDiscoveryRequest, StartSmartHomeApplianceDiscoveryResponse>()
                        .withOperationName("StartSmartHomeApplianceDiscovery").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(startSmartHomeApplianceDiscoveryRequest)
                        .withMarshaller(new StartSmartHomeApplianceDiscoveryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                .withOperationName("TagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws NotFoundException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                .withOperationName("UntagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates address book details by the address book ARN.
     * </p>
     *
     * @param updateAddressBookRequest
     * @return Result of the UpdateAddressBook operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAddressBookResponse updateAddressBook(UpdateAddressBookRequest updateAddressBookRequest)
            throws NotFoundException, NameInUseException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAddressBookResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAddressBookResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateAddressBookRequest, UpdateAddressBookResponse>()
                .withOperationName("UpdateAddressBook").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateAddressBookRequest)
                .withMarshaller(new UpdateAddressBookRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the configuration of the report delivery schedule with the specified schedule ARN.
     * </p>
     *
     * @param updateBusinessReportScheduleRequest
     * @return Result of the UpdateBusinessReportSchedule operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateBusinessReportSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBusinessReportScheduleResponse updateBusinessReportSchedule(
            UpdateBusinessReportScheduleRequest updateBusinessReportScheduleRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBusinessReportScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBusinessReportScheduleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateBusinessReportScheduleRequest, UpdateBusinessReportScheduleResponse>()
                        .withOperationName("UpdateBusinessReportSchedule").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateBusinessReportScheduleRequest)
                        .withMarshaller(new UpdateBusinessReportScheduleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates an existing conference provider's settings.
     * </p>
     *
     * @param updateConferenceProviderRequest
     * @return Result of the UpdateConferenceProvider operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateConferenceProviderResponse updateConferenceProvider(
            UpdateConferenceProviderRequest updateConferenceProviderRequest) throws NotFoundException, AwsServiceException,
            SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateConferenceProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateConferenceProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateConferenceProviderRequest, UpdateConferenceProviderResponse>()
                        .withOperationName("UpdateConferenceProvider").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateConferenceProviderRequest)
                        .withMarshaller(new UpdateConferenceProviderRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the contact details by the contact ARN.
     * </p>
     *
     * @param updateContactRequest
     * @return Result of the UpdateContact operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateContact" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateContactResponse updateContact(UpdateContactRequest updateContactRequest) throws NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateContactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateContactResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateContactRequest, UpdateContactResponse>()
                .withOperationName("UpdateContact").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateContactRequest)
                .withMarshaller(new UpdateContactRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the device name by device ARN.
     * </p>
     *
     * @param updateDeviceRequest
     * @return Result of the UpdateDevice operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws DeviceNotRegisteredException
     *         The request failed because this device is no longer registered and therefore no longer managed by this
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateDeviceResponse updateDevice(UpdateDeviceRequest updateDeviceRequest) throws NotFoundException,
            ConcurrentModificationException, DeviceNotRegisteredException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateDeviceRequest, UpdateDeviceResponse>()
                .withOperationName("UpdateDevice").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateDeviceRequest)
                .withMarshaller(new UpdateDeviceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the details of a gateway. If any optional field is not provided, the existing corresponding value is left
     * unmodified.
     * </p>
     *
     * @param updateGatewayRequest
     * @return Result of the UpdateGateway operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGateway" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateGatewayResponse updateGateway(UpdateGatewayRequest updateGatewayRequest) throws NotFoundException,
            NameInUseException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateGatewayResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateGatewayRequest, UpdateGatewayResponse>()
                .withOperationName("UpdateGateway").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateGatewayRequest)
                .withMarshaller(new UpdateGatewayRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the details of a gateway group. If any optional field is not provided, the existing corresponding value
     * is left unmodified.
     * </p>
     *
     * @param updateGatewayGroupRequest
     * @return Result of the UpdateGatewayGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateGatewayGroupResponse updateGatewayGroup(UpdateGatewayGroupRequest updateGatewayGroupRequest)
            throws NotFoundException, NameInUseException, AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGatewayGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateGatewayGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateGatewayGroupRequest, UpdateGatewayGroupResponse>()
                .withOperationName("UpdateGatewayGroup").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateGatewayGroupRequest)
                .withMarshaller(new UpdateGatewayGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates an existing room profile by room profile ARN.
     * </p>
     *
     * @param updateProfileRequest
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateProfileResponse updateProfile(UpdateProfileRequest updateProfileRequest) throws NotFoundException,
            NameInUseException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateProfileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateProfileRequest, UpdateProfileResponse>()
                .withOperationName("UpdateProfile").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateProfileRequest)
                .withMarshaller(new UpdateProfileRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates room details by room ARN.
     * </p>
     *
     * @param updateRoomRequest
     * @return Result of the UpdateRoom operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateRoomResponse updateRoom(UpdateRoomRequest updateRoomRequest) throws NotFoundException, NameInUseException,
            AwsServiceException, SdkClientException, AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRoomResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateRoomResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateRoomRequest, UpdateRoomResponse>()
                .withOperationName("UpdateRoom").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateRoomRequest)
                .withMarshaller(new UpdateRoomRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates skill group details by skill group ARN.
     * </p>
     *
     * @param updateSkillGroupRequest
     * @return Result of the UpdateSkillGroup operation returned by the service.
     * @throws NotFoundException
     *         The resource is not found.
     * @throws NameInUseException
     *         The name sent in the request is already in use.
     * @throws ConcurrentModificationException
     *         There is a concurrent modification of resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AlexaForBusinessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AlexaForBusinessClient.UpdateSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateSkillGroupResponse updateSkillGroup(UpdateSkillGroupRequest updateSkillGroupRequest) throws NotFoundException,
            NameInUseException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AlexaForBusinessException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSkillGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateSkillGroupRequest, UpdateSkillGroupResponse>()
                .withOperationName("UpdateSkillGroup").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateSkillGroupRequest)
                .withMarshaller(new UpdateSkillGroupRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(AlexaForBusinessException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SkillNotLinkedException")
                                .exceptionBuilderSupplier(SkillNotLinkedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAssociatedException")
                                .exceptionBuilderSupplier(ResourceAssociatedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NameInUseException")
                                .exceptionBuilderSupplier(NameInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AlreadyExistsException")
                                .exceptionBuilderSupplier(AlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidUserStatusException")
                                .exceptionBuilderSupplier(InvalidUserStatusException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCertificateAuthorityException")
                                .exceptionBuilderSupplier(InvalidCertificateAuthorityException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeviceException")
                                .exceptionBuilderSupplier(InvalidDeviceException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeviceNotRegisteredException")
                                .exceptionBuilderSupplier(DeviceNotRegisteredException::builder).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends AlexaForBusinessRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
