/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The audio message. There is a 1 MB limit on the audio file input, and the only supported format is MP3. You must
 * convert audio files to an Alexa-friendly format.
 * </p>
 * <p>
 * You might need to use converter software to convert your MP3 files to the required codec version (MPEG version 2) and
 * bit rate (48 kbps). One option for this is a command-line tool, FFmpeg. For more information, see <a
 * href="https://www.ffmpeg.org/">FFmpeg</a>. The following command converts the provided &lt;input-file&gt; to an MP3
 * file that will be played in the announcement:
 * </p>
 * <p>
 * <code>ffmpeg -i &lt;input-file&gt; -ac 2 -codec:a libmp3lame -b:a 48k -ar 16000 &lt;output-file.mp3&gt;</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Audio implements SdkPojo, Serializable, ToCopyableBuilder<Audio.Builder, Audio> {
    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Audio::localeAsString)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Audio::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCALE_FIELD, LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String locale;

    private final String location;

    private Audio(BuilderImpl builder) {
        this.locale = builder.locale;
        this.location = builder.location;
    }

    /**
     * <p>
     * The locale of the audio message. Currently, en-US is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale of the audio message. Currently, en-US is supported.
     * @see Locale
     */
    public Locale locale() {
        return Locale.fromValue(locale);
    }

    /**
     * <p>
     * The locale of the audio message. Currently, en-US is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link Locale#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale of the audio message. Currently, en-US is supported.
     * @see Locale
     */
    public String localeAsString() {
        return locale;
    }

    /**
     * <p>
     * The location of the audio file. Currently, S3 URLs are supported. Only S3 locations comprised of safe character
     * are valid. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#Safe%20Characters">Safe Characters</a>.
     * </p>
     * 
     * @return The location of the audio file. Currently, S3 URLs are supported. Only S3 locations comprised of safe
     *         character are valid. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#Safe%20Characters">Safe
     *         Characters</a>.
     */
    public String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Audio)) {
            return false;
        }
        Audio other = (Audio) obj;
        return Objects.equals(localeAsString(), other.localeAsString()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Audio").add("Locale", localeAsString()).add("Location", location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Locale":
            return Optional.ofNullable(clazz.cast(localeAsString()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Audio, T> g) {
        return obj -> g.apply((Audio) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Audio> {
        /**
         * <p>
         * The locale of the audio message. Currently, en-US is supported.
         * </p>
         * 
         * @param locale
         *        The locale of the audio message. Currently, en-US is supported.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(String locale);

        /**
         * <p>
         * The locale of the audio message. Currently, en-US is supported.
         * </p>
         * 
         * @param locale
         *        The locale of the audio message. Currently, en-US is supported.
         * @see Locale
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Locale
         */
        Builder locale(Locale locale);

        /**
         * <p>
         * The location of the audio file. Currently, S3 URLs are supported. Only S3 locations comprised of safe
         * character are valid. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#Safe%20Characters">Safe
         * Characters</a>.
         * </p>
         * 
         * @param location
         *        The location of the audio file. Currently, S3 URLs are supported. Only S3 locations comprised of safe
         *        character are valid. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#Safe%20Characters">Safe
         *        Characters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl implements Builder {
        private String locale;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(Audio model) {
            locale(model.locale);
            location(model.location);
        }

        public final String getLocaleAsString() {
            return locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public Audio build() {
            return new Audio(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
