/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteProfileRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, DeleteProfileRequest> {
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteProfileRequest.getter(DeleteProfileRequest::profileArn)).setter(DeleteProfileRequest.setter(Builder::profileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ARN_FIELD));
    private final String profileArn;

    private DeleteProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileArn = builder.profileArn;
    }

    public String profileArn() {
        return this.profileArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteProfileRequest)) {
            return false;
        }
        DeleteProfileRequest other = (DeleteProfileRequest)((Object)obj);
        return Objects.equals(this.profileArn(), other.profileArn());
    }

    public String toString() {
        return ToString.builder((String)"DeleteProfileRequest").add("ProfileArn", (Object)this.profileArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileArn": {
                return Optional.ofNullable(clazz.cast(this.profileArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteProfileRequest, T> g) {
        return obj -> g.apply((DeleteProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String profileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteProfileRequest model) {
            super(model);
            this.profileArn(model.profileArn);
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteProfileRequest build() {
            return new DeleteProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteProfileRequest> {
        public Builder profileArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

