/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A room profile with attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Profile implements SdkPojo, Serializable, ToCopyableBuilder<Profile.Builder, Profile> {
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Profile::profileArn)).setter(setter(Builder::profileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()).build();

    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Profile::profileName)).setter(setter(Builder::profileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Profile::isDefault)).setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()).build();

    private static final SdkField<String> ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Profile::address)).setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Profile::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Profile::distanceUnitAsString)).setter(setter(Builder::distanceUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()).build();

    private static final SdkField<String> TEMPERATURE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Profile::temperatureUnitAsString)).setter(setter(Builder::temperatureUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemperatureUnit").build()).build();

    private static final SdkField<String> WAKE_WORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Profile::wakeWordAsString)).setter(setter(Builder::wakeWord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WakeWord").build()).build();

    private static final SdkField<Boolean> SETUP_MODE_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Profile::setupModeDisabled)).setter(setter(Builder::setupModeDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetupModeDisabled").build()).build();

    private static final SdkField<Integer> MAX_VOLUME_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Profile::maxVolumeLimit)).setter(setter(Builder::maxVolumeLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxVolumeLimit").build()).build();

    private static final SdkField<Boolean> PSTN_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Profile::pstnEnabled)).setter(setter(Builder::pstnEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PSTNEnabled").build()).build();

    private static final SdkField<String> ADDRESS_BOOK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Profile::addressBookArn)).setter(setter(Builder::addressBookArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressBookArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ARN_FIELD,
            PROFILE_NAME_FIELD, IS_DEFAULT_FIELD, ADDRESS_FIELD, TIMEZONE_FIELD, DISTANCE_UNIT_FIELD, TEMPERATURE_UNIT_FIELD,
            WAKE_WORD_FIELD, SETUP_MODE_DISABLED_FIELD, MAX_VOLUME_LIMIT_FIELD, PSTN_ENABLED_FIELD, ADDRESS_BOOK_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String profileArn;

    private final String profileName;

    private final Boolean isDefault;

    private final String address;

    private final String timezone;

    private final String distanceUnit;

    private final String temperatureUnit;

    private final String wakeWord;

    private final Boolean setupModeDisabled;

    private final Integer maxVolumeLimit;

    private final Boolean pstnEnabled;

    private final String addressBookArn;

    private Profile(BuilderImpl builder) {
        this.profileArn = builder.profileArn;
        this.profileName = builder.profileName;
        this.isDefault = builder.isDefault;
        this.address = builder.address;
        this.timezone = builder.timezone;
        this.distanceUnit = builder.distanceUnit;
        this.temperatureUnit = builder.temperatureUnit;
        this.wakeWord = builder.wakeWord;
        this.setupModeDisabled = builder.setupModeDisabled;
        this.maxVolumeLimit = builder.maxVolumeLimit;
        this.pstnEnabled = builder.pstnEnabled;
        this.addressBookArn = builder.addressBookArn;
    }

    /**
     * <p>
     * The ARN of a room profile.
     * </p>
     * 
     * @return The ARN of a room profile.
     */
    public String profileArn() {
        return profileArn;
    }

    /**
     * <p>
     * The name of a room profile.
     * </p>
     * 
     * @return The name of a room profile.
     */
    public String profileName() {
        return profileName;
    }

    /**
     * <p>
     * Retrieves if the profile is default or not.
     * </p>
     * 
     * @return Retrieves if the profile is default or not.
     */
    public Boolean isDefault() {
        return isDefault;
    }

    /**
     * <p>
     * The address of a room profile.
     * </p>
     * 
     * @return The address of a room profile.
     */
    public String address() {
        return address;
    }

    /**
     * <p>
     * The time zone of a room profile.
     * </p>
     * 
     * @return The time zone of a room profile.
     */
    public String timezone() {
        return timezone;
    }

    /**
     * <p>
     * The distance unit of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The distance unit of a room profile.
     * @see DistanceUnit
     */
    public DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(distanceUnit);
    }

    /**
     * <p>
     * The distance unit of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The distance unit of a room profile.
     * @see DistanceUnit
     */
    public String distanceUnitAsString() {
        return distanceUnit;
    }

    /**
     * <p>
     * The temperature unit of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #temperatureUnit}
     * will return {@link TemperatureUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #temperatureUnitAsString}.
     * </p>
     * 
     * @return The temperature unit of a room profile.
     * @see TemperatureUnit
     */
    public TemperatureUnit temperatureUnit() {
        return TemperatureUnit.fromValue(temperatureUnit);
    }

    /**
     * <p>
     * The temperature unit of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #temperatureUnit}
     * will return {@link TemperatureUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #temperatureUnitAsString}.
     * </p>
     * 
     * @return The temperature unit of a room profile.
     * @see TemperatureUnit
     */
    public String temperatureUnitAsString() {
        return temperatureUnit;
    }

    /**
     * <p>
     * The wake word of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wakeWord} will
     * return {@link WakeWord#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wakeWordAsString}.
     * </p>
     * 
     * @return The wake word of a room profile.
     * @see WakeWord
     */
    public WakeWord wakeWord() {
        return WakeWord.fromValue(wakeWord);
    }

    /**
     * <p>
     * The wake word of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wakeWord} will
     * return {@link WakeWord#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wakeWordAsString}.
     * </p>
     * 
     * @return The wake word of a room profile.
     * @see WakeWord
     */
    public String wakeWordAsString() {
        return wakeWord;
    }

    /**
     * <p>
     * The setup mode of a room profile.
     * </p>
     * 
     * @return The setup mode of a room profile.
     */
    public Boolean setupModeDisabled() {
        return setupModeDisabled;
    }

    /**
     * <p>
     * The max volume limit of a room profile.
     * </p>
     * 
     * @return The max volume limit of a room profile.
     */
    public Integer maxVolumeLimit() {
        return maxVolumeLimit;
    }

    /**
     * <p>
     * The PSTN setting of a room profile.
     * </p>
     * 
     * @return The PSTN setting of a room profile.
     */
    public Boolean pstnEnabled() {
        return pstnEnabled;
    }

    /**
     * <p>
     * The ARN of the address book.
     * </p>
     * 
     * @return The ARN of the address book.
     */
    public String addressBookArn() {
        return addressBookArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(distanceUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(temperatureUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(wakeWordAsString());
        hashCode = 31 * hashCode + Objects.hashCode(setupModeDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(maxVolumeLimit());
        hashCode = 31 * hashCode + Objects.hashCode(pstnEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(addressBookArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Profile)) {
            return false;
        }
        Profile other = (Profile) obj;
        return Objects.equals(profileArn(), other.profileArn()) && Objects.equals(profileName(), other.profileName())
                && Objects.equals(isDefault(), other.isDefault()) && Objects.equals(address(), other.address())
                && Objects.equals(timezone(), other.timezone())
                && Objects.equals(distanceUnitAsString(), other.distanceUnitAsString())
                && Objects.equals(temperatureUnitAsString(), other.temperatureUnitAsString())
                && Objects.equals(wakeWordAsString(), other.wakeWordAsString())
                && Objects.equals(setupModeDisabled(), other.setupModeDisabled())
                && Objects.equals(maxVolumeLimit(), other.maxVolumeLimit()) && Objects.equals(pstnEnabled(), other.pstnEnabled())
                && Objects.equals(addressBookArn(), other.addressBookArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Profile").add("ProfileArn", profileArn()).add("ProfileName", profileName())
                .add("IsDefault", isDefault()).add("Address", address()).add("Timezone", timezone())
                .add("DistanceUnit", distanceUnitAsString()).add("TemperatureUnit", temperatureUnitAsString())
                .add("WakeWord", wakeWordAsString()).add("SetupModeDisabled", setupModeDisabled())
                .add("MaxVolumeLimit", maxVolumeLimit()).add("PSTNEnabled", pstnEnabled())
                .add("AddressBookArn", addressBookArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileArn":
            return Optional.ofNullable(clazz.cast(profileArn()));
        case "ProfileName":
            return Optional.ofNullable(clazz.cast(profileName()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "DistanceUnit":
            return Optional.ofNullable(clazz.cast(distanceUnitAsString()));
        case "TemperatureUnit":
            return Optional.ofNullable(clazz.cast(temperatureUnitAsString()));
        case "WakeWord":
            return Optional.ofNullable(clazz.cast(wakeWordAsString()));
        case "SetupModeDisabled":
            return Optional.ofNullable(clazz.cast(setupModeDisabled()));
        case "MaxVolumeLimit":
            return Optional.ofNullable(clazz.cast(maxVolumeLimit()));
        case "PSTNEnabled":
            return Optional.ofNullable(clazz.cast(pstnEnabled()));
        case "AddressBookArn":
            return Optional.ofNullable(clazz.cast(addressBookArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Profile, T> g) {
        return obj -> g.apply((Profile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Profile> {
        /**
         * <p>
         * The ARN of a room profile.
         * </p>
         * 
         * @param profileArn
         *        The ARN of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);

        /**
         * <p>
         * The name of a room profile.
         * </p>
         * 
         * @param profileName
         *        The name of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * Retrieves if the profile is default or not.
         * </p>
         * 
         * @param isDefault
         *        Retrieves if the profile is default or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * The address of a room profile.
         * </p>
         * 
         * @param address
         *        The address of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The time zone of a room profile.
         * </p>
         * 
         * @param timezone
         *        The time zone of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * The distance unit of a room profile.
         * </p>
         * 
         * @param distanceUnit
         *        The distance unit of a room profile.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(String distanceUnit);

        /**
         * <p>
         * The distance unit of a room profile.
         * </p>
         * 
         * @param distanceUnit
         *        The distance unit of a room profile.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(DistanceUnit distanceUnit);

        /**
         * <p>
         * The temperature unit of a room profile.
         * </p>
         * 
         * @param temperatureUnit
         *        The temperature unit of a room profile.
         * @see TemperatureUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemperatureUnit
         */
        Builder temperatureUnit(String temperatureUnit);

        /**
         * <p>
         * The temperature unit of a room profile.
         * </p>
         * 
         * @param temperatureUnit
         *        The temperature unit of a room profile.
         * @see TemperatureUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemperatureUnit
         */
        Builder temperatureUnit(TemperatureUnit temperatureUnit);

        /**
         * <p>
         * The wake word of a room profile.
         * </p>
         * 
         * @param wakeWord
         *        The wake word of a room profile.
         * @see WakeWord
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WakeWord
         */
        Builder wakeWord(String wakeWord);

        /**
         * <p>
         * The wake word of a room profile.
         * </p>
         * 
         * @param wakeWord
         *        The wake word of a room profile.
         * @see WakeWord
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WakeWord
         */
        Builder wakeWord(WakeWord wakeWord);

        /**
         * <p>
         * The setup mode of a room profile.
         * </p>
         * 
         * @param setupModeDisabled
         *        The setup mode of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setupModeDisabled(Boolean setupModeDisabled);

        /**
         * <p>
         * The max volume limit of a room profile.
         * </p>
         * 
         * @param maxVolumeLimit
         *        The max volume limit of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxVolumeLimit(Integer maxVolumeLimit);

        /**
         * <p>
         * The PSTN setting of a room profile.
         * </p>
         * 
         * @param pstnEnabled
         *        The PSTN setting of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pstnEnabled(Boolean pstnEnabled);

        /**
         * <p>
         * The ARN of the address book.
         * </p>
         * 
         * @param addressBookArn
         *        The ARN of the address book.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressBookArn(String addressBookArn);
    }

    static final class BuilderImpl implements Builder {
        private String profileArn;

        private String profileName;

        private Boolean isDefault;

        private String address;

        private String timezone;

        private String distanceUnit;

        private String temperatureUnit;

        private String wakeWord;

        private Boolean setupModeDisabled;

        private Integer maxVolumeLimit;

        private Boolean pstnEnabled;

        private String addressBookArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Profile model) {
            profileArn(model.profileArn);
            profileName(model.profileName);
            isDefault(model.isDefault);
            address(model.address);
            timezone(model.timezone);
            distanceUnit(model.distanceUnit);
            temperatureUnit(model.temperatureUnit);
            wakeWord(model.wakeWord);
            setupModeDisabled(model.setupModeDisabled);
            maxVolumeLimit(model.maxVolumeLimit);
            pstnEnabled(model.pstnEnabled);
            addressBookArn(model.addressBookArn);
        }

        public final String getProfileArn() {
            return profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        public final String getProfileName() {
            return profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public final String getAddress() {
            return address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getTimezone() {
            return timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final String getDistanceUnitAsString() {
            return distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit.toString());
            return this;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        public final String getTemperatureUnitAsString() {
            return temperatureUnit;
        }

        @Override
        public final Builder temperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
            return this;
        }

        @Override
        public final Builder temperatureUnit(TemperatureUnit temperatureUnit) {
            this.temperatureUnit(temperatureUnit.toString());
            return this;
        }

        public final void setTemperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
        }

        public final String getWakeWordAsString() {
            return wakeWord;
        }

        @Override
        public final Builder wakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
            return this;
        }

        @Override
        public final Builder wakeWord(WakeWord wakeWord) {
            this.wakeWord(wakeWord.toString());
            return this;
        }

        public final void setWakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
        }

        public final Boolean getSetupModeDisabled() {
            return setupModeDisabled;
        }

        @Override
        public final Builder setupModeDisabled(Boolean setupModeDisabled) {
            this.setupModeDisabled = setupModeDisabled;
            return this;
        }

        public final void setSetupModeDisabled(Boolean setupModeDisabled) {
            this.setupModeDisabled = setupModeDisabled;
        }

        public final Integer getMaxVolumeLimit() {
            return maxVolumeLimit;
        }

        @Override
        public final Builder maxVolumeLimit(Integer maxVolumeLimit) {
            this.maxVolumeLimit = maxVolumeLimit;
            return this;
        }

        public final void setMaxVolumeLimit(Integer maxVolumeLimit) {
            this.maxVolumeLimit = maxVolumeLimit;
        }

        public final Boolean getPstnEnabled() {
            return pstnEnabled;
        }

        @Override
        public final Builder pstnEnabled(Boolean pstnEnabled) {
            this.pstnEnabled = pstnEnabled;
            return this;
        }

        public final void setPstnEnabled(Boolean pstnEnabled) {
            this.pstnEnabled = pstnEnabled;
        }

        public final String getAddressBookArn() {
            return addressBookArn;
        }

        @Override
        public final Builder addressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
            return this;
        }

        public final void setAddressBookArn(String addressBookArn) {
            this.addressBookArn = addressBookArn;
        }

        @Override
        public Profile build() {
            return new Profile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
