/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProvider;
import software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProvidersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConferenceProvidersResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, ListConferenceProvidersResponse> {
    private static final SdkField<List<ConferenceProvider>> CONFERENCE_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListConferenceProvidersResponse.getter(ListConferenceProvidersResponse::conferenceProviders)).setter(ListConferenceProvidersResponse.setter(Builder::conferenceProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConferenceProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConferenceProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListConferenceProvidersResponse.getter(ListConferenceProvidersResponse::nextToken)).setter(ListConferenceProvidersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFERENCE_PROVIDERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ConferenceProvider> conferenceProviders;
    private final String nextToken;

    private ListConferenceProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.conferenceProviders = builder.conferenceProviders;
        this.nextToken = builder.nextToken;
    }

    public List<ConferenceProvider> conferenceProviders() {
        return this.conferenceProviders;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conferenceProviders());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConferenceProvidersResponse)) {
            return false;
        }
        ListConferenceProvidersResponse other = (ListConferenceProvidersResponse)((Object)obj);
        return Objects.equals(this.conferenceProviders(), other.conferenceProviders()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListConferenceProvidersResponse").add("ConferenceProviders", this.conferenceProviders()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConferenceProviders": {
                return Optional.ofNullable(clazz.cast(this.conferenceProviders()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListConferenceProvidersResponse, T> g) {
        return obj -> g.apply((ListConferenceProvidersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<ConferenceProvider> conferenceProviders = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConferenceProvidersResponse model) {
            super(model);
            this.conferenceProviders(model.conferenceProviders);
            this.nextToken(model.nextToken);
        }

        public final Collection<ConferenceProvider.Builder> getConferenceProviders() {
            return this.conferenceProviders != null ? (Collection)this.conferenceProviders.stream().map(ConferenceProvider::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conferenceProviders(Collection<ConferenceProvider> conferenceProviders) {
            this.conferenceProviders = ConferenceProvidersListCopier.copy(conferenceProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conferenceProviders(ConferenceProvider ... conferenceProviders) {
            this.conferenceProviders(Arrays.asList(conferenceProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conferenceProviders(Consumer<ConferenceProvider.Builder> ... conferenceProviders) {
            this.conferenceProviders(Stream.of(conferenceProviders).map(c -> (ConferenceProvider)((ConferenceProvider.Builder)ConferenceProvider.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConferenceProviders(Collection<ConferenceProvider.BuilderImpl> conferenceProviders) {
            this.conferenceProviders = ConferenceProvidersListCopier.copyFromBuilder(conferenceProviders);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListConferenceProvidersResponse build() {
            return new ListConferenceProvidersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConferenceProvidersResponse> {
        public Builder conferenceProviders(Collection<ConferenceProvider> var1);

        public Builder conferenceProviders(ConferenceProvider ... var1);

        public Builder conferenceProviders(Consumer<ConferenceProvider.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

