/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessException;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AlreadyExistsException;
import software.amazon.awssdk.services.alexaforbusiness.model.ApproveSkillRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ApproveSkillResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateContactWithAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateContactWithAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithNetworkProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithNetworkProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithUsersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ConcurrentModificationException;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateUserRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateUserResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteBusinessReportScheduleRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteBusinessReportScheduleResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceUsageDataRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceUsageDataResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteNetworkProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteNetworkProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillAuthorizationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillAuthorizationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceNotRegisteredException;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateContactFromAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateContactFromAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromUsersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ForgetSmartHomeAppliancesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferencePreferenceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferencePreferenceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetInvitationConfigurationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetInvitationConfigurationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetNetworkProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetNetworkProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.InvalidCertificateAuthorityException;
import software.amazon.awssdk.services.alexaforbusiness.model.InvalidDeviceException;
import software.amazon.awssdk.services.alexaforbusiness.model.InvalidSecretsManagerResourceException;
import software.amazon.awssdk.services.alexaforbusiness.model.InvalidServiceLinkedRoleStateException;
import software.amazon.awssdk.services.alexaforbusiness.model.InvalidUserStatusException;
import software.amazon.awssdk.services.alexaforbusiness.model.LimitExceededException;
import software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.NameInUseException;
import software.amazon.awssdk.services.alexaforbusiness.model.NotFoundException;
import software.amazon.awssdk.services.alexaforbusiness.model.PutConferencePreferenceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutConferencePreferenceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.PutInvitationConfigurationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutInvitationConfigurationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.PutSkillAuthorizationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutSkillAuthorizationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.RejectSkillRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.RejectSkillResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ResourceAssociatedException;
import software.amazon.awssdk.services.alexaforbusiness.model.ResourceInUseException;
import software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SkillNotLinkedException;
import software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.TagResourceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.TagResourceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UnauthorizedException;
import software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateBusinessReportScheduleRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateBusinessReportScheduleResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateNetworkProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateNetworkProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchNetworkProfilesPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersPublisher;
import software.amazon.awssdk.services.alexaforbusiness.transform.ApproveSkillRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.AssociateContactWithAddressBookRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.AssociateDeviceWithNetworkProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.AssociateDeviceWithRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.AssociateSkillGroupWithRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.AssociateSkillWithSkillGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.AssociateSkillWithUsersRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateAddressBookRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateBusinessReportScheduleRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateConferenceProviderRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateContactRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateGatewayGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateNetworkProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateSkillGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteAddressBookRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteBusinessReportScheduleRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteConferenceProviderRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteContactRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteDeviceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteDeviceUsageDataRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteGatewayGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteNetworkProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteRoomSkillParameterRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteSkillAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteSkillGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DisassociateContactFromAddressBookRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DisassociateDeviceFromRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DisassociateSkillFromSkillGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DisassociateSkillFromUsersRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.DisassociateSkillGroupFromRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ForgetSmartHomeAppliancesRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetAddressBookRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetConferencePreferenceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetConferenceProviderRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetContactRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetDeviceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetGatewayGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetGatewayRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetInvitationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetNetworkProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetRoomSkillParameterRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.GetSkillGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListBusinessReportSchedulesRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListConferenceProvidersRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListDeviceEventsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListGatewayGroupsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListGatewaysRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListSkillsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListSkillsStoreCategoriesRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListSkillsStoreSkillsByCategoryRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListSmartHomeAppliancesRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.PutConferencePreferenceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.PutInvitationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.PutRoomSkillParameterRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.PutSkillAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.RegisterAvsDeviceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.RejectSkillRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.ResolveRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.RevokeInvitationRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchAddressBooksRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchContactsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchDevicesRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchNetworkProfilesRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchProfilesRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchRoomsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchSkillGroupsRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SearchUsersRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SendAnnouncementRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.SendInvitationRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.StartDeviceSyncRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.StartSmartHomeApplianceDiscoveryRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateAddressBookRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateBusinessReportScheduleRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateConferenceProviderRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateContactRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateDeviceRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateGatewayGroupRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateGatewayRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateNetworkProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateProfileRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateRoomRequestMarshaller;
import software.amazon.awssdk.services.alexaforbusiness.transform.UpdateSkillGroupRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link AlexaForBusinessAsyncClient}.
 *
 * @see AlexaForBusinessAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultAlexaForBusinessAsyncClient implements AlexaForBusinessAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultAlexaForBusinessAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAlexaForBusinessAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Associates a skill with the organization under the customer's AWS account. If a skill is private, the user
     * implicitly accepts access to this skill during enablement.
     * </p>
     *
     * @param approveSkillRequest
     * @return A Java Future containing the result of the ApproveSkill operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ApproveSkill
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ApproveSkill" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ApproveSkillResponse> approveSkill(ApproveSkillRequest approveSkillRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ApproveSkillResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ApproveSkillResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ApproveSkillResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ApproveSkillRequest, ApproveSkillResponse>()
                            .withOperationName("ApproveSkill").withMarshaller(new ApproveSkillRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(approveSkillRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a contact with a given address book.
     * </p>
     *
     * @param associateContactWithAddressBookRequest
     * @return A Java Future containing the result of the AssociateContactWithAddressBook operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateContactWithAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateContactWithAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateContactWithAddressBookResponse> associateContactWithAddressBook(
            AssociateContactWithAddressBookRequest associateContactWithAddressBookRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateContactWithAddressBookResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateContactWithAddressBookResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateContactWithAddressBookResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateContactWithAddressBookRequest, AssociateContactWithAddressBookResponse>()
                            .withOperationName("AssociateContactWithAddressBook")
                            .withMarshaller(new AssociateContactWithAddressBookRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateContactWithAddressBookRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a device with the specified network profile.
     * </p>
     *
     * @param associateDeviceWithNetworkProfileRequest
     * @return A Java Future containing the result of the AssociateDeviceWithNetworkProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateDeviceWithNetworkProfile
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateDeviceWithNetworkProfileResponse> associateDeviceWithNetworkProfile(
            AssociateDeviceWithNetworkProfileRequest associateDeviceWithNetworkProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateDeviceWithNetworkProfileResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateDeviceWithNetworkProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateDeviceWithNetworkProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateDeviceWithNetworkProfileRequest, AssociateDeviceWithNetworkProfileResponse>()
                            .withOperationName("AssociateDeviceWithNetworkProfile")
                            .withMarshaller(new AssociateDeviceWithNetworkProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateDeviceWithNetworkProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a device with a given room. This applies all the settings from the room profile to the device, and all
     * the skills in any skill groups added to that room. This operation requires the device to be online, or else a
     * manual sync is required.
     * </p>
     *
     * @param associateDeviceWithRoomRequest
     * @return A Java Future containing the result of the AssociateDeviceWithRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateDeviceWithRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateDeviceWithRoomResponse> associateDeviceWithRoom(
            AssociateDeviceWithRoomRequest associateDeviceWithRoomRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateDeviceWithRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateDeviceWithRoomResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateDeviceWithRoomResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateDeviceWithRoomRequest, AssociateDeviceWithRoomResponse>()
                            .withOperationName("AssociateDeviceWithRoom")
                            .withMarshaller(new AssociateDeviceWithRoomRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateDeviceWithRoomRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a skill group with a given room. This enables all skills in the associated skill group on all devices
     * in the room.
     * </p>
     *
     * @param associateSkillGroupWithRoomRequest
     * @return A Java Future containing the result of the AssociateSkillGroupWithRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateSkillGroupWithRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillGroupWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateSkillGroupWithRoomResponse> associateSkillGroupWithRoom(
            AssociateSkillGroupWithRoomRequest associateSkillGroupWithRoomRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateSkillGroupWithRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateSkillGroupWithRoomResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateSkillGroupWithRoomResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateSkillGroupWithRoomRequest, AssociateSkillGroupWithRoomResponse>()
                            .withOperationName("AssociateSkillGroupWithRoom")
                            .withMarshaller(new AssociateSkillGroupWithRoomRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateSkillGroupWithRoomRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a skill with a skill group.
     * </p>
     *
     * @param associateSkillWithSkillGroupRequest
     * @return A Java Future containing the result of the AssociateSkillWithSkillGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SkillNotLinkedException The skill must be linked to a third-party account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateSkillWithSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateSkillWithSkillGroupResponse> associateSkillWithSkillGroup(
            AssociateSkillWithSkillGroupRequest associateSkillWithSkillGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateSkillWithSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateSkillWithSkillGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateSkillWithSkillGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateSkillWithSkillGroupRequest, AssociateSkillWithSkillGroupResponse>()
                            .withOperationName("AssociateSkillWithSkillGroup")
                            .withMarshaller(new AssociateSkillWithSkillGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateSkillWithSkillGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Makes a private skill available for enrolled users to enable on their devices.
     * </p>
     *
     * @param associateSkillWithUsersRequest
     * @return A Java Future containing the result of the AssociateSkillWithUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateSkillWithUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithUsers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateSkillWithUsersResponse> associateSkillWithUsers(
            AssociateSkillWithUsersRequest associateSkillWithUsersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateSkillWithUsersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateSkillWithUsersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateSkillWithUsersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateSkillWithUsersRequest, AssociateSkillWithUsersResponse>()
                            .withOperationName("AssociateSkillWithUsers")
                            .withMarshaller(new AssociateSkillWithUsersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateSkillWithUsersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an address book with the specified details.
     * </p>
     *
     * @param createAddressBookRequest
     * @return A Java Future containing the result of the CreateAddressBook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAddressBookResponse> createAddressBook(CreateAddressBookRequest createAddressBookRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAddressBookResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAddressBookResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAddressBookResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAddressBookRequest, CreateAddressBookResponse>()
                            .withOperationName("CreateAddressBook")
                            .withMarshaller(new CreateAddressBookRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createAddressBookRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a recurring schedule for usage reports to deliver to the specified S3 location with a specified daily or
     * weekly interval.
     * </p>
     *
     * @param createBusinessReportScheduleRequest
     * @return A Java Future containing the result of the CreateBusinessReportSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateBusinessReportSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBusinessReportScheduleResponse> createBusinessReportSchedule(
            CreateBusinessReportScheduleRequest createBusinessReportScheduleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBusinessReportScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBusinessReportScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBusinessReportScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBusinessReportScheduleRequest, CreateBusinessReportScheduleResponse>()
                            .withOperationName("CreateBusinessReportSchedule")
                            .withMarshaller(new CreateBusinessReportScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createBusinessReportScheduleRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a new conference provider under the user's AWS account.
     * </p>
     *
     * @param createConferenceProviderRequest
     * @return A Java Future containing the result of the CreateConferenceProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConferenceProviderResponse> createConferenceProvider(
            CreateConferenceProviderRequest createConferenceProviderRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConferenceProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateConferenceProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConferenceProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConferenceProviderRequest, CreateConferenceProviderResponse>()
                            .withOperationName("CreateConferenceProvider")
                            .withMarshaller(new CreateConferenceProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createConferenceProviderRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a contact with the specified details.
     * </p>
     *
     * @param createContactRequest
     * @return A Java Future containing the result of the CreateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateContact" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContactResponse> createContact(CreateContactRequest createContactRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateContactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateContactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateContactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContactRequest, CreateContactResponse>()
                            .withOperationName("CreateContact")
                            .withMarshaller(new CreateContactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createContactRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a gateway group with the specified details.
     * </p>
     *
     * @param createGatewayGroupRequest
     * @return A Java Future containing the result of the CreateGatewayGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGatewayGroupResponse> createGatewayGroup(CreateGatewayGroupRequest createGatewayGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGatewayGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateGatewayGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateGatewayGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGatewayGroupRequest, CreateGatewayGroupResponse>()
                            .withOperationName("CreateGatewayGroup")
                            .withMarshaller(new CreateGatewayGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createGatewayGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a network profile with the specified details.
     * </p>
     *
     * @param createNetworkProfileRequest
     * @return A Java Future containing the result of the CreateNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>InvalidCertificateAuthorityException The Certificate Authority can't issue or revoke a certificate.</li>
     *         <li>InvalidServiceLinkedRoleStateException The service linked role is locked for deletion.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkProfileResponse> createNetworkProfile(
            CreateNetworkProfileRequest createNetworkProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNetworkProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateNetworkProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateNetworkProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkProfileRequest, CreateNetworkProfileResponse>()
                            .withOperationName("CreateNetworkProfile")
                            .withMarshaller(new CreateNetworkProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createNetworkProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new room profile with the specified details.
     * </p>
     *
     * @param createProfileRequest
     * @return A Java Future containing the result of the CreateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateProfileResponse> createProfile(CreateProfileRequest createProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateProfileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateProfileRequest, CreateProfileResponse>()
                            .withOperationName("CreateProfile")
                            .withMarshaller(new CreateProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a room with the specified details.
     * </p>
     *
     * @param createRoomRequest
     * @return A Java Future containing the result of the CreateRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRoomResponse> createRoom(CreateRoomRequest createRoomRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRoomResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateRoomResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRoomResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRoomRequest, CreateRoomResponse>().withOperationName("CreateRoom")
                            .withMarshaller(new CreateRoomRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createRoomRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a skill group with a specified name and description.
     * </p>
     *
     * @param createSkillGroupRequest
     * @return A Java Future containing the result of the CreateSkillGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSkillGroupResponse> createSkillGroup(CreateSkillGroupRequest createSkillGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSkillGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSkillGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSkillGroupRequest, CreateSkillGroupResponse>()
                            .withOperationName("CreateSkillGroup")
                            .withMarshaller(new CreateSkillGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createSkillGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a user.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The resource in the request is already in use.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>().withOperationName("CreateUser")
                            .withMarshaller(new CreateUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createUserRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an address book by the address book ARN.
     * </p>
     *
     * @param deleteAddressBookRequest
     * @return A Java Future containing the result of the DeleteAddressBook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAddressBookResponse> deleteAddressBook(DeleteAddressBookRequest deleteAddressBookRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAddressBookResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAddressBookResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAddressBookResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAddressBookRequest, DeleteAddressBookResponse>()
                            .withOperationName("DeleteAddressBook")
                            .withMarshaller(new DeleteAddressBookRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteAddressBookRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the recurring report delivery schedule with the specified schedule ARN.
     * </p>
     *
     * @param deleteBusinessReportScheduleRequest
     * @return A Java Future containing the result of the DeleteBusinessReportSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteBusinessReportSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBusinessReportScheduleResponse> deleteBusinessReportSchedule(
            DeleteBusinessReportScheduleRequest deleteBusinessReportScheduleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBusinessReportScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBusinessReportScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBusinessReportScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBusinessReportScheduleRequest, DeleteBusinessReportScheduleResponse>()
                            .withOperationName("DeleteBusinessReportSchedule")
                            .withMarshaller(new DeleteBusinessReportScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteBusinessReportScheduleRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a conference provider.
     * </p>
     *
     * @param deleteConferenceProviderRequest
     * @return A Java Future containing the result of the DeleteConferenceProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConferenceProviderResponse> deleteConferenceProvider(
            DeleteConferenceProviderRequest deleteConferenceProviderRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConferenceProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConferenceProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConferenceProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConferenceProviderRequest, DeleteConferenceProviderResponse>()
                            .withOperationName("DeleteConferenceProvider")
                            .withMarshaller(new DeleteConferenceProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteConferenceProviderRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a contact by the contact ARN.
     * </p>
     *
     * @param deleteContactRequest
     * @return A Java Future containing the result of the DeleteContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteContact" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteContactResponse> deleteContact(DeleteContactRequest deleteContactRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteContactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteContactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteContactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteContactRequest, DeleteContactResponse>()
                            .withOperationName("DeleteContact")
                            .withMarshaller(new DeleteContactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteContactRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a device from Alexa For Business.
     * </p>
     *
     * @param deleteDeviceRequest
     * @return A Java Future containing the result of the DeleteDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>InvalidCertificateAuthorityException The Certificate Authority can't issue or revoke a certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeviceResponse> deleteDevice(DeleteDeviceRequest deleteDeviceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDeviceRequest, DeleteDeviceResponse>()
                            .withOperationName("DeleteDevice").withMarshaller(new DeleteDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDeviceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * When this action is called for a specified shared device, it allows authorized users to delete the device's
     * entire previous history of voice input data. This action can be called once every 24 hours for a specific shared
     * device.
     * </p>
     *
     * @param deleteDeviceUsageDataRequest
     * @return A Java Future containing the result of the DeleteDeviceUsageData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteDeviceUsageData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDeviceUsageData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeviceUsageDataResponse> deleteDeviceUsageData(
            DeleteDeviceUsageDataRequest deleteDeviceUsageDataRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeviceUsageDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDeviceUsageDataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDeviceUsageDataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDeviceUsageDataRequest, DeleteDeviceUsageDataResponse>()
                            .withOperationName("DeleteDeviceUsageData")
                            .withMarshaller(new DeleteDeviceUsageDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteDeviceUsageDataRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a gateway group.
     * </p>
     *
     * @param deleteGatewayGroupRequest
     * @return A Java Future containing the result of the DeleteGatewayGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAssociatedException Another resource is associated with the resource in the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGatewayGroupResponse> deleteGatewayGroup(DeleteGatewayGroupRequest deleteGatewayGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGatewayGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteGatewayGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteGatewayGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGatewayGroupRequest, DeleteGatewayGroupResponse>()
                            .withOperationName("DeleteGatewayGroup")
                            .withMarshaller(new DeleteGatewayGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteGatewayGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a network profile by the network profile ARN.
     * </p>
     *
     * @param deleteNetworkProfileRequest
     * @return A Java Future containing the result of the DeleteNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The resource in the request is already in use.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkProfileResponse> deleteNetworkProfile(
            DeleteNetworkProfileRequest deleteNetworkProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNetworkProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteNetworkProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteNetworkProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkProfileRequest, DeleteNetworkProfileResponse>()
                            .withOperationName("DeleteNetworkProfile")
                            .withMarshaller(new DeleteNetworkProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteNetworkProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a room profile by the profile ARN.
     * </p>
     *
     * @param deleteProfileRequest
     * @return A Java Future containing the result of the DeleteProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteProfileResponse> deleteProfile(DeleteProfileRequest deleteProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteProfileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteProfileRequest, DeleteProfileResponse>()
                            .withOperationName("DeleteProfile")
                            .withMarshaller(new DeleteProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a room by the room ARN.
     * </p>
     *
     * @param deleteRoomRequest
     * @return A Java Future containing the result of the DeleteRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoom" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRoomResponse> deleteRoom(DeleteRoomRequest deleteRoomRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRoomResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteRoomResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRoomResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRoomRequest, DeleteRoomResponse>().withOperationName("DeleteRoom")
                            .withMarshaller(new DeleteRoomRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteRoomRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes room skill parameter details by room, skill, and parameter key ID.
     * </p>
     *
     * @param deleteRoomSkillParameterRequest
     * @return A Java Future containing the result of the DeleteRoomSkillParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRoomSkillParameterResponse> deleteRoomSkillParameter(
            DeleteRoomSkillParameterRequest deleteRoomSkillParameterRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRoomSkillParameterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRoomSkillParameterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRoomSkillParameterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRoomSkillParameterRequest, DeleteRoomSkillParameterResponse>()
                            .withOperationName("DeleteRoomSkillParameter")
                            .withMarshaller(new DeleteRoomSkillParameterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteRoomSkillParameterRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Unlinks a third-party account from a skill.
     * </p>
     *
     * @param deleteSkillAuthorizationRequest
     * @return A Java Future containing the result of the DeleteSkillAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteSkillAuthorization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSkillAuthorizationResponse> deleteSkillAuthorization(
            DeleteSkillAuthorizationRequest deleteSkillAuthorizationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSkillAuthorizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSkillAuthorizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSkillAuthorizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSkillAuthorizationRequest, DeleteSkillAuthorizationResponse>()
                            .withOperationName("DeleteSkillAuthorization")
                            .withMarshaller(new DeleteSkillAuthorizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteSkillAuthorizationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a skill group by skill group ARN.
     * </p>
     *
     * @param deleteSkillGroupRequest
     * @return A Java Future containing the result of the DeleteSkillGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSkillGroupResponse> deleteSkillGroup(DeleteSkillGroupRequest deleteSkillGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSkillGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSkillGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSkillGroupRequest, DeleteSkillGroupResponse>()
                            .withOperationName("DeleteSkillGroup")
                            .withMarshaller(new DeleteSkillGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteSkillGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specified user by user ARN and enrollment ARN.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>().withOperationName("DeleteUser")
                            .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteUserRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a contact from a given address book.
     * </p>
     *
     * @param disassociateContactFromAddressBookRequest
     * @return A Java Future containing the result of the DisassociateContactFromAddressBook operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DisassociateContactFromAddressBook
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateContactFromAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateContactFromAddressBookResponse> disassociateContactFromAddressBook(
            DisassociateContactFromAddressBookRequest disassociateContactFromAddressBookRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateContactFromAddressBookResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateContactFromAddressBookResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateContactFromAddressBookResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateContactFromAddressBookRequest, DisassociateContactFromAddressBookResponse>()
                            .withOperationName("DisassociateContactFromAddressBook")
                            .withMarshaller(new DisassociateContactFromAddressBookRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateContactFromAddressBookRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a device from its current room. The device continues to be connected to the Wi-Fi network and is
     * still registered to the account. The device settings and skills are removed from the room.
     * </p>
     *
     * @param disassociateDeviceFromRoomRequest
     * @return A Java Future containing the result of the DisassociateDeviceFromRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DisassociateDeviceFromRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateDeviceFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateDeviceFromRoomResponse> disassociateDeviceFromRoom(
            DisassociateDeviceFromRoomRequest disassociateDeviceFromRoomRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateDeviceFromRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateDeviceFromRoomResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateDeviceFromRoomResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateDeviceFromRoomRequest, DisassociateDeviceFromRoomResponse>()
                            .withOperationName("DisassociateDeviceFromRoom")
                            .withMarshaller(new DisassociateDeviceFromRoomRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateDeviceFromRoomRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a skill from a skill group.
     * </p>
     *
     * @param disassociateSkillFromSkillGroupRequest
     * @return A Java Future containing the result of the DisassociateSkillFromSkillGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DisassociateSkillFromSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateSkillFromSkillGroupResponse> disassociateSkillFromSkillGroup(
            DisassociateSkillFromSkillGroupRequest disassociateSkillFromSkillGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateSkillFromSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateSkillFromSkillGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateSkillFromSkillGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateSkillFromSkillGroupRequest, DisassociateSkillFromSkillGroupResponse>()
                            .withOperationName("DisassociateSkillFromSkillGroup")
                            .withMarshaller(new DisassociateSkillFromSkillGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateSkillFromSkillGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Makes a private skill unavailable for enrolled users and prevents them from enabling it on their devices.
     * </p>
     *
     * @param disassociateSkillFromUsersRequest
     * @return A Java Future containing the result of the DisassociateSkillFromUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DisassociateSkillFromUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromUsers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateSkillFromUsersResponse> disassociateSkillFromUsers(
            DisassociateSkillFromUsersRequest disassociateSkillFromUsersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateSkillFromUsersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateSkillFromUsersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateSkillFromUsersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateSkillFromUsersRequest, DisassociateSkillFromUsersResponse>()
                            .withOperationName("DisassociateSkillFromUsers")
                            .withMarshaller(new DisassociateSkillFromUsersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateSkillFromUsersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a skill group from a specified room. This disables all skills in the skill group on all devices in
     * the room.
     * </p>
     *
     * @param disassociateSkillGroupFromRoomRequest
     * @return A Java Future containing the result of the DisassociateSkillGroupFromRoom operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DisassociateSkillGroupFromRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillGroupFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateSkillGroupFromRoomResponse> disassociateSkillGroupFromRoom(
            DisassociateSkillGroupFromRoomRequest disassociateSkillGroupFromRoomRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateSkillGroupFromRoomResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateSkillGroupFromRoomResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateSkillGroupFromRoomResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateSkillGroupFromRoomRequest, DisassociateSkillGroupFromRoomResponse>()
                            .withOperationName("DisassociateSkillGroupFromRoom")
                            .withMarshaller(new DisassociateSkillGroupFromRoomRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateSkillGroupFromRoomRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Forgets smart home appliances associated to a room.
     * </p>
     *
     * @param forgetSmartHomeAppliancesRequest
     * @return A Java Future containing the result of the ForgetSmartHomeAppliances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ForgetSmartHomeAppliances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ForgetSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ForgetSmartHomeAppliancesResponse> forgetSmartHomeAppliances(
            ForgetSmartHomeAppliancesRequest forgetSmartHomeAppliancesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ForgetSmartHomeAppliancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ForgetSmartHomeAppliancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ForgetSmartHomeAppliancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ForgetSmartHomeAppliancesRequest, ForgetSmartHomeAppliancesResponse>()
                            .withOperationName("ForgetSmartHomeAppliances")
                            .withMarshaller(new ForgetSmartHomeAppliancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(forgetSmartHomeAppliancesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets address the book details by the address book ARN.
     * </p>
     *
     * @param getAddressBookRequest
     * @return A Java Future containing the result of the GetAddressBook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAddressBookResponse> getAddressBook(GetAddressBookRequest getAddressBookRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAddressBookResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAddressBookResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAddressBookResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAddressBookRequest, GetAddressBookResponse>()
                            .withOperationName("GetAddressBook")
                            .withMarshaller(new GetAddressBookRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getAddressBookRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the existing conference preferences.
     * </p>
     *
     * @param getConferencePreferenceRequest
     * @return A Java Future containing the result of the GetConferencePreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetConferencePreference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferencePreference"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConferencePreferenceResponse> getConferencePreference(
            GetConferencePreferenceRequest getConferencePreferenceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConferencePreferenceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConferencePreferenceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConferencePreferenceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConferencePreferenceRequest, GetConferencePreferenceResponse>()
                            .withOperationName("GetConferencePreference")
                            .withMarshaller(new GetConferencePreferenceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getConferencePreferenceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets details about a specific conference provider.
     * </p>
     *
     * @param getConferenceProviderRequest
     * @return A Java Future containing the result of the GetConferenceProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConferenceProviderResponse> getConferenceProvider(
            GetConferenceProviderRequest getConferenceProviderRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConferenceProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConferenceProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConferenceProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConferenceProviderRequest, GetConferenceProviderResponse>()
                            .withOperationName("GetConferenceProvider")
                            .withMarshaller(new GetConferenceProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getConferenceProviderRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the contact details by the contact ARN.
     * </p>
     *
     * @param getContactRequest
     * @return A Java Future containing the result of the GetContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetContact" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContactResponse> getContact(GetContactRequest getContactRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetContactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContactRequest, GetContactResponse>().withOperationName("GetContact")
                            .withMarshaller(new GetContactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getContactRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the details of a device by device ARN.
     * </p>
     *
     * @param getDeviceRequest
     * @return A Java Future containing the result of the GetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeviceResponse> getDevice(GetDeviceRequest getDeviceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeviceRequest, GetDeviceResponse>().withOperationName("GetDevice")
                            .withMarshaller(new GetDeviceRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getDeviceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the details of a gateway.
     * </p>
     *
     * @param getGatewayRequest
     * @return A Java Future containing the result of the GetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGateway" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetGatewayResponse> getGateway(GetGatewayRequest getGatewayRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGatewayRequest, GetGatewayResponse>().withOperationName("GetGateway")
                            .withMarshaller(new GetGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the details of a gateway group.
     * </p>
     *
     * @param getGatewayGroupRequest
     * @return A Java Future containing the result of the GetGatewayGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetGatewayGroupResponse> getGatewayGroup(GetGatewayGroupRequest getGatewayGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGatewayGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetGatewayGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGatewayGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGatewayGroupRequest, GetGatewayGroupResponse>()
                            .withOperationName("GetGatewayGroup")
                            .withMarshaller(new GetGatewayGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getGatewayGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the configured values for the user enrollment invitation email template.
     * </p>
     *
     * @param getInvitationConfigurationRequest
     * @return A Java Future containing the result of the GetInvitationConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetInvitationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetInvitationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInvitationConfigurationResponse> getInvitationConfiguration(
            GetInvitationConfigurationRequest getInvitationConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInvitationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInvitationConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInvitationConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInvitationConfigurationRequest, GetInvitationConfigurationResponse>()
                            .withOperationName("GetInvitationConfiguration")
                            .withMarshaller(new GetInvitationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getInvitationConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the network profile details by the network profile ARN.
     * </p>
     *
     * @param getNetworkProfileRequest
     * @return A Java Future containing the result of the GetNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>InvalidSecretsManagerResourceException A password in SecretsManager is in an invalid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetNetworkProfileResponse> getNetworkProfile(GetNetworkProfileRequest getNetworkProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetNetworkProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetNetworkProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetNetworkProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetNetworkProfileRequest, GetNetworkProfileResponse>()
                            .withOperationName("GetNetworkProfile")
                            .withMarshaller(new GetNetworkProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getNetworkProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the details of a room profile by profile ARN.
     * </p>
     *
     * @param getProfileRequest
     * @return A Java Future containing the result of the GetProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetProfileResponse> getProfile(GetProfileRequest getProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetProfileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetProfileRequest, GetProfileResponse>().withOperationName("GetProfile")
                            .withMarshaller(new GetProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets room details by room ARN.
     * </p>
     *
     * @param getRoomRequest
     * @return A Java Future containing the result of the GetRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoom" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRoomResponse> getRoom(GetRoomRequest getRoomRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRoomResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetRoomResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRoomResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRoomRequest, GetRoomResponse>().withOperationName("GetRoom")
                            .withMarshaller(new GetRoomRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getRoomRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets room skill parameter details by room, skill, and parameter key ARN.
     * </p>
     *
     * @param getRoomSkillParameterRequest
     * @return A Java Future containing the result of the GetRoomSkillParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRoomSkillParameterResponse> getRoomSkillParameter(
            GetRoomSkillParameterRequest getRoomSkillParameterRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRoomSkillParameterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRoomSkillParameterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRoomSkillParameterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRoomSkillParameterRequest, GetRoomSkillParameterResponse>()
                            .withOperationName("GetRoomSkillParameter")
                            .withMarshaller(new GetRoomSkillParameterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getRoomSkillParameterRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets skill group details by skill group ARN.
     * </p>
     *
     * @param getSkillGroupRequest
     * @return A Java Future containing the result of the GetSkillGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetSkillGroup" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSkillGroupResponse> getSkillGroup(GetSkillGroupRequest getSkillGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSkillGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSkillGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSkillGroupRequest, GetSkillGroupResponse>()
                            .withOperationName("GetSkillGroup")
                            .withMarshaller(new GetSkillGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getSkillGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the details of the schedules that a user configured.
     * </p>
     *
     * @param listBusinessReportSchedulesRequest
     * @return A Java Future containing the result of the ListBusinessReportSchedules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListBusinessReportSchedules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBusinessReportSchedulesResponse> listBusinessReportSchedules(
            ListBusinessReportSchedulesRequest listBusinessReportSchedulesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBusinessReportSchedulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBusinessReportSchedulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBusinessReportSchedulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBusinessReportSchedulesRequest, ListBusinessReportSchedulesResponse>()
                            .withOperationName("ListBusinessReportSchedules")
                            .withMarshaller(new ListBusinessReportSchedulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listBusinessReportSchedulesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the details of the schedules that a user configured.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBusinessReportSchedules(software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesPublisher publisher = client.listBusinessReportSchedulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesPublisher publisher = client.listBusinessReportSchedulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBusinessReportSchedules(software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBusinessReportSchedulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListBusinessReportSchedules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    public ListBusinessReportSchedulesPublisher listBusinessReportSchedulesPaginator(
            ListBusinessReportSchedulesRequest listBusinessReportSchedulesRequest) {
        return new ListBusinessReportSchedulesPublisher(this, applyPaginatorUserAgent(listBusinessReportSchedulesRequest));
    }

    /**
     * <p>
     * Lists conference providers under a specific AWS account.
     * </p>
     *
     * @param listConferenceProvidersRequest
     * @return A Java Future containing the result of the ListConferenceProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListConferenceProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListConferenceProviders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConferenceProvidersResponse> listConferenceProviders(
            ListConferenceProvidersRequest listConferenceProvidersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListConferenceProvidersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListConferenceProvidersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListConferenceProvidersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListConferenceProvidersRequest, ListConferenceProvidersResponse>()
                            .withOperationName("ListConferenceProviders")
                            .withMarshaller(new ListConferenceProvidersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listConferenceProvidersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists conference providers under a specific AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConferenceProviders(software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersPublisher publisher = client.listConferenceProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersPublisher publisher = client.listConferenceProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConferenceProviders(software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConferenceProvidersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListConferenceProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListConferenceProviders"
     *      target="_top">AWS API Documentation</a>
     */
    public ListConferenceProvidersPublisher listConferenceProvidersPaginator(
            ListConferenceProvidersRequest listConferenceProvidersRequest) {
        return new ListConferenceProvidersPublisher(this, applyPaginatorUserAgent(listConferenceProvidersRequest));
    }

    /**
     * <p>
     * Lists the device event history, including device connection status, for up to 30 days.
     * </p>
     *
     * @param listDeviceEventsRequest
     * @return A Java Future containing the result of the ListDeviceEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListDeviceEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListDeviceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeviceEventsResponse> listDeviceEvents(ListDeviceEventsRequest listDeviceEventsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeviceEventsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeviceEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDeviceEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDeviceEventsRequest, ListDeviceEventsResponse>()
                            .withOperationName("ListDeviceEvents")
                            .withMarshaller(new ListDeviceEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listDeviceEventsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the device event history, including device connection status, for up to 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceEvents(software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsPublisher publisher = client.listDeviceEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsPublisher publisher = client.listDeviceEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceEvents(software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListDeviceEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListDeviceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    public ListDeviceEventsPublisher listDeviceEventsPaginator(ListDeviceEventsRequest listDeviceEventsRequest) {
        return new ListDeviceEventsPublisher(this, applyPaginatorUserAgent(listDeviceEventsRequest));
    }

    /**
     * <p>
     * Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.
     * </p>
     *
     * @param listGatewayGroupsRequest
     * @return A Java Future containing the result of the ListGatewayGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListGatewayGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGatewayGroupsResponse> listGatewayGroups(ListGatewayGroupsRequest listGatewayGroupsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGatewayGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGatewayGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGatewayGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGatewayGroupsRequest, ListGatewayGroupsResponse>()
                            .withOperationName("ListGatewayGroups")
                            .withMarshaller(new ListGatewayGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listGatewayGroupsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGatewayGroups(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsPublisher publisher = client.listGatewayGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsPublisher publisher = client.listGatewayGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayGroups(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGatewayGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListGatewayGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroups"
     *      target="_top">AWS API Documentation</a>
     */
    public ListGatewayGroupsPublisher listGatewayGroupsPaginator(ListGatewayGroupsRequest listGatewayGroupsRequest) {
        return new ListGatewayGroupsPublisher(this, applyPaginatorUserAgent(listGatewayGroupsRequest));
    }

    /**
     * <p>
     * Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional
     * gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that
     * gateway group ARN.
     * </p>
     *
     * @param listGatewaysRequest
     * @return A Java Future containing the result of the ListGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGatewaysResponse> listGateways(ListGatewaysRequest listGatewaysRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGatewaysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListGatewaysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGatewaysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGatewaysRequest, ListGatewaysResponse>()
                            .withOperationName("ListGateways").withMarshaller(new ListGatewaysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listGatewaysRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional
     * gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that
     * gateway group ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest)} operation.</b>
     * </p>
     *
     * @param listGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    public ListGatewaysPublisher listGatewaysPaginator(ListGatewaysRequest listGatewaysRequest) {
        return new ListGatewaysPublisher(this, applyPaginatorUserAgent(listGatewaysRequest));
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     *
     * @param listSkillsRequest
     * @return A Java Future containing the result of the ListSkills operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkills
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSkillsResponse> listSkills(ListSkillsRequest listSkillsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSkillsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListSkillsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSkillsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSkillsRequest, ListSkillsResponse>().withOperationName("ListSkills")
                            .withMarshaller(new ListSkillsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listSkillsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsPublisher publisher = client.listSkillsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsPublisher publisher = client.listSkillsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation.</b>
     * </p>
     *
     * @param listSkillsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkills
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    public ListSkillsPublisher listSkillsPaginator(ListSkillsRequest listSkillsRequest) {
        return new ListSkillsPublisher(this, applyPaginatorUserAgent(listSkillsRequest));
    }

    /**
     * <p>
     * Lists all categories in the Alexa skill store.
     * </p>
     *
     * @param listSkillsStoreCategoriesRequest
     * @return A Java Future containing the result of the ListSkillsStoreCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkillsStoreCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreCategories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSkillsStoreCategoriesResponse> listSkillsStoreCategories(
            ListSkillsStoreCategoriesRequest listSkillsStoreCategoriesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSkillsStoreCategoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSkillsStoreCategoriesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSkillsStoreCategoriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSkillsStoreCategoriesRequest, ListSkillsStoreCategoriesResponse>()
                            .withOperationName("ListSkillsStoreCategories")
                            .withMarshaller(new ListSkillsStoreCategoriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listSkillsStoreCategoriesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all categories in the Alexa skill store.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkillsStoreCategories(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesPublisher publisher = client.listSkillsStoreCategoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesPublisher publisher = client.listSkillsStoreCategoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkillsStoreCategories(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSkillsStoreCategoriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkillsStoreCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreCategories"
     *      target="_top">AWS API Documentation</a>
     */
    public ListSkillsStoreCategoriesPublisher listSkillsStoreCategoriesPaginator(
            ListSkillsStoreCategoriesRequest listSkillsStoreCategoriesRequest) {
        return new ListSkillsStoreCategoriesPublisher(this, applyPaginatorUserAgent(listSkillsStoreCategoriesRequest));
    }

    /**
     * <p>
     * Lists all skills in the Alexa skill store by category.
     * </p>
     *
     * @param listSkillsStoreSkillsByCategoryRequest
     * @return A Java Future containing the result of the ListSkillsStoreSkillsByCategory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkillsStoreSkillsByCategory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSkillsStoreSkillsByCategoryResponse> listSkillsStoreSkillsByCategory(
            ListSkillsStoreSkillsByCategoryRequest listSkillsStoreSkillsByCategoryRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSkillsStoreSkillsByCategoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSkillsStoreSkillsByCategoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSkillsStoreSkillsByCategoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSkillsStoreSkillsByCategoryRequest, ListSkillsStoreSkillsByCategoryResponse>()
                            .withOperationName("ListSkillsStoreSkillsByCategory")
                            .withMarshaller(new ListSkillsStoreSkillsByCategoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listSkillsStoreSkillsByCategoryRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all skills in the Alexa skill store by category.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkillsStoreSkillsByCategory(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryPublisher publisher = client.listSkillsStoreSkillsByCategoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryPublisher publisher = client.listSkillsStoreSkillsByCategoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkillsStoreSkillsByCategory(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSkillsStoreSkillsByCategoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkillsStoreSkillsByCategory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategory"
     *      target="_top">AWS API Documentation</a>
     */
    public ListSkillsStoreSkillsByCategoryPublisher listSkillsStoreSkillsByCategoryPaginator(
            ListSkillsStoreSkillsByCategoryRequest listSkillsStoreSkillsByCategoryRequest) {
        return new ListSkillsStoreSkillsByCategoryPublisher(this, applyPaginatorUserAgent(listSkillsStoreSkillsByCategoryRequest));
    }

    /**
     * <p>
     * Lists all of the smart home appliances associated with a room.
     * </p>
     *
     * @param listSmartHomeAppliancesRequest
     * @return A Java Future containing the result of the ListSmartHomeAppliances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSmartHomeAppliances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSmartHomeAppliancesResponse> listSmartHomeAppliances(
            ListSmartHomeAppliancesRequest listSmartHomeAppliancesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSmartHomeAppliancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSmartHomeAppliancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSmartHomeAppliancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSmartHomeAppliancesRequest, ListSmartHomeAppliancesResponse>()
                            .withOperationName("ListSmartHomeAppliances")
                            .withMarshaller(new ListSmartHomeAppliancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listSmartHomeAppliancesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all of the smart home appliances associated with a room.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSmartHomeAppliances(software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesPublisher publisher = client.listSmartHomeAppliancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesPublisher publisher = client.listSmartHomeAppliancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSmartHomeAppliances(software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSmartHomeAppliancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSmartHomeAppliances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    public ListSmartHomeAppliancesPublisher listSmartHomeAppliancesPaginator(
            ListSmartHomeAppliancesRequest listSmartHomeAppliancesRequest) {
        return new ListSmartHomeAppliancesPublisher(this, applyPaginatorUserAgent(listSmartHomeAppliancesRequest));
    }

    /**
     * <p>
     * Lists all tags for the specified resource.
     * </p>
     *
     * @param listTagsRequest
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsRequest, ListTagsResponse>().withOperationName("ListTags")
                            .withMarshaller(new ListTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listTagsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)} operation.</b>
     * </p>
     *
     * @param listTagsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    public ListTagsPublisher listTagsPaginator(ListTagsRequest listTagsRequest) {
        return new ListTagsPublisher(this, applyPaginatorUserAgent(listTagsRequest));
    }

    /**
     * <p>
     * Sets the conference preferences on a specific conference provider at the account level.
     * </p>
     *
     * @param putConferencePreferenceRequest
     * @return A Java Future containing the result of the PutConferencePreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.PutConferencePreference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutConferencePreference"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutConferencePreferenceResponse> putConferencePreference(
            PutConferencePreferenceRequest putConferencePreferenceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutConferencePreferenceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutConferencePreferenceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutConferencePreferenceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutConferencePreferenceRequest, PutConferencePreferenceResponse>()
                            .withOperationName("PutConferencePreference")
                            .withMarshaller(new PutConferencePreferenceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putConferencePreferenceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Configures the email template for the user enrollment invitation with the specified attributes.
     * </p>
     *
     * @param putInvitationConfigurationRequest
     * @return A Java Future containing the result of the PutInvitationConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.PutInvitationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutInvitationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutInvitationConfigurationResponse> putInvitationConfiguration(
            PutInvitationConfigurationRequest putInvitationConfigurationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutInvitationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutInvitationConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutInvitationConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutInvitationConfigurationRequest, PutInvitationConfigurationResponse>()
                            .withOperationName("PutInvitationConfiguration")
                            .withMarshaller(new PutInvitationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putInvitationConfigurationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates room skill parameter details by room, skill, and parameter key ID. Not all skills have a room skill
     * parameter.
     * </p>
     *
     * @param putRoomSkillParameterRequest
     * @return A Java Future containing the result of the PutRoomSkillParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.PutRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutRoomSkillParameterResponse> putRoomSkillParameter(
            PutRoomSkillParameterRequest putRoomSkillParameterRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutRoomSkillParameterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutRoomSkillParameterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutRoomSkillParameterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutRoomSkillParameterRequest, PutRoomSkillParameterResponse>()
                            .withOperationName("PutRoomSkillParameter")
                            .withMarshaller(new PutRoomSkillParameterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putRoomSkillParameterRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Links a user's account to a third-party skill provider. If this API operation is called by an assumed IAM role,
     * the skill being linked must be a private skill. Also, the skill must be owned by the AWS account that assumed the
     * IAM role.
     * </p>
     *
     * @param putSkillAuthorizationRequest
     * @return A Java Future containing the result of the PutSkillAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The caller has no permissions to operate on the resource involved in the API
     *         call.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.PutSkillAuthorization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutSkillAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutSkillAuthorizationResponse> putSkillAuthorization(
            PutSkillAuthorizationRequest putSkillAuthorizationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutSkillAuthorizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutSkillAuthorizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutSkillAuthorizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutSkillAuthorizationRequest, PutSkillAuthorizationResponse>()
                            .withOperationName("PutSkillAuthorization")
                            .withMarshaller(new PutSkillAuthorizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putSkillAuthorizationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers an Alexa-enabled device built by an Original Equipment Manufacturer (OEM) using Alexa Voice Service
     * (AVS).
     * </p>
     *
     * @param registerAvsDeviceRequest
     * @return A Java Future containing the result of the RegisterAVSDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>InvalidDeviceException The device is in an invalid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.RegisterAVSDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RegisterAVSDevice"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterAvsDeviceResponse> registerAVSDevice(RegisterAvsDeviceRequest registerAvsDeviceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterAvsDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterAvsDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterAvsDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterAvsDeviceRequest, RegisterAvsDeviceResponse>()
                            .withOperationName("RegisterAVSDevice")
                            .withMarshaller(new RegisterAvsDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(registerAvsDeviceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a skill from the organization under a user's AWS account. If the skill is a private skill, it moves
     * to an AcceptStatus of PENDING. Any private or public skill that is rejected can be added later by calling the
     * ApproveSkill API.
     * </p>
     *
     * @param rejectSkillRequest
     * @return A Java Future containing the result of the RejectSkill operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.RejectSkill
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RejectSkill" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RejectSkillResponse> rejectSkill(RejectSkillRequest rejectSkillRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RejectSkillResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    RejectSkillResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RejectSkillResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RejectSkillRequest, RejectSkillResponse>()
                            .withOperationName("RejectSkill").withMarshaller(new RejectSkillRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(rejectSkillRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Determines the details for the room from which a skill request was invoked. This operation is used by skill
     * developers.
     * </p>
     *
     * @param resolveRoomRequest
     * @return A Java Future containing the result of the ResolveRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ResolveRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ResolveRoom" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ResolveRoomResponse> resolveRoom(ResolveRoomRequest resolveRoomRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResolveRoomResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ResolveRoomResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResolveRoomResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResolveRoomRequest, ResolveRoomResponse>()
                            .withOperationName("ResolveRoom").withMarshaller(new ResolveRoomRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(resolveRoomRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Revokes an invitation and invalidates the enrollment URL.
     * </p>
     *
     * @param revokeInvitationRequest
     * @return A Java Future containing the result of the RevokeInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.RevokeInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RevokeInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RevokeInvitationResponse> revokeInvitation(RevokeInvitationRequest revokeInvitationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RevokeInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RevokeInvitationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RevokeInvitationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RevokeInvitationRequest, RevokeInvitationResponse>()
                            .withOperationName("RevokeInvitation")
                            .withMarshaller(new RevokeInvitationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(revokeInvitationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches address books and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchAddressBooksRequest
     * @return A Java Future containing the result of the SearchAddressBooks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchAddressBooks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchAddressBooksResponse> searchAddressBooks(SearchAddressBooksRequest searchAddressBooksRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchAddressBooksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchAddressBooksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchAddressBooksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchAddressBooksRequest, SearchAddressBooksResponse>()
                            .withOperationName("SearchAddressBooks")
                            .withMarshaller(new SearchAddressBooksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(searchAddressBooksRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches address books and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchAddressBooks(software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksPublisher publisher = client.searchAddressBooksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksPublisher publisher = client.searchAddressBooksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchAddressBooks(software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchAddressBooksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchAddressBooks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks"
     *      target="_top">AWS API Documentation</a>
     */
    public SearchAddressBooksPublisher searchAddressBooksPaginator(SearchAddressBooksRequest searchAddressBooksRequest) {
        return new SearchAddressBooksPublisher(this, applyPaginatorUserAgent(searchAddressBooksRequest));
    }

    /**
     * <p>
     * Searches contacts and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchContactsRequest
     * @return A Java Future containing the result of the SearchContacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchContacts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchContactsResponse> searchContacts(SearchContactsRequest searchContactsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchContactsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchContactsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchContactsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchContactsRequest, SearchContactsResponse>()
                            .withOperationName("SearchContacts")
                            .withMarshaller(new SearchContactsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(searchContactsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches contacts and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchContacts(software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsPublisher publisher = client.searchContactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsPublisher publisher = client.searchContactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchContacts(software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchContactsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchContacts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts"
     *      target="_top">AWS API Documentation</a>
     */
    public SearchContactsPublisher searchContactsPaginator(SearchContactsRequest searchContactsRequest) {
        return new SearchContactsPublisher(this, applyPaginatorUserAgent(searchContactsRequest));
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     *
     * @param searchDevicesRequest
     * @return A Java Future containing the result of the SearchDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchDevicesResponse> searchDevices(SearchDevicesRequest searchDevicesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchDevicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SearchDevicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchDevicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchDevicesRequest, SearchDevicesResponse>()
                            .withOperationName("SearchDevices")
                            .withMarshaller(new SearchDevicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(searchDevicesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesPublisher publisher = client.searchDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesPublisher publisher = client.searchDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices" target="_top">AWS
     *      API Documentation</a>
     */
    public SearchDevicesPublisher searchDevicesPaginator(SearchDevicesRequest searchDevicesRequest) {
        return new SearchDevicesPublisher(this, applyPaginatorUserAgent(searchDevicesRequest));
    }

    /**
     * <p>
     * Searches network profiles and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchNetworkProfilesRequest
     * @return A Java Future containing the result of the SearchNetworkProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchNetworkProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchNetworkProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchNetworkProfilesResponse> searchNetworkProfiles(
            SearchNetworkProfilesRequest searchNetworkProfilesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchNetworkProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchNetworkProfilesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchNetworkProfilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchNetworkProfilesRequest, SearchNetworkProfilesResponse>()
                            .withOperationName("SearchNetworkProfiles")
                            .withMarshaller(new SearchNetworkProfilesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(searchNetworkProfilesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches network profiles and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchNetworkProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchNetworkProfilesPublisher publisher = client.searchNetworkProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchNetworkProfilesPublisher publisher = client.searchNetworkProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchNetworkProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchNetworkProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchNetworkProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchNetworkProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    public SearchNetworkProfilesPublisher searchNetworkProfilesPaginator(SearchNetworkProfilesRequest searchNetworkProfilesRequest) {
        return new SearchNetworkProfilesPublisher(this, applyPaginatorUserAgent(searchNetworkProfilesRequest));
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     *
     * @param searchProfilesRequest
     * @return A Java Future containing the result of the SearchProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchProfilesResponse> searchProfiles(SearchProfilesRequest searchProfilesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchProfilesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchProfilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchProfilesRequest, SearchProfilesResponse>()
                            .withOperationName("SearchProfiles")
                            .withMarshaller(new SearchProfilesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(searchProfilesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesPublisher publisher = client.searchProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesPublisher publisher = client.searchProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    public SearchProfilesPublisher searchProfilesPaginator(SearchProfilesRequest searchProfilesRequest) {
        return new SearchProfilesPublisher(this, applyPaginatorUserAgent(searchProfilesRequest));
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchRoomsRequest
     * @return A Java Future containing the result of the SearchRooms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchRoomsResponse> searchRooms(SearchRoomsRequest searchRoomsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchRoomsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SearchRoomsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchRoomsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchRoomsRequest, SearchRoomsResponse>()
                            .withOperationName("SearchRooms").withMarshaller(new SearchRoomsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(searchRoomsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsPublisher publisher = client.searchRoomsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsPublisher publisher = client.searchRoomsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation.</b>
     * </p>
     *
     * @param searchRoomsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    public SearchRoomsPublisher searchRoomsPaginator(SearchRoomsRequest searchRoomsRequest) {
        return new SearchRoomsPublisher(this, applyPaginatorUserAgent(searchRoomsRequest));
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchSkillGroupsRequest
     * @return A Java Future containing the result of the SearchSkillGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchSkillGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchSkillGroupsResponse> searchSkillGroups(SearchSkillGroupsRequest searchSkillGroupsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchSkillGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchSkillGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchSkillGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchSkillGroupsRequest, SearchSkillGroupsResponse>()
                            .withOperationName("SearchSkillGroups")
                            .withMarshaller(new SearchSkillGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(searchSkillGroupsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsPublisher publisher = client.searchSkillGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsPublisher publisher = client.searchSkillGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchSkillGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchSkillGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    public SearchSkillGroupsPublisher searchSkillGroupsPaginator(SearchSkillGroupsRequest searchSkillGroupsRequest) {
        return new SearchSkillGroupsPublisher(this, applyPaginatorUserAgent(searchSkillGroupsRequest));
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchUsersRequest
     * @return A Java Future containing the result of the SearchUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchUsersResponse> searchUsers(SearchUsersRequest searchUsersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SearchUsersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchUsersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchUsersRequest, SearchUsersResponse>()
                            .withOperationName("SearchUsers").withMarshaller(new SearchUsersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(searchUsersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersPublisher publisher = client.searchUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersPublisher publisher = client.searchUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation.</b>
     * </p>
     *
     * @param searchUsersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    public SearchUsersPublisher searchUsersPaginator(SearchUsersRequest searchUsersRequest) {
        return new SearchUsersPublisher(this, applyPaginatorUserAgent(searchUsersRequest));
    }

    /**
     * <p>
     * Triggers an asynchronous flow to send text, SSML, or audio announcements to rooms that are identified by a search
     * or filter.
     * </p>
     *
     * @param sendAnnouncementRequest
     * @return A Java Future containing the result of the SendAnnouncement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SendAnnouncement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SendAnnouncementResponse> sendAnnouncement(SendAnnouncementRequest sendAnnouncementRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendAnnouncementResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SendAnnouncementResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendAnnouncementResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendAnnouncementRequest, SendAnnouncementResponse>()
                            .withOperationName("SendAnnouncement")
                            .withMarshaller(new SendAnnouncementRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(sendAnnouncementRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sends an enrollment invitation email with a URL to a user. The URL is valid for 72 hours or until you call this
     * operation again, whichever comes first.
     * </p>
     *
     * @param sendInvitationRequest
     * @return A Java Future containing the result of the SendInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>InvalidUserStatusException The attempt to update a user is invalid due to the user's current status.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SendInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SendInvitationResponse> sendInvitation(SendInvitationRequest sendInvitationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SendInvitationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendInvitationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendInvitationRequest, SendInvitationResponse>()
                            .withOperationName("SendInvitation")
                            .withMarshaller(new SendInvitationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(sendInvitationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Resets a device and its account to the known default settings. This clears all information and settings set by
     * previous users in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Bluetooth - This unpairs all bluetooth devices paired with your echo device.
     * </p>
     * </li>
     * <li>
     * <p>
     * Volume - This resets the echo device's volume to the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notifications - This clears all notifications from your echo device.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists - This clears all to-do items from your echo device.
     * </p>
     * </li>
     * <li>
     * <p>
     * Settings - This internally syncs the room's profile (if the device is assigned to a room), contacts, address
     * books, delegation access for account linking, and communications (if enabled on the room profile).
     * </p>
     * </li>
     * </ul>
     *
     * @param startDeviceSyncRequest
     * @return A Java Future containing the result of the StartDeviceSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.StartDeviceSync
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartDeviceSync"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartDeviceSyncResponse> startDeviceSync(StartDeviceSyncRequest startDeviceSyncRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartDeviceSyncResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartDeviceSyncResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartDeviceSyncResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartDeviceSyncRequest, StartDeviceSyncResponse>()
                            .withOperationName("StartDeviceSync")
                            .withMarshaller(new StartDeviceSyncRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(startDeviceSyncRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initiates the discovery of any smart home appliances associated with the room.
     * </p>
     *
     * @param startSmartHomeApplianceDiscoveryRequest
     * @return A Java Future containing the result of the StartSmartHomeApplianceDiscovery operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.StartSmartHomeApplianceDiscovery
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartSmartHomeApplianceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartSmartHomeApplianceDiscoveryResponse> startSmartHomeApplianceDiscovery(
            StartSmartHomeApplianceDiscoveryRequest startSmartHomeApplianceDiscoveryRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartSmartHomeApplianceDiscoveryResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StartSmartHomeApplianceDiscoveryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartSmartHomeApplianceDiscoveryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartSmartHomeApplianceDiscoveryRequest, StartSmartHomeApplianceDiscoveryResponse>()
                            .withOperationName("StartSmartHomeApplianceDiscovery")
                            .withMarshaller(new StartSmartHomeApplianceDiscoveryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(startSmartHomeApplianceDiscoveryRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(tagResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(untagResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates address book details by the address book ARN.
     * </p>
     *
     * @param updateAddressBookRequest
     * @return A Java Future containing the result of the UpdateAddressBook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAddressBookResponse> updateAddressBook(UpdateAddressBookRequest updateAddressBookRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAddressBookResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAddressBookResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAddressBookResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAddressBookRequest, UpdateAddressBookResponse>()
                            .withOperationName("UpdateAddressBook")
                            .withMarshaller(new UpdateAddressBookRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateAddressBookRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration of the report delivery schedule with the specified schedule ARN.
     * </p>
     *
     * @param updateBusinessReportScheduleRequest
     * @return A Java Future containing the result of the UpdateBusinessReportSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateBusinessReportSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBusinessReportScheduleResponse> updateBusinessReportSchedule(
            UpdateBusinessReportScheduleRequest updateBusinessReportScheduleRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBusinessReportScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBusinessReportScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBusinessReportScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBusinessReportScheduleRequest, UpdateBusinessReportScheduleResponse>()
                            .withOperationName("UpdateBusinessReportSchedule")
                            .withMarshaller(new UpdateBusinessReportScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateBusinessReportScheduleRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing conference provider's settings.
     * </p>
     *
     * @param updateConferenceProviderRequest
     * @return A Java Future containing the result of the UpdateConferenceProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConferenceProviderResponse> updateConferenceProvider(
            UpdateConferenceProviderRequest updateConferenceProviderRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConferenceProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateConferenceProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateConferenceProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateConferenceProviderRequest, UpdateConferenceProviderResponse>()
                            .withOperationName("UpdateConferenceProvider")
                            .withMarshaller(new UpdateConferenceProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateConferenceProviderRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the contact details by the contact ARN.
     * </p>
     *
     * @param updateContactRequest
     * @return A Java Future containing the result of the UpdateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateContact" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateContactResponse> updateContact(UpdateContactRequest updateContactRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateContactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateContactResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateContactResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateContactRequest, UpdateContactResponse>()
                            .withOperationName("UpdateContact")
                            .withMarshaller(new UpdateContactRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateContactRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the device name by device ARN.
     * </p>
     *
     * @param updateDeviceRequest
     * @return A Java Future containing the result of the UpdateDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDeviceResponse> updateDevice(UpdateDeviceRequest updateDeviceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDeviceRequest, UpdateDeviceResponse>()
                            .withOperationName("UpdateDevice").withMarshaller(new UpdateDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateDeviceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the details of a gateway. If any optional field is not provided, the existing corresponding value is left
     * unmodified.
     * </p>
     *
     * @param updateGatewayRequest
     * @return A Java Future containing the result of the UpdateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGateway" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGatewayResponse> updateGateway(UpdateGatewayRequest updateGatewayRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGatewayResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateGatewayResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateGatewayResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGatewayRequest, UpdateGatewayResponse>()
                            .withOperationName("UpdateGateway")
                            .withMarshaller(new UpdateGatewayRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateGatewayRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the details of a gateway group. If any optional field is not provided, the existing corresponding value
     * is left unmodified.
     * </p>
     *
     * @param updateGatewayGroupRequest
     * @return A Java Future containing the result of the UpdateGatewayGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGatewayGroupResponse> updateGatewayGroup(UpdateGatewayGroupRequest updateGatewayGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGatewayGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateGatewayGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateGatewayGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGatewayGroupRequest, UpdateGatewayGroupResponse>()
                            .withOperationName("UpdateGatewayGroup")
                            .withMarshaller(new UpdateGatewayGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateGatewayGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a network profile by the network profile ARN.
     * </p>
     *
     * @param updateNetworkProfileRequest
     * @return A Java Future containing the result of the UpdateNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>InvalidCertificateAuthorityException The Certificate Authority can't issue or revoke a certificate.</li>
     *         <li>InvalidSecretsManagerResourceException A password in SecretsManager is in an invalid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateNetworkProfileResponse> updateNetworkProfile(
            UpdateNetworkProfileRequest updateNetworkProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateNetworkProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateNetworkProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateNetworkProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateNetworkProfileRequest, UpdateNetworkProfileResponse>()
                            .withOperationName("UpdateNetworkProfile")
                            .withMarshaller(new UpdateNetworkProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateNetworkProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing room profile by room profile ARN.
     * </p>
     *
     * @param updateProfileRequest
     * @return A Java Future containing the result of the UpdateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateProfileResponse> updateProfile(UpdateProfileRequest updateProfileRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateProfileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateProfileResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateProfileRequest, UpdateProfileResponse>()
                            .withOperationName("UpdateProfile")
                            .withMarshaller(new UpdateProfileRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateProfileRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates room details by room ARN.
     * </p>
     *
     * @param updateRoomRequest
     * @return A Java Future containing the result of the UpdateRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRoomResponse> updateRoom(UpdateRoomRequest updateRoomRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRoomResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateRoomResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRoomResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRoomRequest, UpdateRoomResponse>().withOperationName("UpdateRoom")
                            .withMarshaller(new UpdateRoomRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateRoomRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates skill group details by skill group ARN.
     * </p>
     *
     * @param updateSkillGroupRequest
     * @return A Java Future containing the result of the UpdateSkillGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSkillGroupResponse> updateSkillGroup(UpdateSkillGroupRequest updateSkillGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSkillGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSkillGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSkillGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSkillGroupRequest, UpdateSkillGroupResponse>()
                            .withOperationName("UpdateSkillGroup")
                            .withMarshaller(new UpdateSkillGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateSkillGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(AlexaForBusinessException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidServiceLinkedRoleStateException")
                                .exceptionBuilderSupplier(InvalidServiceLinkedRoleStateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SkillNotLinkedException")
                                .exceptionBuilderSupplier(SkillNotLinkedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAssociatedException")
                                .exceptionBuilderSupplier(ResourceAssociatedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NameInUseException")
                                .exceptionBuilderSupplier(NameInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AlreadyExistsException")
                                .exceptionBuilderSupplier(AlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSecretsManagerResourceException")
                                .exceptionBuilderSupplier(InvalidSecretsManagerResourceException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidUserStatusException")
                                .exceptionBuilderSupplier(InvalidUserStatusException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCertificateAuthorityException")
                                .exceptionBuilderSupplier(InvalidCertificateAuthorityException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeviceException")
                                .exceptionBuilderSupplier(InvalidDeviceException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeviceNotRegisteredException")
                                .exceptionBuilderSupplier(DeviceNotRegisteredException::builder).build());
    }

    private <T extends AlexaForBusinessRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
