/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusDetailCode;
import software.amazon.awssdk.services.alexaforbusiness.model.Feature;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceStatusDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceStatusDetail> {
    private static final SdkField<String> FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceStatusDetail.getter(DeviceStatusDetail::featureAsString)).setter(DeviceStatusDetail.setter(Builder::feature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feature").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceStatusDetail.getter(DeviceStatusDetail::codeAsString)).setter(DeviceStatusDetail.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_FIELD, CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String feature;
    private final String code;

    private DeviceStatusDetail(BuilderImpl builder) {
        this.feature = builder.feature;
        this.code = builder.code;
    }

    public Feature feature() {
        return Feature.fromValue(this.feature);
    }

    public String featureAsString() {
        return this.feature;
    }

    public DeviceStatusDetailCode code() {
        return DeviceStatusDetailCode.fromValue(this.code);
    }

    public String codeAsString() {
        return this.code;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceStatusDetail)) {
            return false;
        }
        DeviceStatusDetail other = (DeviceStatusDetail)obj;
        return Objects.equals(this.featureAsString(), other.featureAsString()) && Objects.equals(this.codeAsString(), other.codeAsString());
    }

    public String toString() {
        return ToString.builder((String)"DeviceStatusDetail").add("Feature", (Object)this.featureAsString()).add("Code", (Object)this.codeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Feature": {
                return Optional.ofNullable(clazz.cast(this.featureAsString()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.codeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceStatusDetail, T> g) {
        return obj -> g.apply((DeviceStatusDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String feature;
        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceStatusDetail model) {
            this.feature(model.feature);
            this.code(model.code);
        }

        public final String getFeatureAsString() {
            return this.feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(Feature feature) {
            this.feature(feature.toString());
            return this;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        public final String getCodeAsString() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(DeviceStatusDetailCode code) {
            this.code(code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public DeviceStatusDetail build() {
            return new DeviceStatusDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceStatusDetail> {
        public Builder feature(String var1);

        public Builder feature(Feature var1);

        public Builder code(String var1);

        public Builder code(DeviceStatusDetailCode var1);
    }
}

