/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceData;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceDataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchDevicesResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, SearchDevicesResponse> {
    private static final SdkField<List<DeviceData>> DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SearchDevicesResponse.getter(SearchDevicesResponse::devices)).setter(SearchDevicesResponse.setter(Builder::devices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Devices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchDevicesResponse.getter(SearchDevicesResponse::nextToken)).setter(SearchDevicesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SearchDevicesResponse.getter(SearchDevicesResponse::totalCount)).setter(SearchDevicesResponse.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICES_FIELD, NEXT_TOKEN_FIELD, TOTAL_COUNT_FIELD));
    private final List<DeviceData> devices;
    private final String nextToken;
    private final Integer totalCount;

    private SearchDevicesResponse(BuilderImpl builder) {
        super(builder);
        this.devices = builder.devices;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    public List<DeviceData> devices() {
        return this.devices;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.devices());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchDevicesResponse)) {
            return false;
        }
        SearchDevicesResponse other = (SearchDevicesResponse)((Object)obj);
        return Objects.equals(this.devices(), other.devices()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public String toString() {
        return ToString.builder((String)"SearchDevicesResponse").add("Devices", this.devices()).add("NextToken", (Object)this.nextToken()).add("TotalCount", (Object)this.totalCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Devices": {
                return Optional.ofNullable(clazz.cast(this.devices()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchDevicesResponse, T> g) {
        return obj -> g.apply((SearchDevicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<DeviceData> devices = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchDevicesResponse model) {
            super(model);
            this.devices(model.devices);
            this.nextToken(model.nextToken);
            this.totalCount(model.totalCount);
        }

        public final Collection<DeviceData.Builder> getDevices() {
            return this.devices != null ? (Collection)this.devices.stream().map(DeviceData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devices(Collection<DeviceData> devices) {
            this.devices = DeviceDataListCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(DeviceData ... devices) {
            this.devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Consumer<DeviceData.Builder> ... devices) {
            this.devices(Stream.of(devices).map(c -> (DeviceData)((DeviceData.Builder)DeviceData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDevices(Collection<DeviceData.BuilderImpl> devices) {
            this.devices = DeviceDataListCopier.copyFromBuilder(devices);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public SearchDevicesResponse build() {
            return new SearchDevicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchDevicesResponse> {
        public Builder devices(Collection<DeviceData> var1);

        public Builder devices(DeviceData ... var1);

        public Builder devices(Consumer<DeviceData.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder totalCount(Integer var1);
    }
}

