/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatus;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceStatusInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceData> {
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceData.getter(DeviceData::deviceArn)).setter(DeviceData.setter(Builder::deviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceArn").build()}).build();
    private static final SdkField<String> DEVICE_SERIAL_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceData.getter(DeviceData::deviceSerialNumber)).setter(DeviceData.setter(Builder::deviceSerialNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSerialNumber").build()}).build();
    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceData.getter(DeviceData::deviceType)).setter(DeviceData.setter(Builder::deviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceType").build()}).build();
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceData.getter(DeviceData::deviceName)).setter(DeviceData.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()}).build();
    private static final SdkField<String> SOFTWARE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceData.getter(DeviceData::softwareVersion)).setter(DeviceData.setter(Builder::softwareVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareVersion").build()}).build();
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceData.getter(DeviceData::macAddress)).setter(DeviceData.setter(Builder::macAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress").build()}).build();
    private static final SdkField<String> DEVICE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceData.getter(DeviceData::deviceStatusAsString)).setter(DeviceData.setter(Builder::deviceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceStatus").build()}).build();
    private static final SdkField<String> NETWORK_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceData.getter(DeviceData::networkProfileArn)).setter(DeviceData.setter(Builder::networkProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfileArn").build()}).build();
    private static final SdkField<String> NETWORK_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceData.getter(DeviceData::networkProfileName)).setter(DeviceData.setter(Builder::networkProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfileName").build()}).build();
    private static final SdkField<String> ROOM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceData.getter(DeviceData::roomArn)).setter(DeviceData.setter(Builder::roomArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomArn").build()}).build();
    private static final SdkField<String> ROOM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceData.getter(DeviceData::roomName)).setter(DeviceData.setter(Builder::roomName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomName").build()}).build();
    private static final SdkField<DeviceStatusInfo> DEVICE_STATUS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeviceData.getter(DeviceData::deviceStatusInfo)).setter(DeviceData.setter(Builder::deviceStatusInfo)).constructor(DeviceStatusInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceStatusInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ARN_FIELD, DEVICE_SERIAL_NUMBER_FIELD, DEVICE_TYPE_FIELD, DEVICE_NAME_FIELD, SOFTWARE_VERSION_FIELD, MAC_ADDRESS_FIELD, DEVICE_STATUS_FIELD, NETWORK_PROFILE_ARN_FIELD, NETWORK_PROFILE_NAME_FIELD, ROOM_ARN_FIELD, ROOM_NAME_FIELD, DEVICE_STATUS_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceArn;
    private final String deviceSerialNumber;
    private final String deviceType;
    private final String deviceName;
    private final String softwareVersion;
    private final String macAddress;
    private final String deviceStatus;
    private final String networkProfileArn;
    private final String networkProfileName;
    private final String roomArn;
    private final String roomName;
    private final DeviceStatusInfo deviceStatusInfo;

    private DeviceData(BuilderImpl builder) {
        this.deviceArn = builder.deviceArn;
        this.deviceSerialNumber = builder.deviceSerialNumber;
        this.deviceType = builder.deviceType;
        this.deviceName = builder.deviceName;
        this.softwareVersion = builder.softwareVersion;
        this.macAddress = builder.macAddress;
        this.deviceStatus = builder.deviceStatus;
        this.networkProfileArn = builder.networkProfileArn;
        this.networkProfileName = builder.networkProfileName;
        this.roomArn = builder.roomArn;
        this.roomName = builder.roomName;
        this.deviceStatusInfo = builder.deviceStatusInfo;
    }

    public String deviceArn() {
        return this.deviceArn;
    }

    public String deviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    public String deviceType() {
        return this.deviceType;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public String softwareVersion() {
        return this.softwareVersion;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public DeviceStatus deviceStatus() {
        return DeviceStatus.fromValue(this.deviceStatus);
    }

    public String deviceStatusAsString() {
        return this.deviceStatus;
    }

    public String networkProfileArn() {
        return this.networkProfileArn;
    }

    public String networkProfileName() {
        return this.networkProfileName;
    }

    public String roomArn() {
        return this.roomArn;
    }

    public String roomName() {
        return this.roomName;
    }

    public DeviceStatusInfo deviceStatusInfo() {
        return this.deviceStatusInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceSerialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roomName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceStatusInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceData)) {
            return false;
        }
        DeviceData other = (DeviceData)obj;
        return Objects.equals(this.deviceArn(), other.deviceArn()) && Objects.equals(this.deviceSerialNumber(), other.deviceSerialNumber()) && Objects.equals(this.deviceType(), other.deviceType()) && Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.softwareVersion(), other.softwareVersion()) && Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.deviceStatusAsString(), other.deviceStatusAsString()) && Objects.equals(this.networkProfileArn(), other.networkProfileArn()) && Objects.equals(this.networkProfileName(), other.networkProfileName()) && Objects.equals(this.roomArn(), other.roomArn()) && Objects.equals(this.roomName(), other.roomName()) && Objects.equals(this.deviceStatusInfo(), other.deviceStatusInfo());
    }

    public String toString() {
        return ToString.builder((String)"DeviceData").add("DeviceArn", (Object)this.deviceArn()).add("DeviceSerialNumber", (Object)this.deviceSerialNumber()).add("DeviceType", (Object)this.deviceType()).add("DeviceName", (Object)this.deviceName()).add("SoftwareVersion", (Object)this.softwareVersion()).add("MacAddress", (Object)this.macAddress()).add("DeviceStatus", (Object)this.deviceStatusAsString()).add("NetworkProfileArn", (Object)this.networkProfileArn()).add("NetworkProfileName", (Object)this.networkProfileName()).add("RoomArn", (Object)this.roomArn()).add("RoomName", (Object)this.roomName()).add("DeviceStatusInfo", (Object)this.deviceStatusInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceArn": {
                return Optional.ofNullable(clazz.cast(this.deviceArn()));
            }
            case "DeviceSerialNumber": {
                return Optional.ofNullable(clazz.cast(this.deviceSerialNumber()));
            }
            case "DeviceType": {
                return Optional.ofNullable(clazz.cast(this.deviceType()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "SoftwareVersion": {
                return Optional.ofNullable(clazz.cast(this.softwareVersion()));
            }
            case "MacAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "DeviceStatus": {
                return Optional.ofNullable(clazz.cast(this.deviceStatusAsString()));
            }
            case "NetworkProfileArn": {
                return Optional.ofNullable(clazz.cast(this.networkProfileArn()));
            }
            case "NetworkProfileName": {
                return Optional.ofNullable(clazz.cast(this.networkProfileName()));
            }
            case "RoomArn": {
                return Optional.ofNullable(clazz.cast(this.roomArn()));
            }
            case "RoomName": {
                return Optional.ofNullable(clazz.cast(this.roomName()));
            }
            case "DeviceStatusInfo": {
                return Optional.ofNullable(clazz.cast(this.deviceStatusInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceData, T> g) {
        return obj -> g.apply((DeviceData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceArn;
        private String deviceSerialNumber;
        private String deviceType;
        private String deviceName;
        private String softwareVersion;
        private String macAddress;
        private String deviceStatus;
        private String networkProfileArn;
        private String networkProfileName;
        private String roomArn;
        private String roomName;
        private DeviceStatusInfo deviceStatusInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceData model) {
            this.deviceArn(model.deviceArn);
            this.deviceSerialNumber(model.deviceSerialNumber);
            this.deviceType(model.deviceType);
            this.deviceName(model.deviceName);
            this.softwareVersion(model.softwareVersion);
            this.macAddress(model.macAddress);
            this.deviceStatus(model.deviceStatus);
            this.networkProfileArn(model.networkProfileArn);
            this.networkProfileName(model.networkProfileName);
            this.roomArn(model.roomArn);
            this.roomName(model.roomName);
            this.deviceStatusInfo(model.deviceStatusInfo);
        }

        public final String getDeviceArn() {
            return this.deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getDeviceSerialNumber() {
            return this.deviceSerialNumber;
        }

        @Override
        public final Builder deviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
            return this;
        }

        public final void setDeviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
        }

        public final String getDeviceType() {
            return this.deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getSoftwareVersion() {
            return this.softwareVersion;
        }

        @Override
        public final Builder softwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
            return this;
        }

        public final void setSoftwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final String getDeviceStatusAsString() {
            return this.deviceStatus;
        }

        @Override
        public final Builder deviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
            return this;
        }

        @Override
        public final Builder deviceStatus(DeviceStatus deviceStatus) {
            this.deviceStatus(deviceStatus.toString());
            return this;
        }

        public final void setDeviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
        }

        public final String getNetworkProfileArn() {
            return this.networkProfileArn;
        }

        @Override
        public final Builder networkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
            return this;
        }

        public final void setNetworkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
        }

        public final String getNetworkProfileName() {
            return this.networkProfileName;
        }

        @Override
        public final Builder networkProfileName(String networkProfileName) {
            this.networkProfileName = networkProfileName;
            return this;
        }

        public final void setNetworkProfileName(String networkProfileName) {
            this.networkProfileName = networkProfileName;
        }

        public final String getRoomArn() {
            return this.roomArn;
        }

        @Override
        public final Builder roomArn(String roomArn) {
            this.roomArn = roomArn;
            return this;
        }

        public final void setRoomArn(String roomArn) {
            this.roomArn = roomArn;
        }

        public final String getRoomName() {
            return this.roomName;
        }

        @Override
        public final Builder roomName(String roomName) {
            this.roomName = roomName;
            return this;
        }

        public final void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        public final DeviceStatusInfo.Builder getDeviceStatusInfo() {
            return this.deviceStatusInfo != null ? this.deviceStatusInfo.toBuilder() : null;
        }

        @Override
        public final Builder deviceStatusInfo(DeviceStatusInfo deviceStatusInfo) {
            this.deviceStatusInfo = deviceStatusInfo;
            return this;
        }

        public final void setDeviceStatusInfo(DeviceStatusInfo.BuilderImpl deviceStatusInfo) {
            this.deviceStatusInfo = deviceStatusInfo != null ? deviceStatusInfo.build() : null;
        }

        public DeviceData build() {
            return new DeviceData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceData> {
        public Builder deviceArn(String var1);

        public Builder deviceSerialNumber(String var1);

        public Builder deviceType(String var1);

        public Builder deviceName(String var1);

        public Builder softwareVersion(String var1);

        public Builder macAddress(String var1);

        public Builder deviceStatus(String var1);

        public Builder deviceStatus(DeviceStatus var1);

        public Builder networkProfileArn(String var1);

        public Builder networkProfileName(String var1);

        public Builder roomArn(String var1);

        public Builder roomName(String var1);

        public Builder deviceStatusInfo(DeviceStatusInfo var1);

        default public Builder deviceStatusInfo(Consumer<DeviceStatusInfo.Builder> deviceStatusInfo) {
            return this.deviceStatusInfo((DeviceStatusInfo)((DeviceStatusInfo.Builder)DeviceStatusInfo.builder().applyMutation(deviceStatusInfo)).build());
        }
    }
}

