/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGatewayGroupResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<CreateGatewayGroupResponse.Builder, CreateGatewayGroupResponse> {
    private static final SdkField<String> GATEWAY_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGatewayGroupResponse::gatewayGroupArn)).setter(setter(Builder::gatewayGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_GROUP_ARN_FIELD));

    private final String gatewayGroupArn;

    private CreateGatewayGroupResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayGroupArn = builder.gatewayGroupArn;
    }

    /**
     * <p>
     * The ARN of the created gateway group.
     * </p>
     * 
     * @return The ARN of the created gateway group.
     */
    public String gatewayGroupArn() {
        return gatewayGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayGroupArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGatewayGroupResponse)) {
            return false;
        }
        CreateGatewayGroupResponse other = (CreateGatewayGroupResponse) obj;
        return Objects.equals(gatewayGroupArn(), other.gatewayGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateGatewayGroupResponse").add("GatewayGroupArn", gatewayGroupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayGroupArn":
            return Optional.ofNullable(clazz.cast(gatewayGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGatewayGroupResponse, T> g) {
        return obj -> g.apply((CreateGatewayGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateGatewayGroupResponse> {
        /**
         * <p>
         * The ARN of the created gateway group.
         * </p>
         * 
         * @param gatewayGroupArn
         *        The ARN of the created gateway group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayGroupArn(String gatewayGroupArn);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private String gatewayGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGatewayGroupResponse model) {
            super(model);
            gatewayGroupArn(model.gatewayGroupArn);
        }

        public final String getGatewayGroupArn() {
            return gatewayGroupArn;
        }

        @Override
        public final Builder gatewayGroupArn(String gatewayGroupArn) {
            this.gatewayGroupArn = gatewayGroupArn;
            return this;
        }

        public final void setGatewayGroupArn(String gatewayGroupArn) {
            this.gatewayGroupArn = gatewayGroupArn;
        }

        @Override
        public CreateGatewayGroupResponse build() {
            return new CreateGatewayGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
