/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchContactsRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<SearchContactsRequest.Builder, SearchContactsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(SearchContactsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Sort>> SORT_CRITERIA_FIELD = SdkField
            .<List<Sort>> builder(MarshallingType.LIST)
            .getter(getter(SearchContactsRequest::sortCriteria))
            .setter(setter(Builder::sortCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortCriteria").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Sort> builder(MarshallingType.SDK_POJO)
                                            .constructor(Sort::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchContactsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SearchContactsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            SORT_CRITERIA_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<Filter> filters;

    private final List<Sort> sortCriteria;

    private final String nextToken;

    private final Integer maxResults;

    private SearchContactsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.sortCriteria = builder.sortCriteria;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The filters to use to list a specified set of address books. The supported filter keys are DisplayName,
     * FirstName, LastName, and AddressBookArns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The filters to use to list a specified set of address books. The supported filter keys are DisplayName,
     *         FirstName, LastName, and AddressBookArns.
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The sort order to use in listing the specified set of contacts. The supported sort keys are DisplayName,
     * FirstName, and LastName.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The sort order to use in listing the specified set of contacts. The supported sort keys are DisplayName,
     *         FirstName, and LastName.
     */
    public List<Sort> sortCriteria() {
        return sortCriteria;
    }

    /**
     * <p>
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If
     * this parameter is specified, the response only includes results beyond the token, up to the value specified by
     * MaxResults.
     * </p>
     * 
     * @return An optional token returned from a prior request. Use this token for pagination of results from this
     *         action. If this parameter is specified, the response only includes results beyond the token, up to the
     *         value specified by MaxResults.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to include in the response. If more results exist than the specified MaxResults
     * value, a token is included in the response so that the remaining results can be retrieved.
     * </p>
     * 
     * @return The maximum number of results to include in the response. If more results exist than the specified
     *         MaxResults value, a token is included in the response so that the remaining results can be retrieved.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(sortCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchContactsRequest)) {
            return false;
        }
        SearchContactsRequest other = (SearchContactsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(sortCriteria(), other.sortCriteria())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchContactsRequest").add("Filters", filters()).add("SortCriteria", sortCriteria())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "SortCriteria":
            return Optional.ofNullable(clazz.cast(sortCriteria()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchContactsRequest, T> g) {
        return obj -> g.apply((SearchContactsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchContactsRequest> {
        /**
         * <p>
         * The filters to use to list a specified set of address books. The supported filter keys are DisplayName,
         * FirstName, LastName, and AddressBookArns.
         * </p>
         * 
         * @param filters
         *        The filters to use to list a specified set of address books. The supported filter keys are
         *        DisplayName, FirstName, LastName, and AddressBookArns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * The filters to use to list a specified set of address books. The supported filter keys are DisplayName,
         * FirstName, LastName, and AddressBookArns.
         * </p>
         * 
         * @param filters
         *        The filters to use to list a specified set of address books. The supported filter keys are
         *        DisplayName, FirstName, LastName, and AddressBookArns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The filters to use to list a specified set of address books. The supported filter keys are DisplayName,
         * FirstName, LastName, and AddressBookArns.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The sort order to use in listing the specified set of contacts. The supported sort keys are DisplayName,
         * FirstName, and LastName.
         * </p>
         * 
         * @param sortCriteria
         *        The sort order to use in listing the specified set of contacts. The supported sort keys are
         *        DisplayName, FirstName, and LastName.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(Collection<Sort> sortCriteria);

        /**
         * <p>
         * The sort order to use in listing the specified set of contacts. The supported sort keys are DisplayName,
         * FirstName, and LastName.
         * </p>
         * 
         * @param sortCriteria
         *        The sort order to use in listing the specified set of contacts. The supported sort keys are
         *        DisplayName, FirstName, and LastName.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(Sort... sortCriteria);

        /**
         * <p>
         * The sort order to use in listing the specified set of contacts. The supported sort keys are DisplayName,
         * FirstName, and LastName.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Sort>.Builder} avoiding the need to create
         * one manually via {@link List<Sort>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Sort>.Builder#build()} is called immediately and its result
         * is passed to {@link #sortCriteria(List<Sort>)}.
         * 
         * @param sortCriteria
         *        a consumer that will call methods on {@link List<Sort>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortCriteria(List<Sort>)
         */
        Builder sortCriteria(Consumer<Sort.Builder>... sortCriteria);

        /**
         * <p>
         * An optional token returned from a prior request. Use this token for pagination of results from this action.
         * If this parameter is specified, the response only includes results beyond the token, up to the value
         * specified by MaxResults.
         * </p>
         * 
         * @param nextToken
         *        An optional token returned from a prior request. Use this token for pagination of results from this
         *        action. If this parameter is specified, the response only includes results beyond the token, up to the
         *        value specified by MaxResults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to include in the response. If more results exist than the specified MaxResults
         * value, a token is included in the response so that the remaining results can be retrieved.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to include in the response. If more results exist than the specified
         *        MaxResults value, a token is included in the response so that the remaining results can be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<Sort> sortCriteria = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchContactsRequest model) {
            super(model);
            filters(model.filters);
            sortCriteria(model.sortCriteria);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<Sort.Builder> getSortCriteria() {
            return sortCriteria != null ? sortCriteria.stream().map(Sort::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sortCriteria(Collection<Sort> sortCriteria) {
            this.sortCriteria = SortListCopier.copy(sortCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortCriteria(Sort... sortCriteria) {
            sortCriteria(Arrays.asList(sortCriteria));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortCriteria(Consumer<Sort.Builder>... sortCriteria) {
            sortCriteria(Stream.of(sortCriteria).map(c -> Sort.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSortCriteria(Collection<Sort.BuilderImpl> sortCriteria) {
            this.sortCriteria = SortListCopier.copyFromBuilder(sortCriteria);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchContactsRequest build() {
            return new SearchContactsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
