/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumber;
import software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberListCopier;
import software.amazon.awssdk.services.alexaforbusiness.model.SipAddress;
import software.amazon.awssdk.services.alexaforbusiness.model.SipAddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateContactRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, UpdateContactRequest> {
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateContactRequest.getter(UpdateContactRequest::contactArn)).setter(UpdateContactRequest.setter(Builder::contactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateContactRequest.getter(UpdateContactRequest::displayName)).setter(UpdateContactRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateContactRequest.getter(UpdateContactRequest::firstName)).setter(UpdateContactRequest.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateContactRequest.getter(UpdateContactRequest::lastName)).setter(UpdateContactRequest.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateContactRequest.getter(UpdateContactRequest::phoneNumber)).setter(UpdateContactRequest.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<List<PhoneNumber>> PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateContactRequest.getter(UpdateContactRequest::phoneNumbers)).setter(UpdateContactRequest.setter(Builder::phoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhoneNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SipAddress>> SIP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateContactRequest.getter(UpdateContactRequest::sipAddresses)).setter(UpdateContactRequest.setter(Builder::sipAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SipAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ARN_FIELD, DISPLAY_NAME_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, PHONE_NUMBER_FIELD, PHONE_NUMBERS_FIELD, SIP_ADDRESSES_FIELD));
    private final String contactArn;
    private final String displayName;
    private final String firstName;
    private final String lastName;
    private final String phoneNumber;
    private final List<PhoneNumber> phoneNumbers;
    private final List<SipAddress> sipAddresses;

    private UpdateContactRequest(BuilderImpl builder) {
        super(builder);
        this.contactArn = builder.contactArn;
        this.displayName = builder.displayName;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.phoneNumber = builder.phoneNumber;
        this.phoneNumbers = builder.phoneNumbers;
        this.sipAddresses = builder.sipAddresses;
    }

    public String contactArn() {
        return this.contactArn;
    }

    public String displayName() {
        return this.displayName;
    }

    public String firstName() {
        return this.firstName;
    }

    public String lastName() {
        return this.lastName;
    }

    public String phoneNumber() {
        return this.phoneNumber;
    }

    public List<PhoneNumber> phoneNumbers() {
        return this.phoneNumbers;
    }

    public List<SipAddress> sipAddresses() {
        return this.sipAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(this.sipAddresses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactRequest)) {
            return false;
        }
        UpdateContactRequest other = (UpdateContactRequest)((Object)obj);
        return Objects.equals(this.contactArn(), other.contactArn()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.phoneNumbers(), other.phoneNumbers()) && Objects.equals(this.sipAddresses(), other.sipAddresses());
    }

    public String toString() {
        return ToString.builder((String)"UpdateContactRequest").add("ContactArn", (Object)this.contactArn()).add("DisplayName", (Object)this.displayName()).add("FirstName", (Object)this.firstName()).add("LastName", (Object)this.lastName()).add("PhoneNumber", (Object)(this.phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("PhoneNumbers", this.phoneNumbers()).add("SipAddresses", this.sipAddresses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactArn": {
                return Optional.ofNullable(clazz.cast(this.contactArn()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "FirstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "LastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "PhoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.phoneNumbers()));
            }
            case "SipAddresses": {
                return Optional.ofNullable(clazz.cast(this.sipAddresses()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactRequest, T> g) {
        return obj -> g.apply((UpdateContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String contactArn;
        private String displayName;
        private String firstName;
        private String lastName;
        private String phoneNumber;
        private List<PhoneNumber> phoneNumbers = DefaultSdkAutoConstructList.getInstance();
        private List<SipAddress> sipAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactRequest model) {
            super(model);
            this.contactArn(model.contactArn);
            this.displayName(model.displayName);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.phoneNumber(model.phoneNumber);
            this.phoneNumbers(model.phoneNumbers);
            this.sipAddresses(model.sipAddresses);
        }

        public final String getContactArn() {
            return this.contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public final String getLastName() {
            return this.lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final Collection<PhoneNumber.Builder> getPhoneNumbers() {
            return this.phoneNumbers != null ? (Collection)this.phoneNumbers.stream().map(PhoneNumber::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phoneNumbers(Collection<PhoneNumber> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(PhoneNumber ... phoneNumbers) {
            this.phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(Consumer<PhoneNumber.Builder> ... phoneNumbers) {
            this.phoneNumbers(Stream.of(phoneNumbers).map(c -> (PhoneNumber)((PhoneNumber.Builder)PhoneNumber.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPhoneNumbers(Collection<PhoneNumber.BuilderImpl> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copyFromBuilder(phoneNumbers);
        }

        public final Collection<SipAddress.Builder> getSipAddresses() {
            return this.sipAddresses != null ? (Collection)this.sipAddresses.stream().map(SipAddress::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sipAddresses(Collection<SipAddress> sipAddresses) {
            this.sipAddresses = SipAddressListCopier.copy(sipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sipAddresses(SipAddress ... sipAddresses) {
            this.sipAddresses(Arrays.asList(sipAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sipAddresses(Consumer<SipAddress.Builder> ... sipAddresses) {
            this.sipAddresses(Stream.of(sipAddresses).map(c -> (SipAddress)((SipAddress.Builder)SipAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSipAddresses(Collection<SipAddress.BuilderImpl> sipAddresses) {
            this.sipAddresses = SipAddressListCopier.copyFromBuilder(sipAddresses);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactRequest build() {
            return new UpdateContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateContactRequest> {
        public Builder contactArn(String var1);

        public Builder displayName(String var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder phoneNumber(String var1);

        public Builder phoneNumbers(Collection<PhoneNumber> var1);

        public Builder phoneNumbers(PhoneNumber ... var1);

        public Builder phoneNumbers(Consumer<PhoneNumber.Builder> ... var1);

        public Builder sipAddresses(Collection<SipAddress> var1);

        public Builder sipAddresses(SipAddress ... var1);

        public Builder sipAddresses(Consumer<SipAddress.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

