/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data of a room profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileData implements SdkPojo, Serializable, ToCopyableBuilder<ProfileData.Builder, ProfileData> {
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProfileData::profileArn)).setter(setter(Builder::profileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()).build();

    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProfileData::profileName)).setter(setter(Builder::profileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ProfileData::isDefault)).setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()).build();

    private static final SdkField<String> ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProfileData::address)).setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProfileData::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProfileData::distanceUnitAsString)).setter(setter(Builder::distanceUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()).build();

    private static final SdkField<String> TEMPERATURE_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProfileData::temperatureUnitAsString)).setter(setter(Builder::temperatureUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemperatureUnit").build()).build();

    private static final SdkField<String> WAKE_WORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProfileData::wakeWordAsString)).setter(setter(Builder::wakeWord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WakeWord").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ARN_FIELD,
            PROFILE_NAME_FIELD, IS_DEFAULT_FIELD, ADDRESS_FIELD, TIMEZONE_FIELD, DISTANCE_UNIT_FIELD, TEMPERATURE_UNIT_FIELD,
            WAKE_WORD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String profileArn;

    private final String profileName;

    private final Boolean isDefault;

    private final String address;

    private final String timezone;

    private final String distanceUnit;

    private final String temperatureUnit;

    private final String wakeWord;

    private ProfileData(BuilderImpl builder) {
        this.profileArn = builder.profileArn;
        this.profileName = builder.profileName;
        this.isDefault = builder.isDefault;
        this.address = builder.address;
        this.timezone = builder.timezone;
        this.distanceUnit = builder.distanceUnit;
        this.temperatureUnit = builder.temperatureUnit;
        this.wakeWord = builder.wakeWord;
    }

    /**
     * <p>
     * The ARN of a room profile.
     * </p>
     * 
     * @return The ARN of a room profile.
     */
    public String profileArn() {
        return profileArn;
    }

    /**
     * <p>
     * The name of a room profile.
     * </p>
     * 
     * @return The name of a room profile.
     */
    public String profileName() {
        return profileName;
    }

    /**
     * <p>
     * Retrieves if the profile data is default or not.
     * </p>
     * 
     * @return Retrieves if the profile data is default or not.
     */
    public Boolean isDefault() {
        return isDefault;
    }

    /**
     * <p>
     * The address of a room profile.
     * </p>
     * 
     * @return The address of a room profile.
     */
    public String address() {
        return address;
    }

    /**
     * <p>
     * The timezone of a room profile.
     * </p>
     * 
     * @return The timezone of a room profile.
     */
    public String timezone() {
        return timezone;
    }

    /**
     * <p>
     * The distance unit of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The distance unit of a room profile.
     * @see DistanceUnit
     */
    public DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(distanceUnit);
    }

    /**
     * <p>
     * The distance unit of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #distanceUnit} will
     * return {@link DistanceUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #distanceUnitAsString}.
     * </p>
     * 
     * @return The distance unit of a room profile.
     * @see DistanceUnit
     */
    public String distanceUnitAsString() {
        return distanceUnit;
    }

    /**
     * <p>
     * The temperature unit of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #temperatureUnit}
     * will return {@link TemperatureUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #temperatureUnitAsString}.
     * </p>
     * 
     * @return The temperature unit of a room profile.
     * @see TemperatureUnit
     */
    public TemperatureUnit temperatureUnit() {
        return TemperatureUnit.fromValue(temperatureUnit);
    }

    /**
     * <p>
     * The temperature unit of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #temperatureUnit}
     * will return {@link TemperatureUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #temperatureUnitAsString}.
     * </p>
     * 
     * @return The temperature unit of a room profile.
     * @see TemperatureUnit
     */
    public String temperatureUnitAsString() {
        return temperatureUnit;
    }

    /**
     * <p>
     * The wake word of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wakeWord} will
     * return {@link WakeWord#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wakeWordAsString}.
     * </p>
     * 
     * @return The wake word of a room profile.
     * @see WakeWord
     */
    public WakeWord wakeWord() {
        return WakeWord.fromValue(wakeWord);
    }

    /**
     * <p>
     * The wake word of a room profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wakeWord} will
     * return {@link WakeWord#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #wakeWordAsString}.
     * </p>
     * 
     * @return The wake word of a room profile.
     * @see WakeWord
     */
    public String wakeWordAsString() {
        return wakeWord;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(distanceUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(temperatureUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(wakeWordAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileData)) {
            return false;
        }
        ProfileData other = (ProfileData) obj;
        return Objects.equals(profileArn(), other.profileArn()) && Objects.equals(profileName(), other.profileName())
                && Objects.equals(isDefault(), other.isDefault()) && Objects.equals(address(), other.address())
                && Objects.equals(timezone(), other.timezone())
                && Objects.equals(distanceUnitAsString(), other.distanceUnitAsString())
                && Objects.equals(temperatureUnitAsString(), other.temperatureUnitAsString())
                && Objects.equals(wakeWordAsString(), other.wakeWordAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProfileData").add("ProfileArn", profileArn()).add("ProfileName", profileName())
                .add("IsDefault", isDefault()).add("Address", address()).add("Timezone", timezone())
                .add("DistanceUnit", distanceUnitAsString()).add("TemperatureUnit", temperatureUnitAsString())
                .add("WakeWord", wakeWordAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileArn":
            return Optional.ofNullable(clazz.cast(profileArn()));
        case "ProfileName":
            return Optional.ofNullable(clazz.cast(profileName()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "DistanceUnit":
            return Optional.ofNullable(clazz.cast(distanceUnitAsString()));
        case "TemperatureUnit":
            return Optional.ofNullable(clazz.cast(temperatureUnitAsString()));
        case "WakeWord":
            return Optional.ofNullable(clazz.cast(wakeWordAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProfileData, T> g) {
        return obj -> g.apply((ProfileData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileData> {
        /**
         * <p>
         * The ARN of a room profile.
         * </p>
         * 
         * @param profileArn
         *        The ARN of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);

        /**
         * <p>
         * The name of a room profile.
         * </p>
         * 
         * @param profileName
         *        The name of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * Retrieves if the profile data is default or not.
         * </p>
         * 
         * @param isDefault
         *        Retrieves if the profile data is default or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * The address of a room profile.
         * </p>
         * 
         * @param address
         *        The address of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The timezone of a room profile.
         * </p>
         * 
         * @param timezone
         *        The timezone of a room profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * The distance unit of a room profile.
         * </p>
         * 
         * @param distanceUnit
         *        The distance unit of a room profile.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(String distanceUnit);

        /**
         * <p>
         * The distance unit of a room profile.
         * </p>
         * 
         * @param distanceUnit
         *        The distance unit of a room profile.
         * @see DistanceUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DistanceUnit
         */
        Builder distanceUnit(DistanceUnit distanceUnit);

        /**
         * <p>
         * The temperature unit of a room profile.
         * </p>
         * 
         * @param temperatureUnit
         *        The temperature unit of a room profile.
         * @see TemperatureUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemperatureUnit
         */
        Builder temperatureUnit(String temperatureUnit);

        /**
         * <p>
         * The temperature unit of a room profile.
         * </p>
         * 
         * @param temperatureUnit
         *        The temperature unit of a room profile.
         * @see TemperatureUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemperatureUnit
         */
        Builder temperatureUnit(TemperatureUnit temperatureUnit);

        /**
         * <p>
         * The wake word of a room profile.
         * </p>
         * 
         * @param wakeWord
         *        The wake word of a room profile.
         * @see WakeWord
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WakeWord
         */
        Builder wakeWord(String wakeWord);

        /**
         * <p>
         * The wake word of a room profile.
         * </p>
         * 
         * @param wakeWord
         *        The wake word of a room profile.
         * @see WakeWord
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WakeWord
         */
        Builder wakeWord(WakeWord wakeWord);
    }

    static final class BuilderImpl implements Builder {
        private String profileArn;

        private String profileName;

        private Boolean isDefault;

        private String address;

        private String timezone;

        private String distanceUnit;

        private String temperatureUnit;

        private String wakeWord;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileData model) {
            profileArn(model.profileArn);
            profileName(model.profileName);
            isDefault(model.isDefault);
            address(model.address);
            timezone(model.timezone);
            distanceUnit(model.distanceUnit);
            temperatureUnit(model.temperatureUnit);
            wakeWord(model.wakeWord);
        }

        public final String getProfileArn() {
            return profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        public final String getProfileName() {
            return profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public final String getAddress() {
            return address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getTimezone() {
            return timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final String getDistanceUnitAsString() {
            return distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        public final String getTemperatureUnitAsString() {
            return temperatureUnit;
        }

        @Override
        public final Builder temperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
            return this;
        }

        @Override
        public final Builder temperatureUnit(TemperatureUnit temperatureUnit) {
            this.temperatureUnit(temperatureUnit == null ? null : temperatureUnit.toString());
            return this;
        }

        public final void setTemperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
        }

        public final String getWakeWordAsString() {
            return wakeWord;
        }

        @Override
        public final Builder wakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
            return this;
        }

        @Override
        public final Builder wakeWord(WakeWord wakeWord) {
            this.wakeWord(wakeWord == null ? null : wakeWord.toString());
            return this;
        }

        public final void setWakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
        }

        @Override
        public ProfileData build() {
            return new ProfileData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
