/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSkillsStoreCategoriesResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<ListSkillsStoreCategoriesResponse.Builder, ListSkillsStoreCategoriesResponse> {
    private static final SdkField<List<Category>> CATEGORY_LIST_FIELD = SdkField
            .<List<Category>> builder(MarshallingType.LIST)
            .getter(getter(ListSkillsStoreCategoriesResponse::categoryList))
            .setter(setter(Builder::categoryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Category> builder(MarshallingType.SDK_POJO)
                                            .constructor(Category::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListSkillsStoreCategoriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Category> categoryList;

    private final String nextToken;

    private ListSkillsStoreCategoriesResponse(BuilderImpl builder) {
        super(builder);
        this.categoryList = builder.categoryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of categories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of categories.
     */
    public List<Category> categoryList() {
        return categoryList;
    }

    /**
     * <p>
     * The tokens used for pagination.
     * </p>
     * 
     * @return The tokens used for pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(categoryList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSkillsStoreCategoriesResponse)) {
            return false;
        }
        ListSkillsStoreCategoriesResponse other = (ListSkillsStoreCategoriesResponse) obj;
        return Objects.equals(categoryList(), other.categoryList()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSkillsStoreCategoriesResponse").add("CategoryList", categoryList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CategoryList":
            return Optional.ofNullable(clazz.cast(categoryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSkillsStoreCategoriesResponse, T> g) {
        return obj -> g.apply((ListSkillsStoreCategoriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSkillsStoreCategoriesResponse> {
        /**
         * <p>
         * The list of categories.
         * </p>
         * 
         * @param categoryList
         *        The list of categories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryList(Collection<Category> categoryList);

        /**
         * <p>
         * The list of categories.
         * </p>
         * 
         * @param categoryList
         *        The list of categories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryList(Category... categoryList);

        /**
         * <p>
         * The list of categories.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Category>.Builder} avoiding the need to
         * create one manually via {@link List<Category>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Category>.Builder#build()} is called immediately and its
         * result is passed to {@link #categoryList(List<Category>)}.
         * 
         * @param categoryList
         *        a consumer that will call methods on {@link List<Category>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryList(List<Category>)
         */
        Builder categoryList(Consumer<Category.Builder>... categoryList);

        /**
         * <p>
         * The tokens used for pagination.
         * </p>
         * 
         * @param nextToken
         *        The tokens used for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<Category> categoryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSkillsStoreCategoriesResponse model) {
            super(model);
            categoryList(model.categoryList);
            nextToken(model.nextToken);
        }

        public final Collection<Category.Builder> getCategoryList() {
            return categoryList != null ? categoryList.stream().map(Category::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder categoryList(Collection<Category> categoryList) {
            this.categoryList = CategoryListCopier.copy(categoryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoryList(Category... categoryList) {
            categoryList(Arrays.asList(categoryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoryList(Consumer<Category.Builder>... categoryList) {
            categoryList(Stream.of(categoryList).map(c -> Category.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCategoryList(Collection<Category.BuilderImpl> categoryList) {
            this.categoryList = CategoryListCopier.copyFromBuilder(categoryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSkillsStoreCategoriesResponse build() {
            return new ListSkillsStoreCategoriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
