/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutInvitationConfigurationRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<PutInvitationConfigurationRequest.Builder, PutInvitationConfigurationRequest> {
    private static final SdkField<String> ORGANIZATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutInvitationConfigurationRequest::organizationName)).setter(setter(Builder::organizationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationName").build()).build();

    private static final SdkField<String> CONTACT_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutInvitationConfigurationRequest::contactEmail)).setter(setter(Builder::contactEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactEmail").build()).build();

    private static final SdkField<List<String>> PRIVATE_SKILL_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PutInvitationConfigurationRequest::privateSkillIds))
            .setter(setter(Builder::privateSkillIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateSkillIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_NAME_FIELD,
            CONTACT_EMAIL_FIELD, PRIVATE_SKILL_IDS_FIELD));

    private final String organizationName;

    private final String contactEmail;

    private final List<String> privateSkillIds;

    private PutInvitationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.organizationName = builder.organizationName;
        this.contactEmail = builder.contactEmail;
        this.privateSkillIds = builder.privateSkillIds;
    }

    /**
     * <p>
     * The name of the organization sending the enrollment invite to a user.
     * </p>
     * 
     * @return The name of the organization sending the enrollment invite to a user.
     */
    public String organizationName() {
        return organizationName;
    }

    /**
     * <p>
     * The email ID of the organization or individual contact that the enrolled user can use.
     * </p>
     * 
     * @return The email ID of the organization or individual contact that the enrolled user can use.
     */
    public String contactEmail() {
        return contactEmail;
    }

    /**
     * <p>
     * The list of private skill IDs that you want to recommend to the user to enable in the invitation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of private skill IDs that you want to recommend to the user to enable in the invitation.
     */
    public List<String> privateSkillIds() {
        return privateSkillIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationName());
        hashCode = 31 * hashCode + Objects.hashCode(contactEmail());
        hashCode = 31 * hashCode + Objects.hashCode(privateSkillIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInvitationConfigurationRequest)) {
            return false;
        }
        PutInvitationConfigurationRequest other = (PutInvitationConfigurationRequest) obj;
        return Objects.equals(organizationName(), other.organizationName())
                && Objects.equals(contactEmail(), other.contactEmail())
                && Objects.equals(privateSkillIds(), other.privateSkillIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutInvitationConfigurationRequest").add("OrganizationName", organizationName())
                .add("ContactEmail", contactEmail()).add("PrivateSkillIds", privateSkillIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationName":
            return Optional.ofNullable(clazz.cast(organizationName()));
        case "ContactEmail":
            return Optional.ofNullable(clazz.cast(contactEmail()));
        case "PrivateSkillIds":
            return Optional.ofNullable(clazz.cast(privateSkillIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutInvitationConfigurationRequest, T> g) {
        return obj -> g.apply((PutInvitationConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutInvitationConfigurationRequest> {
        /**
         * <p>
         * The name of the organization sending the enrollment invite to a user.
         * </p>
         * 
         * @param organizationName
         *        The name of the organization sending the enrollment invite to a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationName(String organizationName);

        /**
         * <p>
         * The email ID of the organization or individual contact that the enrolled user can use.
         * </p>
         * 
         * @param contactEmail
         *        The email ID of the organization or individual contact that the enrolled user can use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactEmail(String contactEmail);

        /**
         * <p>
         * The list of private skill IDs that you want to recommend to the user to enable in the invitation.
         * </p>
         * 
         * @param privateSkillIds
         *        The list of private skill IDs that you want to recommend to the user to enable in the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateSkillIds(Collection<String> privateSkillIds);

        /**
         * <p>
         * The list of private skill IDs that you want to recommend to the user to enable in the invitation.
         * </p>
         * 
         * @param privateSkillIds
         *        The list of private skill IDs that you want to recommend to the user to enable in the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateSkillIds(String... privateSkillIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String organizationName;

        private String contactEmail;

        private List<String> privateSkillIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutInvitationConfigurationRequest model) {
            super(model);
            organizationName(model.organizationName);
            contactEmail(model.contactEmail);
            privateSkillIds(model.privateSkillIds);
        }

        public final String getOrganizationName() {
            return organizationName;
        }

        @Override
        public final Builder organizationName(String organizationName) {
            this.organizationName = organizationName;
            return this;
        }

        public final void setOrganizationName(String organizationName) {
            this.organizationName = organizationName;
        }

        public final String getContactEmail() {
            return contactEmail;
        }

        @Override
        public final Builder contactEmail(String contactEmail) {
            this.contactEmail = contactEmail;
            return this;
        }

        public final void setContactEmail(String contactEmail) {
            this.contactEmail = contactEmail;
        }

        public final Collection<String> getPrivateSkillIds() {
            return privateSkillIds;
        }

        @Override
        public final Builder privateSkillIds(Collection<String> privateSkillIds) {
            this.privateSkillIds = ShortSkillIdListCopier.copy(privateSkillIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateSkillIds(String... privateSkillIds) {
            privateSkillIds(Arrays.asList(privateSkillIds));
            return this;
        }

        public final void setPrivateSkillIds(Collection<String> privateSkillIds) {
            this.privateSkillIds = ShortSkillIdListCopier.copy(privateSkillIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutInvitationConfigurationRequest build() {
            return new PutInvitationConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
