/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum WakeWord {
    ALEXA("ALEXA"),
    AMAZON("AMAZON"),
    ECHO("ECHO"),
    COMPUTER("COMPUTER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private WakeWord(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WakeWord fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(WakeWord.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WakeWord> knownValues() {
        return Stream.of(WakeWord.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

