/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of skills.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SkillSummary implements SdkPojo, Serializable, ToCopyableBuilder<SkillSummary.Builder, SkillSummary> {
    private static final SdkField<String> SKILL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SkillSummary::skillId)).setter(setter(Builder::skillId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillId").build()).build();

    private static final SdkField<String> SKILL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SkillSummary::skillName)).setter(setter(Builder::skillName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillName").build()).build();

    private static final SdkField<Boolean> SUPPORTS_LINKING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(SkillSummary::supportsLinking)).setter(setter(Builder::supportsLinking))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportsLinking").build()).build();

    private static final SdkField<String> ENABLEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SkillSummary::enablementTypeAsString)).setter(setter(Builder::enablementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablementType").build()).build();

    private static final SdkField<String> SKILL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SkillSummary::skillTypeAsString)).setter(setter(Builder::skillType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkillType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKILL_ID_FIELD,
            SKILL_NAME_FIELD, SUPPORTS_LINKING_FIELD, ENABLEMENT_TYPE_FIELD, SKILL_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String skillId;

    private final String skillName;

    private final Boolean supportsLinking;

    private final String enablementType;

    private final String skillType;

    private SkillSummary(BuilderImpl builder) {
        this.skillId = builder.skillId;
        this.skillName = builder.skillName;
        this.supportsLinking = builder.supportsLinking;
        this.enablementType = builder.enablementType;
        this.skillType = builder.skillType;
    }

    /**
     * <p>
     * The ARN of the skill summary.
     * </p>
     * 
     * @return The ARN of the skill summary.
     */
    public String skillId() {
        return skillId;
    }

    /**
     * <p>
     * The name of the skill.
     * </p>
     * 
     * @return The name of the skill.
     */
    public String skillName() {
        return skillName;
    }

    /**
     * <p>
     * Linking support for a skill.
     * </p>
     * 
     * @return Linking support for a skill.
     */
    public Boolean supportsLinking() {
        return supportsLinking;
    }

    /**
     * <p>
     * Whether the skill is enabled under the user's account, or if it requires linking to be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enablementType}
     * will return {@link EnablementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #enablementTypeAsString}.
     * </p>
     * 
     * @return Whether the skill is enabled under the user's account, or if it requires linking to be used.
     * @see EnablementType
     */
    public EnablementType enablementType() {
        return EnablementType.fromValue(enablementType);
    }

    /**
     * <p>
     * Whether the skill is enabled under the user's account, or if it requires linking to be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enablementType}
     * will return {@link EnablementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #enablementTypeAsString}.
     * </p>
     * 
     * @return Whether the skill is enabled under the user's account, or if it requires linking to be used.
     * @see EnablementType
     */
    public String enablementTypeAsString() {
        return enablementType;
    }

    /**
     * <p>
     * Whether the skill is publicly available or is a private skill.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #skillType} will
     * return {@link SkillType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #skillTypeAsString}.
     * </p>
     * 
     * @return Whether the skill is publicly available or is a private skill.
     * @see SkillType
     */
    public SkillType skillType() {
        return SkillType.fromValue(skillType);
    }

    /**
     * <p>
     * Whether the skill is publicly available or is a private skill.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #skillType} will
     * return {@link SkillType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #skillTypeAsString}.
     * </p>
     * 
     * @return Whether the skill is publicly available or is a private skill.
     * @see SkillType
     */
    public String skillTypeAsString() {
        return skillType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skillId());
        hashCode = 31 * hashCode + Objects.hashCode(skillName());
        hashCode = 31 * hashCode + Objects.hashCode(supportsLinking());
        hashCode = 31 * hashCode + Objects.hashCode(enablementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(skillTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkillSummary)) {
            return false;
        }
        SkillSummary other = (SkillSummary) obj;
        return Objects.equals(skillId(), other.skillId()) && Objects.equals(skillName(), other.skillName())
                && Objects.equals(supportsLinking(), other.supportsLinking())
                && Objects.equals(enablementTypeAsString(), other.enablementTypeAsString())
                && Objects.equals(skillTypeAsString(), other.skillTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SkillSummary").add("SkillId", skillId()).add("SkillName", skillName())
                .add("SupportsLinking", supportsLinking()).add("EnablementType", enablementTypeAsString())
                .add("SkillType", skillTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkillId":
            return Optional.ofNullable(clazz.cast(skillId()));
        case "SkillName":
            return Optional.ofNullable(clazz.cast(skillName()));
        case "SupportsLinking":
            return Optional.ofNullable(clazz.cast(supportsLinking()));
        case "EnablementType":
            return Optional.ofNullable(clazz.cast(enablementTypeAsString()));
        case "SkillType":
            return Optional.ofNullable(clazz.cast(skillTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SkillSummary, T> g) {
        return obj -> g.apply((SkillSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SkillSummary> {
        /**
         * <p>
         * The ARN of the skill summary.
         * </p>
         * 
         * @param skillId
         *        The ARN of the skill summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillId(String skillId);

        /**
         * <p>
         * The name of the skill.
         * </p>
         * 
         * @param skillName
         *        The name of the skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skillName(String skillName);

        /**
         * <p>
         * Linking support for a skill.
         * </p>
         * 
         * @param supportsLinking
         *        Linking support for a skill.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportsLinking(Boolean supportsLinking);

        /**
         * <p>
         * Whether the skill is enabled under the user's account, or if it requires linking to be used.
         * </p>
         * 
         * @param enablementType
         *        Whether the skill is enabled under the user's account, or if it requires linking to be used.
         * @see EnablementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnablementType
         */
        Builder enablementType(String enablementType);

        /**
         * <p>
         * Whether the skill is enabled under the user's account, or if it requires linking to be used.
         * </p>
         * 
         * @param enablementType
         *        Whether the skill is enabled under the user's account, or if it requires linking to be used.
         * @see EnablementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnablementType
         */
        Builder enablementType(EnablementType enablementType);

        /**
         * <p>
         * Whether the skill is publicly available or is a private skill.
         * </p>
         * 
         * @param skillType
         *        Whether the skill is publicly available or is a private skill.
         * @see SkillType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SkillType
         */
        Builder skillType(String skillType);

        /**
         * <p>
         * Whether the skill is publicly available or is a private skill.
         * </p>
         * 
         * @param skillType
         *        Whether the skill is publicly available or is a private skill.
         * @see SkillType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SkillType
         */
        Builder skillType(SkillType skillType);
    }

    static final class BuilderImpl implements Builder {
        private String skillId;

        private String skillName;

        private Boolean supportsLinking;

        private String enablementType;

        private String skillType;

        private BuilderImpl() {
        }

        private BuilderImpl(SkillSummary model) {
            skillId(model.skillId);
            skillName(model.skillName);
            supportsLinking(model.supportsLinking);
            enablementType(model.enablementType);
            skillType(model.skillType);
        }

        public final String getSkillId() {
            return skillId;
        }

        @Override
        public final Builder skillId(String skillId) {
            this.skillId = skillId;
            return this;
        }

        public final void setSkillId(String skillId) {
            this.skillId = skillId;
        }

        public final String getSkillName() {
            return skillName;
        }

        @Override
        public final Builder skillName(String skillName) {
            this.skillName = skillName;
            return this;
        }

        public final void setSkillName(String skillName) {
            this.skillName = skillName;
        }

        public final Boolean getSupportsLinking() {
            return supportsLinking;
        }

        @Override
        public final Builder supportsLinking(Boolean supportsLinking) {
            this.supportsLinking = supportsLinking;
            return this;
        }

        public final void setSupportsLinking(Boolean supportsLinking) {
            this.supportsLinking = supportsLinking;
        }

        public final String getEnablementTypeAsString() {
            return enablementType;
        }

        @Override
        public final Builder enablementType(String enablementType) {
            this.enablementType = enablementType;
            return this;
        }

        @Override
        public final Builder enablementType(EnablementType enablementType) {
            this.enablementType(enablementType == null ? null : enablementType.toString());
            return this;
        }

        public final void setEnablementType(String enablementType) {
            this.enablementType = enablementType;
        }

        public final String getSkillTypeAsString() {
            return skillType;
        }

        @Override
        public final Builder skillType(String skillType) {
            this.skillType = skillType;
            return this;
        }

        @Override
        public final Builder skillType(SkillType skillType) {
            this.skillType(skillType == null ? null : skillType.toString());
            return this;
        }

        public final void setSkillType(String skillType) {
            this.skillType = skillType;
        }

        @Override
        public SkillSummary build() {
            return new SkillSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
