/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteUserRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<DeleteUserRequest.Builder, DeleteUserRequest> {
    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteUserRequest::userArn)).setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserArn").build()).build();

    private static final SdkField<String> ENROLLMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteUserRequest::enrollmentId)).setter(setter(Builder::enrollmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnrollmentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ARN_FIELD,
            ENROLLMENT_ID_FIELD));

    private final String userArn;

    private final String enrollmentId;

    private DeleteUserRequest(BuilderImpl builder) {
        super(builder);
        this.userArn = builder.userArn;
        this.enrollmentId = builder.enrollmentId;
    }

    /**
     * <p>
     * The ARN of the user to delete in the organization. Required.
     * </p>
     * 
     * @return The ARN of the user to delete in the organization. Required.
     */
    public String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The ARN of the user's enrollment in the organization. Required.
     * </p>
     * 
     * @return The ARN of the user's enrollment in the organization. Required.
     */
    public String enrollmentId() {
        return enrollmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(enrollmentId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteUserRequest)) {
            return false;
        }
        DeleteUserRequest other = (DeleteUserRequest) obj;
        return Objects.equals(userArn(), other.userArn()) && Objects.equals(enrollmentId(), other.enrollmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteUserRequest").add("UserArn", userArn()).add("EnrollmentId", enrollmentId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "EnrollmentId":
            return Optional.ofNullable(clazz.cast(enrollmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteUserRequest, T> g) {
        return obj -> g.apply((DeleteUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteUserRequest> {
        /**
         * <p>
         * The ARN of the user to delete in the organization. Required.
         * </p>
         * 
         * @param userArn
         *        The ARN of the user to delete in the organization. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The ARN of the user's enrollment in the organization. Required.
         * </p>
         * 
         * @param enrollmentId
         *        The ARN of the user's enrollment in the organization. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enrollmentId(String enrollmentId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String userArn;

        private String enrollmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteUserRequest model) {
            super(model);
            userArn(model.userArn);
            enrollmentId(model.enrollmentId);
        }

        public final String getUserArn() {
            return userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        public final String getEnrollmentId() {
            return enrollmentId;
        }

        @Override
        public final Builder enrollmentId(String enrollmentId) {
            this.enrollmentId = enrollmentId;
            return this;
        }

        public final void setEnrollmentId(String enrollmentId) {
            this.enrollmentId = enrollmentId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteUserRequest build() {
            return new DeleteUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
