/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.DistanceUnit;
import software.amazon.awssdk.services.alexaforbusiness.model.TemperatureUnit;
import software.amazon.awssdk.services.alexaforbusiness.model.WakeWord;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfileData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProfileData> {
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProfileData.getter(ProfileData::profileArn)).setter(ProfileData.setter(Builder::profileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()}).build();
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProfileData.getter(ProfileData::profileName)).setter(ProfileData.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ProfileData.getter(ProfileData::isDefault)).setter(ProfileData.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()}).build();
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProfileData.getter(ProfileData::address)).setter(ProfileData.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProfileData.getter(ProfileData::timezone)).setter(ProfileData.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<String> DISTANCE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProfileData.getter(ProfileData::distanceUnitAsString)).setter(ProfileData.setter(Builder::distanceUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceUnit").build()}).build();
    private static final SdkField<String> TEMPERATURE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProfileData.getter(ProfileData::temperatureUnitAsString)).setter(ProfileData.setter(Builder::temperatureUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemperatureUnit").build()}).build();
    private static final SdkField<String> WAKE_WORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProfileData.getter(ProfileData::wakeWordAsString)).setter(ProfileData.setter(Builder::wakeWord)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WakeWord").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProfileData.getter(ProfileData::locale)).setter(ProfileData.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ARN_FIELD, PROFILE_NAME_FIELD, IS_DEFAULT_FIELD, ADDRESS_FIELD, TIMEZONE_FIELD, DISTANCE_UNIT_FIELD, TEMPERATURE_UNIT_FIELD, WAKE_WORD_FIELD, LOCALE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String profileArn;
    private final String profileName;
    private final Boolean isDefault;
    private final String address;
    private final String timezone;
    private final String distanceUnit;
    private final String temperatureUnit;
    private final String wakeWord;
    private final String locale;

    private ProfileData(BuilderImpl builder) {
        this.profileArn = builder.profileArn;
        this.profileName = builder.profileName;
        this.isDefault = builder.isDefault;
        this.address = builder.address;
        this.timezone = builder.timezone;
        this.distanceUnit = builder.distanceUnit;
        this.temperatureUnit = builder.temperatureUnit;
        this.wakeWord = builder.wakeWord;
        this.locale = builder.locale;
    }

    public String profileArn() {
        return this.profileArn;
    }

    public String profileName() {
        return this.profileName;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public String address() {
        return this.address;
    }

    public String timezone() {
        return this.timezone;
    }

    public DistanceUnit distanceUnit() {
        return DistanceUnit.fromValue(this.distanceUnit);
    }

    public String distanceUnitAsString() {
        return this.distanceUnit;
    }

    public TemperatureUnit temperatureUnit() {
        return TemperatureUnit.fromValue(this.temperatureUnit);
    }

    public String temperatureUnitAsString() {
        return this.temperatureUnit;
    }

    public WakeWord wakeWord() {
        return WakeWord.fromValue(this.wakeWord);
    }

    public String wakeWordAsString() {
        return this.wakeWord;
    }

    public String locale() {
        return this.locale;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.distanceUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.temperatureUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.wakeWordAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileData)) {
            return false;
        }
        ProfileData other = (ProfileData)obj;
        return Objects.equals(this.profileArn(), other.profileArn()) && Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.isDefault(), other.isDefault()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.distanceUnitAsString(), other.distanceUnitAsString()) && Objects.equals(this.temperatureUnitAsString(), other.temperatureUnitAsString()) && Objects.equals(this.wakeWordAsString(), other.wakeWordAsString()) && Objects.equals(this.locale(), other.locale());
    }

    public String toString() {
        return ToString.builder((String)"ProfileData").add("ProfileArn", (Object)this.profileArn()).add("ProfileName", (Object)this.profileName()).add("IsDefault", (Object)this.isDefault()).add("Address", (Object)this.address()).add("Timezone", (Object)this.timezone()).add("DistanceUnit", (Object)this.distanceUnitAsString()).add("TemperatureUnit", (Object)this.temperatureUnitAsString()).add("WakeWord", (Object)this.wakeWordAsString()).add("Locale", (Object)this.locale()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileArn": {
                return Optional.ofNullable(clazz.cast(this.profileArn()));
            }
            case "ProfileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "DistanceUnit": {
                return Optional.ofNullable(clazz.cast(this.distanceUnitAsString()));
            }
            case "TemperatureUnit": {
                return Optional.ofNullable(clazz.cast(this.temperatureUnitAsString()));
            }
            case "WakeWord": {
                return Optional.ofNullable(clazz.cast(this.wakeWordAsString()));
            }
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProfileData, T> g) {
        return obj -> g.apply((ProfileData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String profileArn;
        private String profileName;
        private Boolean isDefault;
        private String address;
        private String timezone;
        private String distanceUnit;
        private String temperatureUnit;
        private String wakeWord;
        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileData model) {
            this.profileArn(model.profileArn);
            this.profileName(model.profileName);
            this.isDefault(model.isDefault);
            this.address(model.address);
            this.timezone(model.timezone);
            this.distanceUnit(model.distanceUnit);
            this.temperatureUnit(model.temperatureUnit);
            this.wakeWord(model.wakeWord);
            this.locale(model.locale);
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        public final String getProfileName() {
            return this.profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public final String getAddress() {
            return this.address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public final String getDistanceUnitAsString() {
            return this.distanceUnit;
        }

        @Override
        public final Builder distanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
            return this;
        }

        @Override
        public final Builder distanceUnit(DistanceUnit distanceUnit) {
            this.distanceUnit(distanceUnit == null ? null : distanceUnit.toString());
            return this;
        }

        public final void setDistanceUnit(String distanceUnit) {
            this.distanceUnit = distanceUnit;
        }

        public final String getTemperatureUnitAsString() {
            return this.temperatureUnit;
        }

        @Override
        public final Builder temperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
            return this;
        }

        @Override
        public final Builder temperatureUnit(TemperatureUnit temperatureUnit) {
            this.temperatureUnit(temperatureUnit == null ? null : temperatureUnit.toString());
            return this;
        }

        public final void setTemperatureUnit(String temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
        }

        public final String getWakeWordAsString() {
            return this.wakeWord;
        }

        @Override
        public final Builder wakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
            return this;
        }

        @Override
        public final Builder wakeWord(WakeWord wakeWord) {
            this.wakeWord(wakeWord == null ? null : wakeWord.toString());
            return this;
        }

        public final void setWakeWord(String wakeWord) {
            this.wakeWord = wakeWord;
        }

        public final String getLocale() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public ProfileData build() {
            return new ProfileData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProfileData> {
        public Builder profileArn(String var1);

        public Builder profileName(String var1);

        public Builder isDefault(Boolean var1);

        public Builder address(String var1);

        public Builder timezone(String var1);

        public Builder distanceUnit(String var1);

        public Builder distanceUnit(DistanceUnit var1);

        public Builder temperatureUnit(String var1);

        public Builder temperatureUnit(TemperatureUnit var1);

        public Builder wakeWord(String var1);

        public Builder wakeWord(WakeWord var1);

        public Builder locale(String var1);
    }
}

