/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeviceEventsRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<ListDeviceEventsRequest.Builder, ListDeviceEventsRequest> {
    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDeviceEventsRequest::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceArn").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDeviceEventsRequest::eventTypeAsString)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDeviceEventsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListDeviceEventsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ARN_FIELD,
            EVENT_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String deviceArn;

    private final String eventType;

    private final String nextToken;

    private final Integer maxResults;

    private ListDeviceEventsRequest(BuilderImpl builder) {
        super(builder);
        this.deviceArn = builder.deviceArn;
        this.eventType = builder.eventType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ARN of a device.
     * </p>
     * 
     * @return The ARN of a device.
     */
    public String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The event type to filter device events. If EventType isn't specified, this returns a list of all device events in
     * reverse chronological order. If EventType is specified, this returns a list of device events for that EventType
     * in reverse chronological order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link DeviceEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The event type to filter device events. If EventType isn't specified, this returns a list of all device
     *         events in reverse chronological order. If EventType is specified, this returns a list of device events
     *         for that EventType in reverse chronological order.
     * @see DeviceEventType
     */
    public DeviceEventType eventType() {
        return DeviceEventType.fromValue(eventType);
    }

    /**
     * <p>
     * The event type to filter device events. If EventType isn't specified, this returns a list of all device events in
     * reverse chronological order. If EventType is specified, this returns a list of device events for that EventType
     * in reverse chronological order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link DeviceEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The event type to filter device events. If EventType isn't specified, this returns a list of all device
     *         events in reverse chronological order. If EventType is specified, this returns a list of device events
     *         for that EventType in reverse chronological order.
     * @see DeviceEventType
     */
    public String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * An optional token returned from a prior request. Use this token for pagination of results from this action. If
     * this parameter is specified, the response only includes results beyond the token, up to the value specified by
     * MaxResults. When the end of results is reached, the response has a value of null.
     * </p>
     * 
     * @return An optional token returned from a prior request. Use this token for pagination of results from this
     *         action. If this parameter is specified, the response only includes results beyond the token, up to the
     *         value specified by MaxResults. When the end of results is reached, the response has a value of null.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to include in the response. The default value is 50. If more results exist than the
     * specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.
     * </p>
     * 
     * @return The maximum number of results to include in the response. The default value is 50. If more results exist
     *         than the specified MaxResults value, a token is included in the response so that the remaining results
     *         can be retrieved.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceEventsRequest)) {
            return false;
        }
        ListDeviceEventsRequest other = (ListDeviceEventsRequest) obj;
        return Objects.equals(deviceArn(), other.deviceArn()) && Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDeviceEventsRequest").add("DeviceArn", deviceArn()).add("EventType", eventTypeAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "EventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceEventsRequest, T> g) {
        return obj -> g.apply((ListDeviceEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDeviceEventsRequest> {
        /**
         * <p>
         * The ARN of a device.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of a device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The event type to filter device events. If EventType isn't specified, this returns a list of all device
         * events in reverse chronological order. If EventType is specified, this returns a list of device events for
         * that EventType in reverse chronological order.
         * </p>
         * 
         * @param eventType
         *        The event type to filter device events. If EventType isn't specified, this returns a list of all
         *        device events in reverse chronological order. If EventType is specified, this returns a list of device
         *        events for that EventType in reverse chronological order.
         * @see DeviceEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceEventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The event type to filter device events. If EventType isn't specified, this returns a list of all device
         * events in reverse chronological order. If EventType is specified, this returns a list of device events for
         * that EventType in reverse chronological order.
         * </p>
         * 
         * @param eventType
         *        The event type to filter device events. If EventType isn't specified, this returns a list of all
         *        device events in reverse chronological order. If EventType is specified, this returns a list of device
         *        events for that EventType in reverse chronological order.
         * @see DeviceEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceEventType
         */
        Builder eventType(DeviceEventType eventType);

        /**
         * <p>
         * An optional token returned from a prior request. Use this token for pagination of results from this action.
         * If this parameter is specified, the response only includes results beyond the token, up to the value
         * specified by MaxResults. When the end of results is reached, the response has a value of null.
         * </p>
         * 
         * @param nextToken
         *        An optional token returned from a prior request. Use this token for pagination of results from this
         *        action. If this parameter is specified, the response only includes results beyond the token, up to the
         *        value specified by MaxResults. When the end of results is reached, the response has a value of null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to include in the response. The default value is 50. If more results exist than
         * the specified MaxResults value, a token is included in the response so that the remaining results can be
         * retrieved.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to include in the response. The default value is 50. If more results
         *        exist than the specified MaxResults value, a token is included in the response so that the remaining
         *        results can be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String deviceArn;

        private String eventType;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceEventsRequest model) {
            super(model);
            deviceArn(model.deviceArn);
            eventType(model.eventType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        public final String getEventTypeAsString() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(DeviceEventType eventType) {
            this.eventType(eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeviceEventsRequest build() {
            return new ListDeviceEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
