/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.NetworkEapMethod;
import software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkProfileData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkProfileData> {
    private static final SdkField<String> NETWORK_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkProfileData.getter(NetworkProfileData::networkProfileArn)).setter(NetworkProfileData.setter(Builder::networkProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfileArn").build()}).build();
    private static final SdkField<String> NETWORK_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkProfileData.getter(NetworkProfileData::networkProfileName)).setter(NetworkProfileData.setter(Builder::networkProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfileName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkProfileData.getter(NetworkProfileData::description)).setter(NetworkProfileData.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SSID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkProfileData.getter(NetworkProfileData::ssid)).setter(NetworkProfileData.setter(Builder::ssid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ssid").build()}).build();
    private static final SdkField<String> SECURITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkProfileData.getter(NetworkProfileData::securityTypeAsString)).setter(NetworkProfileData.setter(Builder::securityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityType").build()}).build();
    private static final SdkField<String> EAP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkProfileData.getter(NetworkProfileData::eapMethodAsString)).setter(NetworkProfileData.setter(Builder::eapMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EapMethod").build()}).build();
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkProfileData.getter(NetworkProfileData::certificateAuthorityArn)).setter(NetworkProfileData.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PROFILE_ARN_FIELD, NETWORK_PROFILE_NAME_FIELD, DESCRIPTION_FIELD, SSID_FIELD, SECURITY_TYPE_FIELD, EAP_METHOD_FIELD, CERTIFICATE_AUTHORITY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String networkProfileArn;
    private final String networkProfileName;
    private final String description;
    private final String ssid;
    private final String securityType;
    private final String eapMethod;
    private final String certificateAuthorityArn;

    private NetworkProfileData(BuilderImpl builder) {
        this.networkProfileArn = builder.networkProfileArn;
        this.networkProfileName = builder.networkProfileName;
        this.description = builder.description;
        this.ssid = builder.ssid;
        this.securityType = builder.securityType;
        this.eapMethod = builder.eapMethod;
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
    }

    public String networkProfileArn() {
        return this.networkProfileArn;
    }

    public String networkProfileName() {
        return this.networkProfileName;
    }

    public String description() {
        return this.description;
    }

    public String ssid() {
        return this.ssid;
    }

    public NetworkSecurityType securityType() {
        return NetworkSecurityType.fromValue(this.securityType);
    }

    public String securityTypeAsString() {
        return this.securityType;
    }

    public NetworkEapMethod eapMethod() {
        return NetworkEapMethod.fromValue(this.eapMethod);
    }

    public String eapMethodAsString() {
        return this.eapMethod;
    }

    public String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssid());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eapMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkProfileData)) {
            return false;
        }
        NetworkProfileData other = (NetworkProfileData)obj;
        return Objects.equals(this.networkProfileArn(), other.networkProfileArn()) && Objects.equals(this.networkProfileName(), other.networkProfileName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ssid(), other.ssid()) && Objects.equals(this.securityTypeAsString(), other.securityTypeAsString()) && Objects.equals(this.eapMethodAsString(), other.eapMethodAsString()) && Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn());
    }

    public String toString() {
        return ToString.builder((String)"NetworkProfileData").add("NetworkProfileArn", (Object)this.networkProfileArn()).add("NetworkProfileName", (Object)this.networkProfileName()).add("Description", (Object)this.description()).add("Ssid", (Object)this.ssid()).add("SecurityType", (Object)this.securityTypeAsString()).add("EapMethod", (Object)this.eapMethodAsString()).add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkProfileArn": {
                return Optional.ofNullable(clazz.cast(this.networkProfileArn()));
            }
            case "NetworkProfileName": {
                return Optional.ofNullable(clazz.cast(this.networkProfileName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Ssid": {
                return Optional.ofNullable(clazz.cast(this.ssid()));
            }
            case "SecurityType": {
                return Optional.ofNullable(clazz.cast(this.securityTypeAsString()));
            }
            case "EapMethod": {
                return Optional.ofNullable(clazz.cast(this.eapMethodAsString()));
            }
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkProfileData, T> g) {
        return obj -> g.apply((NetworkProfileData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkProfileArn;
        private String networkProfileName;
        private String description;
        private String ssid;
        private String securityType;
        private String eapMethod;
        private String certificateAuthorityArn;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkProfileData model) {
            this.networkProfileArn(model.networkProfileArn);
            this.networkProfileName(model.networkProfileName);
            this.description(model.description);
            this.ssid(model.ssid);
            this.securityType(model.securityType);
            this.eapMethod(model.eapMethod);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
        }

        public final String getNetworkProfileArn() {
            return this.networkProfileArn;
        }

        @Override
        public final Builder networkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
            return this;
        }

        public final void setNetworkProfileArn(String networkProfileArn) {
            this.networkProfileArn = networkProfileArn;
        }

        public final String getNetworkProfileName() {
            return this.networkProfileName;
        }

        @Override
        public final Builder networkProfileName(String networkProfileName) {
            this.networkProfileName = networkProfileName;
            return this;
        }

        public final void setNetworkProfileName(String networkProfileName) {
            this.networkProfileName = networkProfileName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSsid() {
            return this.ssid;
        }

        @Override
        public final Builder ssid(String ssid) {
            this.ssid = ssid;
            return this;
        }

        public final void setSsid(String ssid) {
            this.ssid = ssid;
        }

        public final String getSecurityTypeAsString() {
            return this.securityType;
        }

        @Override
        public final Builder securityType(String securityType) {
            this.securityType = securityType;
            return this;
        }

        @Override
        public final Builder securityType(NetworkSecurityType securityType) {
            this.securityType(securityType.toString());
            return this;
        }

        public final void setSecurityType(String securityType) {
            this.securityType = securityType;
        }

        public final String getEapMethodAsString() {
            return this.eapMethod;
        }

        @Override
        public final Builder eapMethod(String eapMethod) {
            this.eapMethod = eapMethod;
            return this;
        }

        @Override
        public final Builder eapMethod(NetworkEapMethod eapMethod) {
            this.eapMethod(eapMethod.toString());
            return this;
        }

        public final void setEapMethod(String eapMethod) {
            this.eapMethod = eapMethod;
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        public NetworkProfileData build() {
            return new NetworkProfileData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkProfileData> {
        public Builder networkProfileArn(String var1);

        public Builder networkProfileName(String var1);

        public Builder description(String var1);

        public Builder ssid(String var1);

        public Builder securityType(String var1);

        public Builder securityType(NetworkSecurityType var1);

        public Builder eapMethod(String var1);

        public Builder eapMethod(NetworkEapMethod var1);

        public Builder certificateAuthorityArn(String var1);
    }
}

