/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBusinessReportScheduleRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<CreateBusinessReportScheduleRequest.Builder, CreateBusinessReportScheduleRequest> {
    private static final SdkField<String> SCHEDULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBusinessReportScheduleRequest::scheduleName)).setter(setter(Builder::scheduleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleName").build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBusinessReportScheduleRequest::s3BucketName)).setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBusinessReportScheduleRequest::s3KeyPrefix)).setter(setter(Builder::s3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBusinessReportScheduleRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<BusinessReportContentRange> CONTENT_RANGE_FIELD = SdkField
            .<BusinessReportContentRange> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateBusinessReportScheduleRequest::contentRange)).setter(setter(Builder::contentRange))
            .constructor(BusinessReportContentRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRange").build()).build();

    private static final SdkField<BusinessReportRecurrence> RECURRENCE_FIELD = SdkField
            .<BusinessReportRecurrence> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateBusinessReportScheduleRequest::recurrence)).setter(setter(Builder::recurrence))
            .constructor(BusinessReportRecurrence::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBusinessReportScheduleRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_NAME_FIELD,
            S3_BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD, FORMAT_FIELD, CONTENT_RANGE_FIELD, RECURRENCE_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD));

    private final String scheduleName;

    private final String s3BucketName;

    private final String s3KeyPrefix;

    private final String format;

    private final BusinessReportContentRange contentRange;

    private final BusinessReportRecurrence recurrence;

    private final String clientRequestToken;

    private CreateBusinessReportScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.scheduleName = builder.scheduleName;
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.format = builder.format;
        this.contentRange = builder.contentRange;
        this.recurrence = builder.recurrence;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name identifier of the schedule.
     * </p>
     * 
     * @return The name identifier of the schedule.
     */
    public String scheduleName() {
        return scheduleName;
    }

    /**
     * <p>
     * The S3 bucket name of the output reports. If this isn't specified, the report can be retrieved from a download
     * link by calling ListBusinessReportSchedule.
     * </p>
     * 
     * @return The S3 bucket name of the output reports. If this isn't specified, the report can be retrieved from a
     *         download link by calling ListBusinessReportSchedule.
     */
    public String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The S3 key where the report is delivered.
     * </p>
     * 
     * @return The S3 key where the report is delivered.
     */
    public String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    /**
     * <p>
     * The format of the generated report (individual CSV files or zipped files of individual files).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link BusinessReportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the generated report (individual CSV files or zipped files of individual files).
     * @see BusinessReportFormat
     */
    public BusinessReportFormat format() {
        return BusinessReportFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the generated report (individual CSV files or zipped files of individual files).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link BusinessReportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the generated report (individual CSV files or zipped files of individual files).
     * @see BusinessReportFormat
     */
    public String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The content range of the reports.
     * </p>
     * 
     * @return The content range of the reports.
     */
    public BusinessReportContentRange contentRange() {
        return contentRange;
    }

    /**
     * <p>
     * The recurrence of the reports. If this isn't specified, the report will only be delivered one time when the API
     * is called.
     * </p>
     * 
     * @return The recurrence of the reports. If this isn't specified, the report will only be delivered one time when
     *         the API is called.
     */
    public BusinessReportRecurrence recurrence() {
        return recurrence;
    }

    /**
     * <p>
     * The client request token.
     * </p>
     * 
     * @return The client request token.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentRange());
        hashCode = 31 * hashCode + Objects.hashCode(recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBusinessReportScheduleRequest)) {
            return false;
        }
        CreateBusinessReportScheduleRequest other = (CreateBusinessReportScheduleRequest) obj;
        return Objects.equals(scheduleName(), other.scheduleName()) && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(contentRange(), other.contentRange()) && Objects.equals(recurrence(), other.recurrence())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateBusinessReportScheduleRequest").add("ScheduleName", scheduleName())
                .add("S3BucketName", s3BucketName()).add("S3KeyPrefix", s3KeyPrefix()).add("Format", formatAsString())
                .add("ContentRange", contentRange()).add("Recurrence", recurrence())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleName":
            return Optional.ofNullable(clazz.cast(scheduleName()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3KeyPrefix":
            return Optional.ofNullable(clazz.cast(s3KeyPrefix()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "ContentRange":
            return Optional.ofNullable(clazz.cast(contentRange()));
        case "Recurrence":
            return Optional.ofNullable(clazz.cast(recurrence()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBusinessReportScheduleRequest, T> g) {
        return obj -> g.apply((CreateBusinessReportScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateBusinessReportScheduleRequest> {
        /**
         * <p>
         * The name identifier of the schedule.
         * </p>
         * 
         * @param scheduleName
         *        The name identifier of the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleName(String scheduleName);

        /**
         * <p>
         * The S3 bucket name of the output reports. If this isn't specified, the report can be retrieved from a
         * download link by calling ListBusinessReportSchedule.
         * </p>
         * 
         * @param s3BucketName
         *        The S3 bucket name of the output reports. If this isn't specified, the report can be retrieved from a
         *        download link by calling ListBusinessReportSchedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The S3 key where the report is delivered.
         * </p>
         * 
         * @param s3KeyPrefix
         *        The S3 key where the report is delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);

        /**
         * <p>
         * The format of the generated report (individual CSV files or zipped files of individual files).
         * </p>
         * 
         * @param format
         *        The format of the generated report (individual CSV files or zipped files of individual files).
         * @see BusinessReportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BusinessReportFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the generated report (individual CSV files or zipped files of individual files).
         * </p>
         * 
         * @param format
         *        The format of the generated report (individual CSV files or zipped files of individual files).
         * @see BusinessReportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BusinessReportFormat
         */
        Builder format(BusinessReportFormat format);

        /**
         * <p>
         * The content range of the reports.
         * </p>
         * 
         * @param contentRange
         *        The content range of the reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentRange(BusinessReportContentRange contentRange);

        /**
         * <p>
         * The content range of the reports.
         * </p>
         * This is a convenience that creates an instance of the {@link BusinessReportContentRange.Builder} avoiding the
         * need to create one manually via {@link BusinessReportContentRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link BusinessReportContentRange.Builder#build()} is called immediately
         * and its result is passed to {@link #contentRange(BusinessReportContentRange)}.
         * 
         * @param contentRange
         *        a consumer that will call methods on {@link BusinessReportContentRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentRange(BusinessReportContentRange)
         */
        default Builder contentRange(Consumer<BusinessReportContentRange.Builder> contentRange) {
            return contentRange(BusinessReportContentRange.builder().applyMutation(contentRange).build());
        }

        /**
         * <p>
         * The recurrence of the reports. If this isn't specified, the report will only be delivered one time when the
         * API is called.
         * </p>
         * 
         * @param recurrence
         *        The recurrence of the reports. If this isn't specified, the report will only be delivered one time
         *        when the API is called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(BusinessReportRecurrence recurrence);

        /**
         * <p>
         * The recurrence of the reports. If this isn't specified, the report will only be delivered one time when the
         * API is called.
         * </p>
         * This is a convenience that creates an instance of the {@link BusinessReportRecurrence.Builder} avoiding the
         * need to create one manually via {@link BusinessReportRecurrence#builder()}.
         *
         * When the {@link Consumer} completes, {@link BusinessReportRecurrence.Builder#build()} is called immediately
         * and its result is passed to {@link #recurrence(BusinessReportRecurrence)}.
         * 
         * @param recurrence
         *        a consumer that will call methods on {@link BusinessReportRecurrence.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurrence(BusinessReportRecurrence)
         */
        default Builder recurrence(Consumer<BusinessReportRecurrence.Builder> recurrence) {
            return recurrence(BusinessReportRecurrence.builder().applyMutation(recurrence).build());
        }

        /**
         * <p>
         * The client request token.
         * </p>
         * 
         * @param clientRequestToken
         *        The client request token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String scheduleName;

        private String s3BucketName;

        private String s3KeyPrefix;

        private String format;

        private BusinessReportContentRange contentRange;

        private BusinessReportRecurrence recurrence;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBusinessReportScheduleRequest model) {
            super(model);
            scheduleName(model.scheduleName);
            s3BucketName(model.s3BucketName);
            s3KeyPrefix(model.s3KeyPrefix);
            format(model.format);
            contentRange(model.contentRange);
            recurrence(model.recurrence);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getScheduleName() {
            return scheduleName;
        }

        @Override
        public final Builder scheduleName(String scheduleName) {
            this.scheduleName = scheduleName;
            return this;
        }

        public final void setScheduleName(String scheduleName) {
            this.scheduleName = scheduleName;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getFormatAsString() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(BusinessReportFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final BusinessReportContentRange.Builder getContentRange() {
            return contentRange != null ? contentRange.toBuilder() : null;
        }

        @Override
        public final Builder contentRange(BusinessReportContentRange contentRange) {
            this.contentRange = contentRange;
            return this;
        }

        public final void setContentRange(BusinessReportContentRange.BuilderImpl contentRange) {
            this.contentRange = contentRange != null ? contentRange.build() : null;
        }

        public final BusinessReportRecurrence.Builder getRecurrence() {
            return recurrence != null ? recurrence.toBuilder() : null;
        }

        @Override
        public final Builder recurrence(BusinessReportRecurrence recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(BusinessReportRecurrence.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBusinessReportScheduleRequest build() {
            return new CreateBusinessReportScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
