/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.Locale;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ssml
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ssml> {
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Ssml.getter(Ssml::localeAsString)).setter(Ssml.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Ssml.getter(Ssml::value)).setter(Ssml.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCALE_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String locale;
    private final String value;

    private Ssml(BuilderImpl builder) {
        this.locale = builder.locale;
        this.value = builder.value;
    }

    public Locale locale() {
        return Locale.fromValue(this.locale);
    }

    public String localeAsString() {
        return this.locale;
    }

    public String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ssml)) {
            return false;
        }
        Ssml other = (Ssml)obj;
        return Objects.equals(this.localeAsString(), other.localeAsString()) && Objects.equals(this.value(), other.value());
    }

    public String toString() {
        return ToString.builder((String)"Ssml").add("Locale", (Object)this.localeAsString()).add("Value", (Object)this.value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.localeAsString()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ssml, T> g) {
        return obj -> g.apply((Ssml)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String locale;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Ssml model) {
            this.locale(model.locale);
            this.value(model.value);
        }

        public final String getLocaleAsString() {
            return this.locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale.toString());
            return this;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public Ssml build() {
            return new Ssml(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ssml> {
        public Builder locale(String var1);

        public Builder locale(Locale var1);

        public Builder value(String var1);
    }
}

