/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ShortSkillIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInvitationConfigurationResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, GetInvitationConfigurationResponse> {
    private static final SdkField<String> ORGANIZATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetInvitationConfigurationResponse.getter(GetInvitationConfigurationResponse::organizationName)).setter(GetInvitationConfigurationResponse.setter(Builder::organizationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationName").build()}).build();
    private static final SdkField<String> CONTACT_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetInvitationConfigurationResponse.getter(GetInvitationConfigurationResponse::contactEmail)).setter(GetInvitationConfigurationResponse.setter(Builder::contactEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactEmail").build()}).build();
    private static final SdkField<List<String>> PRIVATE_SKILL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetInvitationConfigurationResponse.getter(GetInvitationConfigurationResponse::privateSkillIds)).setter(GetInvitationConfigurationResponse.setter(Builder::privateSkillIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateSkillIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_NAME_FIELD, CONTACT_EMAIL_FIELD, PRIVATE_SKILL_IDS_FIELD));
    private final String organizationName;
    private final String contactEmail;
    private final List<String> privateSkillIds;

    private GetInvitationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.organizationName = builder.organizationName;
        this.contactEmail = builder.contactEmail;
        this.privateSkillIds = builder.privateSkillIds;
    }

    public String organizationName() {
        return this.organizationName;
    }

    public String contactEmail() {
        return this.contactEmail;
    }

    public List<String> privateSkillIds() {
        return this.privateSkillIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateSkillIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInvitationConfigurationResponse)) {
            return false;
        }
        GetInvitationConfigurationResponse other = (GetInvitationConfigurationResponse)((Object)obj);
        return Objects.equals(this.organizationName(), other.organizationName()) && Objects.equals(this.contactEmail(), other.contactEmail()) && Objects.equals(this.privateSkillIds(), other.privateSkillIds());
    }

    public String toString() {
        return ToString.builder((String)"GetInvitationConfigurationResponse").add("OrganizationName", (Object)this.organizationName()).add("ContactEmail", (Object)this.contactEmail()).add("PrivateSkillIds", this.privateSkillIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationName": {
                return Optional.ofNullable(clazz.cast(this.organizationName()));
            }
            case "ContactEmail": {
                return Optional.ofNullable(clazz.cast(this.contactEmail()));
            }
            case "PrivateSkillIds": {
                return Optional.ofNullable(clazz.cast(this.privateSkillIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInvitationConfigurationResponse, T> g) {
        return obj -> g.apply((GetInvitationConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private String organizationName;
        private String contactEmail;
        private List<String> privateSkillIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetInvitationConfigurationResponse model) {
            super(model);
            this.organizationName(model.organizationName);
            this.contactEmail(model.contactEmail);
            this.privateSkillIds(model.privateSkillIds);
        }

        public final String getOrganizationName() {
            return this.organizationName;
        }

        @Override
        public final Builder organizationName(String organizationName) {
            this.organizationName = organizationName;
            return this;
        }

        public final void setOrganizationName(String organizationName) {
            this.organizationName = organizationName;
        }

        public final String getContactEmail() {
            return this.contactEmail;
        }

        @Override
        public final Builder contactEmail(String contactEmail) {
            this.contactEmail = contactEmail;
            return this;
        }

        public final void setContactEmail(String contactEmail) {
            this.contactEmail = contactEmail;
        }

        public final Collection<String> getPrivateSkillIds() {
            return this.privateSkillIds;
        }

        @Override
        public final Builder privateSkillIds(Collection<String> privateSkillIds) {
            this.privateSkillIds = ShortSkillIdListCopier.copy(privateSkillIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateSkillIds(String ... privateSkillIds) {
            this.privateSkillIds(Arrays.asList(privateSkillIds));
            return this;
        }

        public final void setPrivateSkillIds(Collection<String> privateSkillIds) {
            this.privateSkillIds = ShortSkillIdListCopier.copy(privateSkillIds);
        }

        @Override
        public GetInvitationConfigurationResponse build() {
            return new GetInvitationConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInvitationConfigurationResponse> {
        public Builder organizationName(String var1);

        public Builder contactEmail(String var1);

        public Builder privateSkillIds(Collection<String> var1);

        public Builder privateSkillIds(String ... var1);
    }
}

