/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.alexaforbusiness.model.ApproveSkillRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ApproveSkillResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateContactWithAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateContactWithAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithNetworkProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithNetworkProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateDeviceWithRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillGroupWithRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.AssociateSkillWithUsersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateNetworkProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateUserRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.CreateUserResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteBusinessReportScheduleRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteBusinessReportScheduleResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceUsageDataRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteDeviceUsageDataResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteNetworkProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteNetworkProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillAuthorizationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillAuthorizationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DeleteUserResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateContactFromAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateContactFromAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateDeviceFromRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromUsersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillGroupFromRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ForgetSmartHomeAppliancesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ForgetSmartHomeAppliancesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferencePreferenceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferencePreferenceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetInvitationConfigurationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetInvitationConfigurationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetNetworkProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetNetworkProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.PutConferencePreferenceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutConferencePreferenceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.PutInvitationConfigurationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutInvitationConfigurationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.PutSkillAuthorizationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PutSkillAuthorizationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.RegisterAvsDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.RejectSkillRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.RejectSkillResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.RevokeInvitationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SendAnnouncementResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SendInvitationResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.StartDeviceSyncResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.TagResourceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.TagResourceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UntagResourceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateAddressBookRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateAddressBookResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateBusinessReportScheduleRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateBusinessReportScheduleResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateConferenceProviderRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateConferenceProviderResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateContactRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateContactResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateNetworkProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateNetworkProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateProfileResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateSkillGroupRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.UpdateSkillGroupResponse;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchNetworkProfilesPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsPublisher;
import software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersPublisher;

/**
 * Service client for accessing Alexa For Business asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Alexa for Business helps you use Alexa in your organization. Alexa for Business provides you with the tools to manage
 * Alexa devices, enroll your users, and assign skills, at scale. You can build your own context-aware voice skills
 * using the Alexa Skills Kit and the Alexa for Business API operations. You can also make these available as private
 * skills for your organization. Alexa for Business makes it efficient to voice-enable your products and services, thus
 * providing context-aware voice experiences for your customers. Device makers building with the Alexa Voice Service
 * (AVS) can create fully integrated solutions, register their products with Alexa for Business, and manage them as
 * shared devices in their organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface AlexaForBusinessAsyncClient extends SdkClient {
    String SERVICE_NAME = "a4b";

    /**
     * Create a {@link AlexaForBusinessAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AlexaForBusinessAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AlexaForBusinessAsyncClient}.
     */
    static AlexaForBusinessAsyncClientBuilder builder() {
        return new DefaultAlexaForBusinessAsyncClientBuilder();
    }

    /**
     * <p>
     * Associates a skill with the organization under the customer's AWS account. If a skill is private, the user
     * implicitly accepts access to this skill during enablement.
     * </p>
     *
     * @param approveSkillRequest
     * @return A Java Future containing the result of the ApproveSkill operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ApproveSkill
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ApproveSkill" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ApproveSkillResponse> approveSkill(ApproveSkillRequest approveSkillRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a skill with the organization under the customer's AWS account. If a skill is private, the user
     * implicitly accepts access to this skill during enablement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApproveSkillRequest.Builder} avoiding the need to
     * create one manually via {@link ApproveSkillRequest#builder()}
     * </p>
     *
     * @param approveSkillRequest
     *        A {@link Consumer} that will call methods on {@link ApproveSkillRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ApproveSkill operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ApproveSkill
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ApproveSkill" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ApproveSkillResponse> approveSkill(Consumer<ApproveSkillRequest.Builder> approveSkillRequest) {
        return approveSkill(ApproveSkillRequest.builder().applyMutation(approveSkillRequest).build());
    }

    /**
     * <p>
     * Associates a contact with a given address book.
     * </p>
     *
     * @param associateContactWithAddressBookRequest
     * @return A Java Future containing the result of the AssociateContactWithAddressBook operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateContactWithAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateContactWithAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateContactWithAddressBookResponse> associateContactWithAddressBook(
            AssociateContactWithAddressBookRequest associateContactWithAddressBookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a contact with a given address book.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateContactWithAddressBookRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateContactWithAddressBookRequest#builder()}
     * </p>
     *
     * @param associateContactWithAddressBookRequest
     *        A {@link Consumer} that will call methods on {@link AssociateContactWithAddressBookRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateContactWithAddressBook operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateContactWithAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateContactWithAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateContactWithAddressBookResponse> associateContactWithAddressBook(
            Consumer<AssociateContactWithAddressBookRequest.Builder> associateContactWithAddressBookRequest) {
        return associateContactWithAddressBook(AssociateContactWithAddressBookRequest.builder()
                .applyMutation(associateContactWithAddressBookRequest).build());
    }

    /**
     * <p>
     * Associates a device with the specified network profile.
     * </p>
     *
     * @param associateDeviceWithNetworkProfileRequest
     * @return A Java Future containing the result of the AssociateDeviceWithNetworkProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateDeviceWithNetworkProfile
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateDeviceWithNetworkProfileResponse> associateDeviceWithNetworkProfile(
            AssociateDeviceWithNetworkProfileRequest associateDeviceWithNetworkProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a device with the specified network profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDeviceWithNetworkProfileRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateDeviceWithNetworkProfileRequest#builder()}
     * </p>
     *
     * @param associateDeviceWithNetworkProfileRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDeviceWithNetworkProfileRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateDeviceWithNetworkProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateDeviceWithNetworkProfile
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateDeviceWithNetworkProfileResponse> associateDeviceWithNetworkProfile(
            Consumer<AssociateDeviceWithNetworkProfileRequest.Builder> associateDeviceWithNetworkProfileRequest) {
        return associateDeviceWithNetworkProfile(AssociateDeviceWithNetworkProfileRequest.builder()
                .applyMutation(associateDeviceWithNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Associates a device with a given room. This applies all the settings from the room profile to the device, and all
     * the skills in any skill groups added to that room. This operation requires the device to be online, or else a
     * manual sync is required.
     * </p>
     *
     * @param associateDeviceWithRoomRequest
     * @return A Java Future containing the result of the AssociateDeviceWithRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateDeviceWithRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateDeviceWithRoomResponse> associateDeviceWithRoom(
            AssociateDeviceWithRoomRequest associateDeviceWithRoomRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a device with a given room. This applies all the settings from the room profile to the device, and all
     * the skills in any skill groups added to that room. This operation requires the device to be online, or else a
     * manual sync is required.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDeviceWithRoomRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateDeviceWithRoomRequest#builder()}
     * </p>
     *
     * @param associateDeviceWithRoomRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDeviceWithRoomRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateDeviceWithRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateDeviceWithRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateDeviceWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateDeviceWithRoomResponse> associateDeviceWithRoom(
            Consumer<AssociateDeviceWithRoomRequest.Builder> associateDeviceWithRoomRequest) {
        return associateDeviceWithRoom(AssociateDeviceWithRoomRequest.builder().applyMutation(associateDeviceWithRoomRequest)
                .build());
    }

    /**
     * <p>
     * Associates a skill group with a given room. This enables all skills in the associated skill group on all devices
     * in the room.
     * </p>
     *
     * @param associateSkillGroupWithRoomRequest
     * @return A Java Future containing the result of the AssociateSkillGroupWithRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateSkillGroupWithRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillGroupWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSkillGroupWithRoomResponse> associateSkillGroupWithRoom(
            AssociateSkillGroupWithRoomRequest associateSkillGroupWithRoomRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a skill group with a given room. This enables all skills in the associated skill group on all devices
     * in the room.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSkillGroupWithRoomRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateSkillGroupWithRoomRequest#builder()}
     * </p>
     *
     * @param associateSkillGroupWithRoomRequest
     *        A {@link Consumer} that will call methods on {@link AssociateSkillGroupWithRoomRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AssociateSkillGroupWithRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateSkillGroupWithRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillGroupWithRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSkillGroupWithRoomResponse> associateSkillGroupWithRoom(
            Consumer<AssociateSkillGroupWithRoomRequest.Builder> associateSkillGroupWithRoomRequest) {
        return associateSkillGroupWithRoom(AssociateSkillGroupWithRoomRequest.builder()
                .applyMutation(associateSkillGroupWithRoomRequest).build());
    }

    /**
     * <p>
     * Associates a skill with a skill group.
     * </p>
     *
     * @param associateSkillWithSkillGroupRequest
     * @return A Java Future containing the result of the AssociateSkillWithSkillGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SkillNotLinkedException The skill must be linked to a third-party account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateSkillWithSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSkillWithSkillGroupResponse> associateSkillWithSkillGroup(
            AssociateSkillWithSkillGroupRequest associateSkillWithSkillGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a skill with a skill group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSkillWithSkillGroupRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateSkillWithSkillGroupRequest#builder()}
     * </p>
     *
     * @param associateSkillWithSkillGroupRequest
     *        A {@link Consumer} that will call methods on {@link AssociateSkillWithSkillGroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AssociateSkillWithSkillGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SkillNotLinkedException The skill must be linked to a third-party account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateSkillWithSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSkillWithSkillGroupResponse> associateSkillWithSkillGroup(
            Consumer<AssociateSkillWithSkillGroupRequest.Builder> associateSkillWithSkillGroupRequest) {
        return associateSkillWithSkillGroup(AssociateSkillWithSkillGroupRequest.builder()
                .applyMutation(associateSkillWithSkillGroupRequest).build());
    }

    /**
     * <p>
     * Makes a private skill available for enrolled users to enable on their devices.
     * </p>
     *
     * @param associateSkillWithUsersRequest
     * @return A Java Future containing the result of the AssociateSkillWithUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateSkillWithUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSkillWithUsersResponse> associateSkillWithUsers(
            AssociateSkillWithUsersRequest associateSkillWithUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Makes a private skill available for enrolled users to enable on their devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSkillWithUsersRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateSkillWithUsersRequest#builder()}
     * </p>
     *
     * @param associateSkillWithUsersRequest
     *        A {@link Consumer} that will call methods on {@link AssociateSkillWithUsersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateSkillWithUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.AssociateSkillWithUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateSkillWithUsersResponse> associateSkillWithUsers(
            Consumer<AssociateSkillWithUsersRequest.Builder> associateSkillWithUsersRequest) {
        return associateSkillWithUsers(AssociateSkillWithUsersRequest.builder().applyMutation(associateSkillWithUsersRequest)
                .build());
    }

    /**
     * <p>
     * Creates an address book with the specified details.
     * </p>
     *
     * @param createAddressBookRequest
     * @return A Java Future containing the result of the CreateAddressBook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAddressBookResponse> createAddressBook(CreateAddressBookRequest createAddressBookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an address book with the specified details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAddressBookRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAddressBookRequest#builder()}
     * </p>
     *
     * @param createAddressBookRequest
     *        A {@link Consumer} that will call methods on {@link CreateAddressBookRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAddressBook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAddressBookResponse> createAddressBook(
            Consumer<CreateAddressBookRequest.Builder> createAddressBookRequest) {
        return createAddressBook(CreateAddressBookRequest.builder().applyMutation(createAddressBookRequest).build());
    }

    /**
     * <p>
     * Creates a recurring schedule for usage reports to deliver to the specified S3 location with a specified daily or
     * weekly interval.
     * </p>
     *
     * @param createBusinessReportScheduleRequest
     * @return A Java Future containing the result of the CreateBusinessReportSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateBusinessReportSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBusinessReportScheduleResponse> createBusinessReportSchedule(
            CreateBusinessReportScheduleRequest createBusinessReportScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a recurring schedule for usage reports to deliver to the specified S3 location with a specified daily or
     * weekly interval.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBusinessReportScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link CreateBusinessReportScheduleRequest#builder()}
     * </p>
     *
     * @param createBusinessReportScheduleRequest
     *        A {@link Consumer} that will call methods on {@link CreateBusinessReportScheduleRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateBusinessReportSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateBusinessReportSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBusinessReportScheduleResponse> createBusinessReportSchedule(
            Consumer<CreateBusinessReportScheduleRequest.Builder> createBusinessReportScheduleRequest) {
        return createBusinessReportSchedule(CreateBusinessReportScheduleRequest.builder()
                .applyMutation(createBusinessReportScheduleRequest).build());
    }

    /**
     * <p>
     * Adds a new conference provider under the user's AWS account.
     * </p>
     *
     * @param createConferenceProviderRequest
     * @return A Java Future containing the result of the CreateConferenceProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConferenceProviderResponse> createConferenceProvider(
            CreateConferenceProviderRequest createConferenceProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new conference provider under the user's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConferenceProviderRequest.Builder} avoiding
     * the need to create one manually via {@link CreateConferenceProviderRequest#builder()}
     * </p>
     *
     * @param createConferenceProviderRequest
     *        A {@link Consumer} that will call methods on {@link CreateConferenceProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateConferenceProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConferenceProviderResponse> createConferenceProvider(
            Consumer<CreateConferenceProviderRequest.Builder> createConferenceProviderRequest) {
        return createConferenceProvider(CreateConferenceProviderRequest.builder().applyMutation(createConferenceProviderRequest)
                .build());
    }

    /**
     * <p>
     * Creates a contact with the specified details.
     * </p>
     *
     * @param createContactRequest
     * @return A Java Future containing the result of the CreateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateContactResponse> createContact(CreateContactRequest createContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a contact with the specified details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContactRequest.Builder} avoiding the need to
     * create one manually via {@link CreateContactRequest#builder()}
     * </p>
     *
     * @param createContactRequest
     *        A {@link Consumer} that will call methods on {@link CreateContactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateContactResponse> createContact(Consumer<CreateContactRequest.Builder> createContactRequest) {
        return createContact(CreateContactRequest.builder().applyMutation(createContactRequest).build());
    }

    /**
     * <p>
     * Creates a gateway group with the specified details.
     * </p>
     *
     * @param createGatewayGroupRequest
     * @return A Java Future containing the result of the CreateGatewayGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGatewayGroupResponse> createGatewayGroup(CreateGatewayGroupRequest createGatewayGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a gateway group with the specified details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGatewayGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGatewayGroupRequest#builder()}
     * </p>
     *
     * @param createGatewayGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGatewayGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGatewayGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGatewayGroupResponse> createGatewayGroup(
            Consumer<CreateGatewayGroupRequest.Builder> createGatewayGroupRequest) {
        return createGatewayGroup(CreateGatewayGroupRequest.builder().applyMutation(createGatewayGroupRequest).build());
    }

    /**
     * <p>
     * Creates a network profile with the specified details.
     * </p>
     *
     * @param createNetworkProfileRequest
     * @return A Java Future containing the result of the CreateNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>InvalidCertificateAuthorityException The Certificate Authority can't issue or revoke a certificate.</li>
     *         <li>InvalidServiceLinkedRoleStateException The service linked role is locked for deletion.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkProfileResponse> createNetworkProfile(
            CreateNetworkProfileRequest createNetworkProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network profile with the specified details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNetworkProfileRequest#builder()}
     * </p>
     *
     * @param createNetworkProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>InvalidCertificateAuthorityException The Certificate Authority can't issue or revoke a certificate.</li>
     *         <li>InvalidServiceLinkedRoleStateException The service linked role is locked for deletion.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkProfileResponse> createNetworkProfile(
            Consumer<CreateNetworkProfileRequest.Builder> createNetworkProfileRequest) {
        return createNetworkProfile(CreateNetworkProfileRequest.builder().applyMutation(createNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Creates a new room profile with the specified details.
     * </p>
     *
     * @param createProfileRequest
     * @return A Java Future containing the result of the CreateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateProfileResponse> createProfile(CreateProfileRequest createProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new room profile with the specified details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProfileRequest#builder()}
     * </p>
     *
     * @param createProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateProfileResponse> createProfile(Consumer<CreateProfileRequest.Builder> createProfileRequest) {
        return createProfile(CreateProfileRequest.builder().applyMutation(createProfileRequest).build());
    }

    /**
     * <p>
     * Creates a room with the specified details.
     * </p>
     *
     * @param createRoomRequest
     * @return A Java Future containing the result of the CreateRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRoomResponse> createRoom(CreateRoomRequest createRoomRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a room with the specified details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRoomRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRoomRequest#builder()}
     * </p>
     *
     * @param createRoomRequest
     *        A {@link Consumer} that will call methods on {@link CreateRoomRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRoomResponse> createRoom(Consumer<CreateRoomRequest.Builder> createRoomRequest) {
        return createRoom(CreateRoomRequest.builder().applyMutation(createRoomRequest).build());
    }

    /**
     * <p>
     * Creates a skill group with a specified name and description.
     * </p>
     *
     * @param createSkillGroupRequest
     * @return A Java Future containing the result of the CreateSkillGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSkillGroupResponse> createSkillGroup(CreateSkillGroupRequest createSkillGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a skill group with a specified name and description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSkillGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSkillGroupRequest#builder()}
     * </p>
     *
     * @param createSkillGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateSkillGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSkillGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSkillGroupResponse> createSkillGroup(
            Consumer<CreateSkillGroupRequest.Builder> createSkillGroupRequest) {
        return createSkillGroup(CreateSkillGroupRequest.builder().applyMutation(createSkillGroupRequest).build());
    }

    /**
     * <p>
     * Creates a user.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The resource in the request is already in use.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The resource in the request is already in use.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.CreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateUserResponse> createUser(Consumer<CreateUserRequest.Builder> createUserRequest) {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Deletes an address book by the address book ARN.
     * </p>
     *
     * @param deleteAddressBookRequest
     * @return A Java Future containing the result of the DeleteAddressBook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAddressBookResponse> deleteAddressBook(DeleteAddressBookRequest deleteAddressBookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an address book by the address book ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAddressBookRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAddressBookRequest#builder()}
     * </p>
     *
     * @param deleteAddressBookRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAddressBookRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAddressBook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAddressBookResponse> deleteAddressBook(
            Consumer<DeleteAddressBookRequest.Builder> deleteAddressBookRequest) {
        return deleteAddressBook(DeleteAddressBookRequest.builder().applyMutation(deleteAddressBookRequest).build());
    }

    /**
     * <p>
     * Deletes the recurring report delivery schedule with the specified schedule ARN.
     * </p>
     *
     * @param deleteBusinessReportScheduleRequest
     * @return A Java Future containing the result of the DeleteBusinessReportSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteBusinessReportSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBusinessReportScheduleResponse> deleteBusinessReportSchedule(
            DeleteBusinessReportScheduleRequest deleteBusinessReportScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the recurring report delivery schedule with the specified schedule ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBusinessReportScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteBusinessReportScheduleRequest#builder()}
     * </p>
     *
     * @param deleteBusinessReportScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBusinessReportScheduleRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteBusinessReportSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteBusinessReportSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBusinessReportScheduleResponse> deleteBusinessReportSchedule(
            Consumer<DeleteBusinessReportScheduleRequest.Builder> deleteBusinessReportScheduleRequest) {
        return deleteBusinessReportSchedule(DeleteBusinessReportScheduleRequest.builder()
                .applyMutation(deleteBusinessReportScheduleRequest).build());
    }

    /**
     * <p>
     * Deletes a conference provider.
     * </p>
     *
     * @param deleteConferenceProviderRequest
     * @return A Java Future containing the result of the DeleteConferenceProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConferenceProviderResponse> deleteConferenceProvider(
            DeleteConferenceProviderRequest deleteConferenceProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a conference provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConferenceProviderRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteConferenceProviderRequest#builder()}
     * </p>
     *
     * @param deleteConferenceProviderRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConferenceProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteConferenceProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConferenceProviderResponse> deleteConferenceProvider(
            Consumer<DeleteConferenceProviderRequest.Builder> deleteConferenceProviderRequest) {
        return deleteConferenceProvider(DeleteConferenceProviderRequest.builder().applyMutation(deleteConferenceProviderRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a contact by the contact ARN.
     * </p>
     *
     * @param deleteContactRequest
     * @return A Java Future containing the result of the DeleteContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteContactResponse> deleteContact(DeleteContactRequest deleteContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a contact by the contact ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContactRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteContactRequest#builder()}
     * </p>
     *
     * @param deleteContactRequest
     *        A {@link Consumer} that will call methods on {@link DeleteContactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteContactResponse> deleteContact(Consumer<DeleteContactRequest.Builder> deleteContactRequest) {
        return deleteContact(DeleteContactRequest.builder().applyMutation(deleteContactRequest).build());
    }

    /**
     * <p>
     * Removes a device from Alexa For Business.
     * </p>
     *
     * @param deleteDeviceRequest
     * @return A Java Future containing the result of the DeleteDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>InvalidCertificateAuthorityException The Certificate Authority can't issue or revoke a certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDeviceResponse> deleteDevice(DeleteDeviceRequest deleteDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a device from Alexa For Business.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDeviceRequest#builder()}
     * </p>
     *
     * @param deleteDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>InvalidCertificateAuthorityException The Certificate Authority can't issue or revoke a certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDeviceResponse> deleteDevice(Consumer<DeleteDeviceRequest.Builder> deleteDeviceRequest) {
        return deleteDevice(DeleteDeviceRequest.builder().applyMutation(deleteDeviceRequest).build());
    }

    /**
     * <p>
     * When this action is called for a specified shared device, it allows authorized users to delete the device's
     * entire previous history of voice input data and associated response data. This action can be called once every 24
     * hours for a specific shared device.
     * </p>
     *
     * @param deleteDeviceUsageDataRequest
     * @return A Java Future containing the result of the DeleteDeviceUsageData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteDeviceUsageData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDeviceUsageData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeviceUsageDataResponse> deleteDeviceUsageData(
            DeleteDeviceUsageDataRequest deleteDeviceUsageDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * When this action is called for a specified shared device, it allows authorized users to delete the device's
     * entire previous history of voice input data and associated response data. This action can be called once every 24
     * hours for a specific shared device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceUsageDataRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDeviceUsageDataRequest#builder()}
     * </p>
     *
     * @param deleteDeviceUsageDataRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDeviceUsageDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDeviceUsageData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteDeviceUsageData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteDeviceUsageData"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDeviceUsageDataResponse> deleteDeviceUsageData(
            Consumer<DeleteDeviceUsageDataRequest.Builder> deleteDeviceUsageDataRequest) {
        return deleteDeviceUsageData(DeleteDeviceUsageDataRequest.builder().applyMutation(deleteDeviceUsageDataRequest).build());
    }

    /**
     * <p>
     * Deletes a gateway group.
     * </p>
     *
     * @param deleteGatewayGroupRequest
     * @return A Java Future containing the result of the DeleteGatewayGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAssociatedException Another resource is associated with the resource in the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGatewayGroupResponse> deleteGatewayGroup(DeleteGatewayGroupRequest deleteGatewayGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a gateway group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGatewayGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGatewayGroupRequest#builder()}
     * </p>
     *
     * @param deleteGatewayGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGatewayGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGatewayGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceAssociatedException Another resource is associated with the resource in the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGatewayGroupResponse> deleteGatewayGroup(
            Consumer<DeleteGatewayGroupRequest.Builder> deleteGatewayGroupRequest) {
        return deleteGatewayGroup(DeleteGatewayGroupRequest.builder().applyMutation(deleteGatewayGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a network profile by the network profile ARN.
     * </p>
     *
     * @param deleteNetworkProfileRequest
     * @return A Java Future containing the result of the DeleteNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The resource in the request is already in use.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkProfileResponse> deleteNetworkProfile(
            DeleteNetworkProfileRequest deleteNetworkProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a network profile by the network profile ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNetworkProfileRequest#builder()}
     * </p>
     *
     * @param deleteNetworkProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNetworkProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException The resource in the request is already in use.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkProfileResponse> deleteNetworkProfile(
            Consumer<DeleteNetworkProfileRequest.Builder> deleteNetworkProfileRequest) {
        return deleteNetworkProfile(DeleteNetworkProfileRequest.builder().applyMutation(deleteNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a room profile by the profile ARN.
     * </p>
     *
     * @param deleteProfileRequest
     * @return A Java Future containing the result of the DeleteProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteProfileResponse> deleteProfile(DeleteProfileRequest deleteProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a room profile by the profile ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProfileRequest#builder()}
     * </p>
     *
     * @param deleteProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteProfileResponse> deleteProfile(Consumer<DeleteProfileRequest.Builder> deleteProfileRequest) {
        return deleteProfile(DeleteProfileRequest.builder().applyMutation(deleteProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a room by the room ARN.
     * </p>
     *
     * @param deleteRoomRequest
     * @return A Java Future containing the result of the DeleteRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRoomResponse> deleteRoom(DeleteRoomRequest deleteRoomRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a room by the room ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRoomRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRoomRequest#builder()}
     * </p>
     *
     * @param deleteRoomRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRoomRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRoomResponse> deleteRoom(Consumer<DeleteRoomRequest.Builder> deleteRoomRequest) {
        return deleteRoom(DeleteRoomRequest.builder().applyMutation(deleteRoomRequest).build());
    }

    /**
     * <p>
     * Deletes room skill parameter details by room, skill, and parameter key ID.
     * </p>
     *
     * @param deleteRoomSkillParameterRequest
     * @return A Java Future containing the result of the DeleteRoomSkillParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRoomSkillParameterResponse> deleteRoomSkillParameter(
            DeleteRoomSkillParameterRequest deleteRoomSkillParameterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes room skill parameter details by room, skill, and parameter key ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRoomSkillParameterRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteRoomSkillParameterRequest#builder()}
     * </p>
     *
     * @param deleteRoomSkillParameterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRoomSkillParameterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRoomSkillParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRoomSkillParameterResponse> deleteRoomSkillParameter(
            Consumer<DeleteRoomSkillParameterRequest.Builder> deleteRoomSkillParameterRequest) {
        return deleteRoomSkillParameter(DeleteRoomSkillParameterRequest.builder().applyMutation(deleteRoomSkillParameterRequest)
                .build());
    }

    /**
     * <p>
     * Unlinks a third-party account from a skill.
     * </p>
     *
     * @param deleteSkillAuthorizationRequest
     * @return A Java Future containing the result of the DeleteSkillAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteSkillAuthorization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSkillAuthorizationResponse> deleteSkillAuthorization(
            DeleteSkillAuthorizationRequest deleteSkillAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Unlinks a third-party account from a skill.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSkillAuthorizationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSkillAuthorizationRequest#builder()}
     * </p>
     *
     * @param deleteSkillAuthorizationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSkillAuthorizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSkillAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteSkillAuthorization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSkillAuthorizationResponse> deleteSkillAuthorization(
            Consumer<DeleteSkillAuthorizationRequest.Builder> deleteSkillAuthorizationRequest) {
        return deleteSkillAuthorization(DeleteSkillAuthorizationRequest.builder().applyMutation(deleteSkillAuthorizationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a skill group by skill group ARN.
     * </p>
     *
     * @param deleteSkillGroupRequest
     * @return A Java Future containing the result of the DeleteSkillGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSkillGroupResponse> deleteSkillGroup(DeleteSkillGroupRequest deleteSkillGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a skill group by skill group ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSkillGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSkillGroupRequest#builder()}
     * </p>
     *
     * @param deleteSkillGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSkillGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSkillGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSkillGroupResponse> deleteSkillGroup(
            Consumer<DeleteSkillGroupRequest.Builder> deleteSkillGroupRequest) {
        return deleteSkillGroup(DeleteSkillGroupRequest.builder().applyMutation(deleteSkillGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a specified user by user ARN and enrollment ARN.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified user by user ARN and enrollment ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteUserResponse> deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest) {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Disassociates a contact from a given address book.
     * </p>
     *
     * @param disassociateContactFromAddressBookRequest
     * @return A Java Future containing the result of the DisassociateContactFromAddressBook operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DisassociateContactFromAddressBook
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateContactFromAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateContactFromAddressBookResponse> disassociateContactFromAddressBook(
            DisassociateContactFromAddressBookRequest disassociateContactFromAddressBookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a contact from a given address book.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateContactFromAddressBookRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateContactFromAddressBookRequest#builder()}
     * </p>
     *
     * @param disassociateContactFromAddressBookRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateContactFromAddressBookRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateContactFromAddressBook operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DisassociateContactFromAddressBook
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateContactFromAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateContactFromAddressBookResponse> disassociateContactFromAddressBook(
            Consumer<DisassociateContactFromAddressBookRequest.Builder> disassociateContactFromAddressBookRequest) {
        return disassociateContactFromAddressBook(DisassociateContactFromAddressBookRequest.builder()
                .applyMutation(disassociateContactFromAddressBookRequest).build());
    }

    /**
     * <p>
     * Disassociates a device from its current room. The device continues to be connected to the Wi-Fi network and is
     * still registered to the account. The device settings and skills are removed from the room.
     * </p>
     *
     * @param disassociateDeviceFromRoomRequest
     * @return A Java Future containing the result of the DisassociateDeviceFromRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DisassociateDeviceFromRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateDeviceFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateDeviceFromRoomResponse> disassociateDeviceFromRoom(
            DisassociateDeviceFromRoomRequest disassociateDeviceFromRoomRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a device from its current room. The device continues to be connected to the Wi-Fi network and is
     * still registered to the account. The device settings and skills are removed from the room.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDeviceFromRoomRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateDeviceFromRoomRequest#builder()}
     * </p>
     *
     * @param disassociateDeviceFromRoomRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateDeviceFromRoomRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateDeviceFromRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DisassociateDeviceFromRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateDeviceFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateDeviceFromRoomResponse> disassociateDeviceFromRoom(
            Consumer<DisassociateDeviceFromRoomRequest.Builder> disassociateDeviceFromRoomRequest) {
        return disassociateDeviceFromRoom(DisassociateDeviceFromRoomRequest.builder()
                .applyMutation(disassociateDeviceFromRoomRequest).build());
    }

    /**
     * <p>
     * Disassociates a skill from a skill group.
     * </p>
     *
     * @param disassociateSkillFromSkillGroupRequest
     * @return A Java Future containing the result of the DisassociateSkillFromSkillGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DisassociateSkillFromSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSkillFromSkillGroupResponse> disassociateSkillFromSkillGroup(
            DisassociateSkillFromSkillGroupRequest disassociateSkillFromSkillGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a skill from a skill group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSkillFromSkillGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateSkillFromSkillGroupRequest#builder()}
     * </p>
     *
     * @param disassociateSkillFromSkillGroupRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateSkillFromSkillGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateSkillFromSkillGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DisassociateSkillFromSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSkillFromSkillGroupResponse> disassociateSkillFromSkillGroup(
            Consumer<DisassociateSkillFromSkillGroupRequest.Builder> disassociateSkillFromSkillGroupRequest) {
        return disassociateSkillFromSkillGroup(DisassociateSkillFromSkillGroupRequest.builder()
                .applyMutation(disassociateSkillFromSkillGroupRequest).build());
    }

    /**
     * <p>
     * Makes a private skill unavailable for enrolled users and prevents them from enabling it on their devices.
     * </p>
     *
     * @param disassociateSkillFromUsersRequest
     * @return A Java Future containing the result of the DisassociateSkillFromUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DisassociateSkillFromUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSkillFromUsersResponse> disassociateSkillFromUsers(
            DisassociateSkillFromUsersRequest disassociateSkillFromUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Makes a private skill unavailable for enrolled users and prevents them from enabling it on their devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSkillFromUsersRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateSkillFromUsersRequest#builder()}
     * </p>
     *
     * @param disassociateSkillFromUsersRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateSkillFromUsersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateSkillFromUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DisassociateSkillFromUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillFromUsers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSkillFromUsersResponse> disassociateSkillFromUsers(
            Consumer<DisassociateSkillFromUsersRequest.Builder> disassociateSkillFromUsersRequest) {
        return disassociateSkillFromUsers(DisassociateSkillFromUsersRequest.builder()
                .applyMutation(disassociateSkillFromUsersRequest).build());
    }

    /**
     * <p>
     * Disassociates a skill group from a specified room. This disables all skills in the skill group on all devices in
     * the room.
     * </p>
     *
     * @param disassociateSkillGroupFromRoomRequest
     * @return A Java Future containing the result of the DisassociateSkillGroupFromRoom operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DisassociateSkillGroupFromRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillGroupFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSkillGroupFromRoomResponse> disassociateSkillGroupFromRoom(
            DisassociateSkillGroupFromRoomRequest disassociateSkillGroupFromRoomRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a skill group from a specified room. This disables all skills in the skill group on all devices in
     * the room.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSkillGroupFromRoomRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateSkillGroupFromRoomRequest#builder()}
     * </p>
     *
     * @param disassociateSkillGroupFromRoomRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateSkillGroupFromRoomRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateSkillGroupFromRoom operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.DisassociateSkillGroupFromRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DisassociateSkillGroupFromRoom"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSkillGroupFromRoomResponse> disassociateSkillGroupFromRoom(
            Consumer<DisassociateSkillGroupFromRoomRequest.Builder> disassociateSkillGroupFromRoomRequest) {
        return disassociateSkillGroupFromRoom(DisassociateSkillGroupFromRoomRequest.builder()
                .applyMutation(disassociateSkillGroupFromRoomRequest).build());
    }

    /**
     * <p>
     * Forgets smart home appliances associated to a room.
     * </p>
     *
     * @param forgetSmartHomeAppliancesRequest
     * @return A Java Future containing the result of the ForgetSmartHomeAppliances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ForgetSmartHomeAppliances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ForgetSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ForgetSmartHomeAppliancesResponse> forgetSmartHomeAppliances(
            ForgetSmartHomeAppliancesRequest forgetSmartHomeAppliancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Forgets smart home appliances associated to a room.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ForgetSmartHomeAppliancesRequest.Builder} avoiding
     * the need to create one manually via {@link ForgetSmartHomeAppliancesRequest#builder()}
     * </p>
     *
     * @param forgetSmartHomeAppliancesRequest
     *        A {@link Consumer} that will call methods on {@link ForgetSmartHomeAppliancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ForgetSmartHomeAppliances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ForgetSmartHomeAppliances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ForgetSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ForgetSmartHomeAppliancesResponse> forgetSmartHomeAppliances(
            Consumer<ForgetSmartHomeAppliancesRequest.Builder> forgetSmartHomeAppliancesRequest) {
        return forgetSmartHomeAppliances(ForgetSmartHomeAppliancesRequest.builder()
                .applyMutation(forgetSmartHomeAppliancesRequest).build());
    }

    /**
     * <p>
     * Gets address the book details by the address book ARN.
     * </p>
     *
     * @param getAddressBookRequest
     * @return A Java Future containing the result of the GetAddressBook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAddressBookResponse> getAddressBook(GetAddressBookRequest getAddressBookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets address the book details by the address book ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAddressBookRequest.Builder} avoiding the need to
     * create one manually via {@link GetAddressBookRequest#builder()}
     * </p>
     *
     * @param getAddressBookRequest
     *        A {@link Consumer} that will call methods on {@link GetAddressBookRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAddressBook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAddressBookResponse> getAddressBook(Consumer<GetAddressBookRequest.Builder> getAddressBookRequest) {
        return getAddressBook(GetAddressBookRequest.builder().applyMutation(getAddressBookRequest).build());
    }

    /**
     * <p>
     * Retrieves the existing conference preferences.
     * </p>
     *
     * @param getConferencePreferenceRequest
     * @return A Java Future containing the result of the GetConferencePreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetConferencePreference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferencePreference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConferencePreferenceResponse> getConferencePreference(
            GetConferencePreferenceRequest getConferencePreferenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the existing conference preferences.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConferencePreferenceRequest.Builder} avoiding
     * the need to create one manually via {@link GetConferencePreferenceRequest#builder()}
     * </p>
     *
     * @param getConferencePreferenceRequest
     *        A {@link Consumer} that will call methods on {@link GetConferencePreferenceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetConferencePreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetConferencePreference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferencePreference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConferencePreferenceResponse> getConferencePreference(
            Consumer<GetConferencePreferenceRequest.Builder> getConferencePreferenceRequest) {
        return getConferencePreference(GetConferencePreferenceRequest.builder().applyMutation(getConferencePreferenceRequest)
                .build());
    }

    /**
     * <p>
     * Gets details about a specific conference provider.
     * </p>
     *
     * @param getConferenceProviderRequest
     * @return A Java Future containing the result of the GetConferenceProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConferenceProviderResponse> getConferenceProvider(
            GetConferenceProviderRequest getConferenceProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a specific conference provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConferenceProviderRequest.Builder} avoiding the
     * need to create one manually via {@link GetConferenceProviderRequest#builder()}
     * </p>
     *
     * @param getConferenceProviderRequest
     *        A {@link Consumer} that will call methods on {@link GetConferenceProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetConferenceProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConferenceProviderResponse> getConferenceProvider(
            Consumer<GetConferenceProviderRequest.Builder> getConferenceProviderRequest) {
        return getConferenceProvider(GetConferenceProviderRequest.builder().applyMutation(getConferenceProviderRequest).build());
    }

    /**
     * <p>
     * Gets the contact details by the contact ARN.
     * </p>
     *
     * @param getContactRequest
     * @return A Java Future containing the result of the GetContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetContactResponse> getContact(GetContactRequest getContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the contact details by the contact ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetContactRequest.Builder} avoiding the need to
     * create one manually via {@link GetContactRequest#builder()}
     * </p>
     *
     * @param getContactRequest
     *        A {@link Consumer} that will call methods on {@link GetContactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetContactResponse> getContact(Consumer<GetContactRequest.Builder> getContactRequest) {
        return getContact(GetContactRequest.builder().applyMutation(getContactRequest).build());
    }

    /**
     * <p>
     * Gets the details of a device by device ARN.
     * </p>
     *
     * @param getDeviceRequest
     * @return A Java Future containing the result of the GetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeviceResponse> getDevice(GetDeviceRequest getDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a device by device ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDeviceRequest#builder()}
     * </p>
     *
     * @param getDeviceRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeviceResponse> getDevice(Consumer<GetDeviceRequest.Builder> getDeviceRequest) {
        return getDevice(GetDeviceRequest.builder().applyMutation(getDeviceRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a gateway.
     * </p>
     *
     * @param getGatewayRequest
     * @return A Java Future containing the result of the GetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetGatewayResponse> getGateway(GetGatewayRequest getGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link GetGatewayRequest#builder()}
     * </p>
     *
     * @param getGatewayRequest
     *        A {@link Consumer} that will call methods on {@link GetGatewayRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetGatewayResponse> getGateway(Consumer<GetGatewayRequest.Builder> getGatewayRequest) {
        return getGateway(GetGatewayRequest.builder().applyMutation(getGatewayRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a gateway group.
     * </p>
     *
     * @param getGatewayGroupRequest
     * @return A Java Future containing the result of the GetGatewayGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGatewayGroupResponse> getGatewayGroup(GetGatewayGroupRequest getGatewayGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a gateway group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGatewayGroupRequest.Builder} avoiding the need
     * to create one manually via {@link GetGatewayGroupRequest#builder()}
     * </p>
     *
     * @param getGatewayGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetGatewayGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGatewayGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGatewayGroupResponse> getGatewayGroup(
            Consumer<GetGatewayGroupRequest.Builder> getGatewayGroupRequest) {
        return getGatewayGroup(GetGatewayGroupRequest.builder().applyMutation(getGatewayGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves the configured values for the user enrollment invitation email template.
     * </p>
     *
     * @param getInvitationConfigurationRequest
     * @return A Java Future containing the result of the GetInvitationConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetInvitationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetInvitationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInvitationConfigurationResponse> getInvitationConfiguration(
            GetInvitationConfigurationRequest getInvitationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the configured values for the user enrollment invitation email template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvitationConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetInvitationConfigurationRequest#builder()}
     * </p>
     *
     * @param getInvitationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetInvitationConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInvitationConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetInvitationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetInvitationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInvitationConfigurationResponse> getInvitationConfiguration(
            Consumer<GetInvitationConfigurationRequest.Builder> getInvitationConfigurationRequest) {
        return getInvitationConfiguration(GetInvitationConfigurationRequest.builder()
                .applyMutation(getInvitationConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets the network profile details by the network profile ARN.
     * </p>
     *
     * @param getNetworkProfileRequest
     * @return A Java Future containing the result of the GetNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>InvalidSecretsManagerResourceException A password in SecretsManager is in an invalid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkProfileResponse> getNetworkProfile(GetNetworkProfileRequest getNetworkProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the network profile details by the network profile ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetNetworkProfileRequest#builder()}
     * </p>
     *
     * @param getNetworkProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>InvalidSecretsManagerResourceException A password in SecretsManager is in an invalid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkProfileResponse> getNetworkProfile(
            Consumer<GetNetworkProfileRequest.Builder> getNetworkProfileRequest) {
        return getNetworkProfile(GetNetworkProfileRequest.builder().applyMutation(getNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Gets the details of a room profile by profile ARN.
     * </p>
     *
     * @param getProfileRequest
     * @return A Java Future containing the result of the GetProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetProfileResponse> getProfile(GetProfileRequest getProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a room profile by profile ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProfileRequest.Builder} avoiding the need to
     * create one manually via {@link GetProfileRequest#builder()}
     * </p>
     *
     * @param getProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetProfileResponse> getProfile(Consumer<GetProfileRequest.Builder> getProfileRequest) {
        return getProfile(GetProfileRequest.builder().applyMutation(getProfileRequest).build());
    }

    /**
     * <p>
     * Gets room details by room ARN.
     * </p>
     *
     * @param getRoomRequest
     * @return A Java Future containing the result of the GetRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoom" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRoomResponse> getRoom(GetRoomRequest getRoomRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets room details by room ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRoomRequest.Builder} avoiding the need to create
     * one manually via {@link GetRoomRequest#builder()}
     * </p>
     *
     * @param getRoomRequest
     *        A {@link Consumer} that will call methods on {@link GetRoomRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoom" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRoomResponse> getRoom(Consumer<GetRoomRequest.Builder> getRoomRequest) {
        return getRoom(GetRoomRequest.builder().applyMutation(getRoomRequest).build());
    }

    /**
     * <p>
     * Gets room skill parameter details by room, skill, and parameter key ARN.
     * </p>
     *
     * @param getRoomSkillParameterRequest
     * @return A Java Future containing the result of the GetRoomSkillParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRoomSkillParameterResponse> getRoomSkillParameter(
            GetRoomSkillParameterRequest getRoomSkillParameterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets room skill parameter details by room, skill, and parameter key ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRoomSkillParameterRequest.Builder} avoiding the
     * need to create one manually via {@link GetRoomSkillParameterRequest#builder()}
     * </p>
     *
     * @param getRoomSkillParameterRequest
     *        A {@link Consumer} that will call methods on {@link GetRoomSkillParameterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRoomSkillParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRoomSkillParameterResponse> getRoomSkillParameter(
            Consumer<GetRoomSkillParameterRequest.Builder> getRoomSkillParameterRequest) {
        return getRoomSkillParameter(GetRoomSkillParameterRequest.builder().applyMutation(getRoomSkillParameterRequest).build());
    }

    /**
     * <p>
     * Gets skill group details by skill group ARN.
     * </p>
     *
     * @param getSkillGroupRequest
     * @return A Java Future containing the result of the GetSkillGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetSkillGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSkillGroupResponse> getSkillGroup(GetSkillGroupRequest getSkillGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets skill group details by skill group ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSkillGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetSkillGroupRequest#builder()}
     * </p>
     *
     * @param getSkillGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetSkillGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSkillGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.GetSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetSkillGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSkillGroupResponse> getSkillGroup(Consumer<GetSkillGroupRequest.Builder> getSkillGroupRequest) {
        return getSkillGroup(GetSkillGroupRequest.builder().applyMutation(getSkillGroupRequest).build());
    }

    /**
     * <p>
     * Lists the details of the schedules that a user configured.
     * </p>
     *
     * @param listBusinessReportSchedulesRequest
     * @return A Java Future containing the result of the ListBusinessReportSchedules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListBusinessReportSchedules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBusinessReportSchedulesResponse> listBusinessReportSchedules(
            ListBusinessReportSchedulesRequest listBusinessReportSchedulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the details of the schedules that a user configured.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBusinessReportSchedulesRequest.Builder}
     * avoiding the need to create one manually via {@link ListBusinessReportSchedulesRequest#builder()}
     * </p>
     *
     * @param listBusinessReportSchedulesRequest
     *        A {@link Consumer} that will call methods on {@link ListBusinessReportSchedulesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListBusinessReportSchedules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListBusinessReportSchedules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBusinessReportSchedulesResponse> listBusinessReportSchedules(
            Consumer<ListBusinessReportSchedulesRequest.Builder> listBusinessReportSchedulesRequest) {
        return listBusinessReportSchedules(ListBusinessReportSchedulesRequest.builder()
                .applyMutation(listBusinessReportSchedulesRequest).build());
    }

    /**
     * <p>
     * Lists the details of the schedules that a user configured.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBusinessReportSchedules(software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesPublisher publisher = client.listBusinessReportSchedulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesPublisher publisher = client.listBusinessReportSchedulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBusinessReportSchedules(software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBusinessReportSchedulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListBusinessReportSchedules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBusinessReportSchedulesPublisher listBusinessReportSchedulesPaginator(
            ListBusinessReportSchedulesRequest listBusinessReportSchedulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the details of the schedules that a user configured.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBusinessReportSchedules(software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesPublisher publisher = client.listBusinessReportSchedulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListBusinessReportSchedulesPublisher publisher = client.listBusinessReportSchedulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBusinessReportSchedules(software.amazon.awssdk.services.alexaforbusiness.model.ListBusinessReportSchedulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBusinessReportSchedulesRequest.Builder}
     * avoiding the need to create one manually via {@link ListBusinessReportSchedulesRequest#builder()}
     * </p>
     *
     * @param listBusinessReportSchedulesRequest
     *        A {@link Consumer} that will call methods on {@link ListBusinessReportSchedulesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListBusinessReportSchedules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListBusinessReportSchedules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBusinessReportSchedulesPublisher listBusinessReportSchedulesPaginator(
            Consumer<ListBusinessReportSchedulesRequest.Builder> listBusinessReportSchedulesRequest) {
        return listBusinessReportSchedulesPaginator(ListBusinessReportSchedulesRequest.builder()
                .applyMutation(listBusinessReportSchedulesRequest).build());
    }

    /**
     * <p>
     * Lists conference providers under a specific AWS account.
     * </p>
     *
     * @param listConferenceProvidersRequest
     * @return A Java Future containing the result of the ListConferenceProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListConferenceProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListConferenceProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConferenceProvidersResponse> listConferenceProviders(
            ListConferenceProvidersRequest listConferenceProvidersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists conference providers under a specific AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConferenceProvidersRequest.Builder} avoiding
     * the need to create one manually via {@link ListConferenceProvidersRequest#builder()}
     * </p>
     *
     * @param listConferenceProvidersRequest
     *        A {@link Consumer} that will call methods on {@link ListConferenceProvidersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListConferenceProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListConferenceProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListConferenceProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConferenceProvidersResponse> listConferenceProviders(
            Consumer<ListConferenceProvidersRequest.Builder> listConferenceProvidersRequest) {
        return listConferenceProviders(ListConferenceProvidersRequest.builder().applyMutation(listConferenceProvidersRequest)
                .build());
    }

    /**
     * <p>
     * Lists conference providers under a specific AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConferenceProviders(software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersPublisher publisher = client.listConferenceProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersPublisher publisher = client.listConferenceProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConferenceProviders(software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConferenceProvidersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListConferenceProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListConferenceProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConferenceProvidersPublisher listConferenceProvidersPaginator(
            ListConferenceProvidersRequest listConferenceProvidersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists conference providers under a specific AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConferenceProviders(software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersPublisher publisher = client.listConferenceProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListConferenceProvidersPublisher publisher = client.listConferenceProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConferenceProviders(software.amazon.awssdk.services.alexaforbusiness.model.ListConferenceProvidersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConferenceProvidersRequest.Builder} avoiding
     * the need to create one manually via {@link ListConferenceProvidersRequest#builder()}
     * </p>
     *
     * @param listConferenceProvidersRequest
     *        A {@link Consumer} that will call methods on {@link ListConferenceProvidersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListConferenceProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListConferenceProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConferenceProvidersPublisher listConferenceProvidersPaginator(
            Consumer<ListConferenceProvidersRequest.Builder> listConferenceProvidersRequest) {
        return listConferenceProvidersPaginator(ListConferenceProvidersRequest.builder()
                .applyMutation(listConferenceProvidersRequest).build());
    }

    /**
     * <p>
     * Lists the device event history, including device connection status, for up to 30 days.
     * </p>
     *
     * @param listDeviceEventsRequest
     * @return A Java Future containing the result of the ListDeviceEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListDeviceEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListDeviceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceEventsResponse> listDeviceEvents(ListDeviceEventsRequest listDeviceEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the device event history, including device connection status, for up to 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceEventsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeviceEventsRequest#builder()}
     * </p>
     *
     * @param listDeviceEventsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceEventsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDeviceEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListDeviceEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListDeviceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeviceEventsResponse> listDeviceEvents(
            Consumer<ListDeviceEventsRequest.Builder> listDeviceEventsRequest) {
        return listDeviceEvents(ListDeviceEventsRequest.builder().applyMutation(listDeviceEventsRequest).build());
    }

    /**
     * <p>
     * Lists the device event history, including device connection status, for up to 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceEvents(software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsPublisher publisher = client.listDeviceEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsPublisher publisher = client.listDeviceEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceEvents(software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeviceEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListDeviceEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListDeviceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceEventsPublisher listDeviceEventsPaginator(ListDeviceEventsRequest listDeviceEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the device event history, including device connection status, for up to 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeviceEvents(software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsPublisher publisher = client.listDeviceEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListDeviceEventsPublisher publisher = client.listDeviceEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeviceEvents(software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceEventsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeviceEventsRequest#builder()}
     * </p>
     *
     * @param listDeviceEventsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceEventsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListDeviceEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListDeviceEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeviceEventsPublisher listDeviceEventsPaginator(Consumer<ListDeviceEventsRequest.Builder> listDeviceEventsRequest) {
        return listDeviceEventsPaginator(ListDeviceEventsRequest.builder().applyMutation(listDeviceEventsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.
     * </p>
     *
     * @param listGatewayGroupsRequest
     * @return A Java Future containing the result of the ListGatewayGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListGatewayGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGatewayGroupsResponse> listGatewayGroups(ListGatewayGroupsRequest listGatewayGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewayGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListGatewayGroupsRequest#builder()}
     * </p>
     *
     * @param listGatewayGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewayGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGatewayGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListGatewayGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGatewayGroupsResponse> listGatewayGroups(
            Consumer<ListGatewayGroupsRequest.Builder> listGatewayGroupsRequest) {
        return listGatewayGroups(ListGatewayGroupsRequest.builder().applyMutation(listGatewayGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGatewayGroups(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsPublisher publisher = client.listGatewayGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsPublisher publisher = client.listGatewayGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayGroups(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGatewayGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListGatewayGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayGroupsPublisher listGatewayGroupsPaginator(ListGatewayGroupsRequest listGatewayGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of gateway group summaries. Use GetGatewayGroup to retrieve details of a specific gateway group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGatewayGroups(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsPublisher publisher = client.listGatewayGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewayGroupsPublisher publisher = client.listGatewayGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGatewayGroups(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewayGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListGatewayGroupsRequest#builder()}
     * </p>
     *
     * @param listGatewayGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewayGroupsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListGatewayGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGatewayGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGatewayGroupsPublisher listGatewayGroupsPaginator(
            Consumer<ListGatewayGroupsRequest.Builder> listGatewayGroupsRequest) {
        return listGatewayGroupsPaginator(ListGatewayGroupsRequest.builder().applyMutation(listGatewayGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional
     * gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that
     * gateway group ARN.
     * </p>
     *
     * @param listGatewaysRequest
     * @return A Java Future containing the result of the ListGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListGatewaysResponse> listGateways(ListGatewaysRequest listGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional
     * gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that
     * gateway group ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewaysRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListGatewaysResponse> listGateways(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest) {
        return listGateways(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional
     * gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that
     * gateway group ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest)} operation.</b>
     * </p>
     *
     * @param listGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysPublisher listGatewaysPaginator(ListGatewaysRequest listGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of gateway summaries. Use GetGateway to retrieve details of a specific gateway. An optional
     * gateway group ARN can be provided to only retrieve gateway summaries of gateways that are associated with that
     * gateway group ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGateways(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListGatewaysPublisher publisher = client.listGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGateways(software.amazon.awssdk.services.alexaforbusiness.model.ListGatewaysRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGatewaysRequest.Builder} avoiding the need to
     * create one manually via {@link ListGatewaysRequest#builder()}
     * </p>
     *
     * @param listGatewaysRequest
     *        A {@link Consumer} that will call methods on {@link ListGatewaysRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListGateways" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGatewaysPublisher listGatewaysPaginator(Consumer<ListGatewaysRequest.Builder> listGatewaysRequest) {
        return listGatewaysPaginator(ListGatewaysRequest.builder().applyMutation(listGatewaysRequest).build());
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     *
     * @param listSkillsRequest
     * @return A Java Future containing the result of the ListSkills operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkills
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSkillsResponse> listSkills(ListSkillsRequest listSkillsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSkillsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSkillsRequest#builder()}
     * </p>
     *
     * @param listSkillsRequest
     *        A {@link Consumer} that will call methods on {@link ListSkillsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSkills operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkills
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSkillsResponse> listSkills(Consumer<ListSkillsRequest.Builder> listSkillsRequest) {
        return listSkills(ListSkillsRequest.builder().applyMutation(listSkillsRequest).build());
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsPublisher publisher = client.listSkillsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsPublisher publisher = client.listSkillsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation.</b>
     * </p>
     *
     * @param listSkillsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkills
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSkillsPublisher listSkillsPaginator(ListSkillsRequest listSkillsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all enabled skills in a specific skill group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsPublisher publisher = client.listSkillsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsPublisher publisher = client.listSkillsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkills(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSkillsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSkillsRequest#builder()}
     * </p>
     *
     * @param listSkillsRequest
     *        A {@link Consumer} that will call methods on {@link ListSkillsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkills
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkills" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSkillsPublisher listSkillsPaginator(Consumer<ListSkillsRequest.Builder> listSkillsRequest) {
        return listSkillsPaginator(ListSkillsRequest.builder().applyMutation(listSkillsRequest).build());
    }

    /**
     * <p>
     * Lists all categories in the Alexa skill store.
     * </p>
     *
     * @param listSkillsStoreCategoriesRequest
     * @return A Java Future containing the result of the ListSkillsStoreCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkillsStoreCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSkillsStoreCategoriesResponse> listSkillsStoreCategories(
            ListSkillsStoreCategoriesRequest listSkillsStoreCategoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all categories in the Alexa skill store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSkillsStoreCategoriesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSkillsStoreCategoriesRequest#builder()}
     * </p>
     *
     * @param listSkillsStoreCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListSkillsStoreCategoriesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSkillsStoreCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkillsStoreCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSkillsStoreCategoriesResponse> listSkillsStoreCategories(
            Consumer<ListSkillsStoreCategoriesRequest.Builder> listSkillsStoreCategoriesRequest) {
        return listSkillsStoreCategories(ListSkillsStoreCategoriesRequest.builder()
                .applyMutation(listSkillsStoreCategoriesRequest).build());
    }

    /**
     * <p>
     * Lists all categories in the Alexa skill store.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkillsStoreCategories(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesPublisher publisher = client.listSkillsStoreCategoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesPublisher publisher = client.listSkillsStoreCategoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkillsStoreCategories(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSkillsStoreCategoriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkillsStoreCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSkillsStoreCategoriesPublisher listSkillsStoreCategoriesPaginator(
            ListSkillsStoreCategoriesRequest listSkillsStoreCategoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all categories in the Alexa skill store.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkillsStoreCategories(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesPublisher publisher = client.listSkillsStoreCategoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreCategoriesPublisher publisher = client.listSkillsStoreCategoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkillsStoreCategories(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreCategoriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSkillsStoreCategoriesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSkillsStoreCategoriesRequest#builder()}
     * </p>
     *
     * @param listSkillsStoreCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListSkillsStoreCategoriesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkillsStoreCategories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreCategories"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSkillsStoreCategoriesPublisher listSkillsStoreCategoriesPaginator(
            Consumer<ListSkillsStoreCategoriesRequest.Builder> listSkillsStoreCategoriesRequest) {
        return listSkillsStoreCategoriesPaginator(ListSkillsStoreCategoriesRequest.builder()
                .applyMutation(listSkillsStoreCategoriesRequest).build());
    }

    /**
     * <p>
     * Lists all skills in the Alexa skill store by category.
     * </p>
     *
     * @param listSkillsStoreSkillsByCategoryRequest
     * @return A Java Future containing the result of the ListSkillsStoreSkillsByCategory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkillsStoreSkillsByCategory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSkillsStoreSkillsByCategoryResponse> listSkillsStoreSkillsByCategory(
            ListSkillsStoreSkillsByCategoryRequest listSkillsStoreSkillsByCategoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all skills in the Alexa skill store by category.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSkillsStoreSkillsByCategoryRequest.Builder}
     * avoiding the need to create one manually via {@link ListSkillsStoreSkillsByCategoryRequest#builder()}
     * </p>
     *
     * @param listSkillsStoreSkillsByCategoryRequest
     *        A {@link Consumer} that will call methods on {@link ListSkillsStoreSkillsByCategoryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListSkillsStoreSkillsByCategory operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkillsStoreSkillsByCategory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSkillsStoreSkillsByCategoryResponse> listSkillsStoreSkillsByCategory(
            Consumer<ListSkillsStoreSkillsByCategoryRequest.Builder> listSkillsStoreSkillsByCategoryRequest) {
        return listSkillsStoreSkillsByCategory(ListSkillsStoreSkillsByCategoryRequest.builder()
                .applyMutation(listSkillsStoreSkillsByCategoryRequest).build());
    }

    /**
     * <p>
     * Lists all skills in the Alexa skill store by category.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkillsStoreSkillsByCategory(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryPublisher publisher = client.listSkillsStoreSkillsByCategoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryPublisher publisher = client.listSkillsStoreSkillsByCategoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkillsStoreSkillsByCategory(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSkillsStoreSkillsByCategoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkillsStoreSkillsByCategory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSkillsStoreSkillsByCategoryPublisher listSkillsStoreSkillsByCategoryPaginator(
            ListSkillsStoreSkillsByCategoryRequest listSkillsStoreSkillsByCategoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all skills in the Alexa skill store by category.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSkillsStoreSkillsByCategory(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryPublisher publisher = client.listSkillsStoreSkillsByCategoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSkillsStoreSkillsByCategoryPublisher publisher = client.listSkillsStoreSkillsByCategoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSkillsStoreSkillsByCategory(software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsStoreSkillsByCategoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSkillsStoreSkillsByCategoryRequest.Builder}
     * avoiding the need to create one manually via {@link ListSkillsStoreSkillsByCategoryRequest#builder()}
     * </p>
     *
     * @param listSkillsStoreSkillsByCategoryRequest
     *        A {@link Consumer} that will call methods on {@link ListSkillsStoreSkillsByCategoryRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSkillsStoreSkillsByCategory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSkillsStoreSkillsByCategory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSkillsStoreSkillsByCategoryPublisher listSkillsStoreSkillsByCategoryPaginator(
            Consumer<ListSkillsStoreSkillsByCategoryRequest.Builder> listSkillsStoreSkillsByCategoryRequest) {
        return listSkillsStoreSkillsByCategoryPaginator(ListSkillsStoreSkillsByCategoryRequest.builder()
                .applyMutation(listSkillsStoreSkillsByCategoryRequest).build());
    }

    /**
     * <p>
     * Lists all of the smart home appliances associated with a room.
     * </p>
     *
     * @param listSmartHomeAppliancesRequest
     * @return A Java Future containing the result of the ListSmartHomeAppliances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSmartHomeAppliances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSmartHomeAppliancesResponse> listSmartHomeAppliances(
            ListSmartHomeAppliancesRequest listSmartHomeAppliancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the smart home appliances associated with a room.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSmartHomeAppliancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSmartHomeAppliancesRequest#builder()}
     * </p>
     *
     * @param listSmartHomeAppliancesRequest
     *        A {@link Consumer} that will call methods on {@link ListSmartHomeAppliancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSmartHomeAppliances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSmartHomeAppliances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSmartHomeAppliancesResponse> listSmartHomeAppliances(
            Consumer<ListSmartHomeAppliancesRequest.Builder> listSmartHomeAppliancesRequest) {
        return listSmartHomeAppliances(ListSmartHomeAppliancesRequest.builder().applyMutation(listSmartHomeAppliancesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all of the smart home appliances associated with a room.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSmartHomeAppliances(software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesPublisher publisher = client.listSmartHomeAppliancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesPublisher publisher = client.listSmartHomeAppliancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSmartHomeAppliances(software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSmartHomeAppliancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSmartHomeAppliances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSmartHomeAppliancesPublisher listSmartHomeAppliancesPaginator(
            ListSmartHomeAppliancesRequest listSmartHomeAppliancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the smart home appliances associated with a room.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSmartHomeAppliances(software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesPublisher publisher = client.listSmartHomeAppliancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListSmartHomeAppliancesPublisher publisher = client.listSmartHomeAppliancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSmartHomeAppliances(software.amazon.awssdk.services.alexaforbusiness.model.ListSmartHomeAppliancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSmartHomeAppliancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSmartHomeAppliancesRequest#builder()}
     * </p>
     *
     * @param listSmartHomeAppliancesRequest
     *        A {@link Consumer} that will call methods on {@link ListSmartHomeAppliancesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListSmartHomeAppliances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListSmartHomeAppliances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSmartHomeAppliancesPublisher listSmartHomeAppliancesPaginator(
            Consumer<ListSmartHomeAppliancesRequest.Builder> listSmartHomeAppliancesRequest) {
        return listSmartHomeAppliancesPaginator(ListSmartHomeAppliancesRequest.builder()
                .applyMutation(listSmartHomeAppliancesRequest).build());
    }

    /**
     * <p>
     * Lists all tags for the specified resource.
     * </p>
     *
     * @param listTagsRequest
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Lists all tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)} operation.</b>
     * </p>
     *
     * @param listTagsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsPublisher listTagsPaginator(ListTagsRequest listTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.ListTagsPublisher publisher = client.listTagsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.alexaforbusiness.model.ListTagsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsPublisher listTagsPaginator(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTagsPaginator(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Sets the conference preferences on a specific conference provider at the account level.
     * </p>
     *
     * @param putConferencePreferenceRequest
     * @return A Java Future containing the result of the PutConferencePreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.PutConferencePreference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutConferencePreference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConferencePreferenceResponse> putConferencePreference(
            PutConferencePreferenceRequest putConferencePreferenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the conference preferences on a specific conference provider at the account level.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConferencePreferenceRequest.Builder} avoiding
     * the need to create one manually via {@link PutConferencePreferenceRequest#builder()}
     * </p>
     *
     * @param putConferencePreferenceRequest
     *        A {@link Consumer} that will call methods on {@link PutConferencePreferenceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutConferencePreference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.PutConferencePreference
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutConferencePreference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConferencePreferenceResponse> putConferencePreference(
            Consumer<PutConferencePreferenceRequest.Builder> putConferencePreferenceRequest) {
        return putConferencePreference(PutConferencePreferenceRequest.builder().applyMutation(putConferencePreferenceRequest)
                .build());
    }

    /**
     * <p>
     * Configures the email template for the user enrollment invitation with the specified attributes.
     * </p>
     *
     * @param putInvitationConfigurationRequest
     * @return A Java Future containing the result of the PutInvitationConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.PutInvitationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutInvitationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInvitationConfigurationResponse> putInvitationConfiguration(
            PutInvitationConfigurationRequest putInvitationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures the email template for the user enrollment invitation with the specified attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutInvitationConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutInvitationConfigurationRequest#builder()}
     * </p>
     *
     * @param putInvitationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutInvitationConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutInvitationConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.PutInvitationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutInvitationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutInvitationConfigurationResponse> putInvitationConfiguration(
            Consumer<PutInvitationConfigurationRequest.Builder> putInvitationConfigurationRequest) {
        return putInvitationConfiguration(PutInvitationConfigurationRequest.builder()
                .applyMutation(putInvitationConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates room skill parameter details by room, skill, and parameter key ID. Not all skills have a room skill
     * parameter.
     * </p>
     *
     * @param putRoomSkillParameterRequest
     * @return A Java Future containing the result of the PutRoomSkillParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.PutRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRoomSkillParameterResponse> putRoomSkillParameter(
            PutRoomSkillParameterRequest putRoomSkillParameterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates room skill parameter details by room, skill, and parameter key ID. Not all skills have a room skill
     * parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRoomSkillParameterRequest.Builder} avoiding the
     * need to create one manually via {@link PutRoomSkillParameterRequest#builder()}
     * </p>
     *
     * @param putRoomSkillParameterRequest
     *        A {@link Consumer} that will call methods on {@link PutRoomSkillParameterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutRoomSkillParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.PutRoomSkillParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutRoomSkillParameter"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRoomSkillParameterResponse> putRoomSkillParameter(
            Consumer<PutRoomSkillParameterRequest.Builder> putRoomSkillParameterRequest) {
        return putRoomSkillParameter(PutRoomSkillParameterRequest.builder().applyMutation(putRoomSkillParameterRequest).build());
    }

    /**
     * <p>
     * Links a user's account to a third-party skill provider. If this API operation is called by an assumed IAM role,
     * the skill being linked must be a private skill. Also, the skill must be owned by the AWS account that assumed the
     * IAM role.
     * </p>
     *
     * @param putSkillAuthorizationRequest
     * @return A Java Future containing the result of the PutSkillAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The caller has no permissions to operate on the resource involved in the API
     *         call.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.PutSkillAuthorization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutSkillAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutSkillAuthorizationResponse> putSkillAuthorization(
            PutSkillAuthorizationRequest putSkillAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Links a user's account to a third-party skill provider. If this API operation is called by an assumed IAM role,
     * the skill being linked must be a private skill. Also, the skill must be owned by the AWS account that assumed the
     * IAM role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSkillAuthorizationRequest.Builder} avoiding the
     * need to create one manually via {@link PutSkillAuthorizationRequest#builder()}
     * </p>
     *
     * @param putSkillAuthorizationRequest
     *        A {@link Consumer} that will call methods on {@link PutSkillAuthorizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutSkillAuthorization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The caller has no permissions to operate on the resource involved in the API
     *         call.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.PutSkillAuthorization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/PutSkillAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutSkillAuthorizationResponse> putSkillAuthorization(
            Consumer<PutSkillAuthorizationRequest.Builder> putSkillAuthorizationRequest) {
        return putSkillAuthorization(PutSkillAuthorizationRequest.builder().applyMutation(putSkillAuthorizationRequest).build());
    }

    /**
     * <p>
     * Registers an Alexa-enabled device built by an Original Equipment Manufacturer (OEM) using Alexa Voice Service
     * (AVS).
     * </p>
     *
     * @param registerAvsDeviceRequest
     * @return A Java Future containing the result of the RegisterAVSDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>InvalidDeviceException The device is in an invalid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.RegisterAVSDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RegisterAVSDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterAvsDeviceResponse> registerAVSDevice(RegisterAvsDeviceRequest registerAvsDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an Alexa-enabled device built by an Original Equipment Manufacturer (OEM) using Alexa Voice Service
     * (AVS).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterAvsDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterAvsDeviceRequest#builder()}
     * </p>
     *
     * @param registerAvsDeviceRequest
     *        A {@link Consumer} that will call methods on {@link RegisterAVSDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RegisterAVSDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>InvalidDeviceException The device is in an invalid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.RegisterAVSDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RegisterAVSDevice"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterAvsDeviceResponse> registerAVSDevice(
            Consumer<RegisterAvsDeviceRequest.Builder> registerAvsDeviceRequest) {
        return registerAVSDevice(RegisterAvsDeviceRequest.builder().applyMutation(registerAvsDeviceRequest).build());
    }

    /**
     * <p>
     * Disassociates a skill from the organization under a user's AWS account. If the skill is a private skill, it moves
     * to an AcceptStatus of PENDING. Any private or public skill that is rejected can be added later by calling the
     * ApproveSkill API.
     * </p>
     *
     * @param rejectSkillRequest
     * @return A Java Future containing the result of the RejectSkill operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.RejectSkill
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RejectSkill" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RejectSkillResponse> rejectSkill(RejectSkillRequest rejectSkillRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a skill from the organization under a user's AWS account. If the skill is a private skill, it moves
     * to an AcceptStatus of PENDING. Any private or public skill that is rejected can be added later by calling the
     * ApproveSkill API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectSkillRequest.Builder} avoiding the need to
     * create one manually via {@link RejectSkillRequest#builder()}
     * </p>
     *
     * @param rejectSkillRequest
     *        A {@link Consumer} that will call methods on {@link RejectSkillRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RejectSkill operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.RejectSkill
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RejectSkill" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RejectSkillResponse> rejectSkill(Consumer<RejectSkillRequest.Builder> rejectSkillRequest) {
        return rejectSkill(RejectSkillRequest.builder().applyMutation(rejectSkillRequest).build());
    }

    /**
     * <p>
     * Determines the details for the room from which a skill request was invoked. This operation is used by skill
     * developers.
     * </p>
     *
     * @param resolveRoomRequest
     * @return A Java Future containing the result of the ResolveRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ResolveRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ResolveRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResolveRoomResponse> resolveRoom(ResolveRoomRequest resolveRoomRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Determines the details for the room from which a skill request was invoked. This operation is used by skill
     * developers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResolveRoomRequest.Builder} avoiding the need to
     * create one manually via {@link ResolveRoomRequest#builder()}
     * </p>
     *
     * @param resolveRoomRequest
     *        A {@link Consumer} that will call methods on {@link ResolveRoomRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ResolveRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.ResolveRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ResolveRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ResolveRoomResponse> resolveRoom(Consumer<ResolveRoomRequest.Builder> resolveRoomRequest) {
        return resolveRoom(ResolveRoomRequest.builder().applyMutation(resolveRoomRequest).build());
    }

    /**
     * <p>
     * Revokes an invitation and invalidates the enrollment URL.
     * </p>
     *
     * @param revokeInvitationRequest
     * @return A Java Future containing the result of the RevokeInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.RevokeInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RevokeInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RevokeInvitationResponse> revokeInvitation(RevokeInvitationRequest revokeInvitationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes an invitation and invalidates the enrollment URL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeInvitationRequest.Builder} avoiding the need
     * to create one manually via {@link RevokeInvitationRequest#builder()}
     * </p>
     *
     * @param revokeInvitationRequest
     *        A {@link Consumer} that will call methods on {@link RevokeInvitationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RevokeInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.RevokeInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/RevokeInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RevokeInvitationResponse> revokeInvitation(
            Consumer<RevokeInvitationRequest.Builder> revokeInvitationRequest) {
        return revokeInvitation(RevokeInvitationRequest.builder().applyMutation(revokeInvitationRequest).build());
    }

    /**
     * <p>
     * Searches address books and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchAddressBooksRequest
     * @return A Java Future containing the result of the SearchAddressBooks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchAddressBooks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchAddressBooksResponse> searchAddressBooks(SearchAddressBooksRequest searchAddressBooksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches address books and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchAddressBooksRequest.Builder} avoiding the
     * need to create one manually via {@link SearchAddressBooksRequest#builder()}
     * </p>
     *
     * @param searchAddressBooksRequest
     *        A {@link Consumer} that will call methods on {@link SearchAddressBooksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchAddressBooks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchAddressBooks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchAddressBooksResponse> searchAddressBooks(
            Consumer<SearchAddressBooksRequest.Builder> searchAddressBooksRequest) {
        return searchAddressBooks(SearchAddressBooksRequest.builder().applyMutation(searchAddressBooksRequest).build());
    }

    /**
     * <p>
     * Searches address books and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchAddressBooks(software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksPublisher publisher = client.searchAddressBooksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksPublisher publisher = client.searchAddressBooksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchAddressBooks(software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchAddressBooksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchAddressBooks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchAddressBooksPublisher searchAddressBooksPaginator(SearchAddressBooksRequest searchAddressBooksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches address books and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchAddressBooks(software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksPublisher publisher = client.searchAddressBooksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchAddressBooksPublisher publisher = client.searchAddressBooksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchAddressBooks(software.amazon.awssdk.services.alexaforbusiness.model.SearchAddressBooksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchAddressBooksRequest.Builder} avoiding the
     * need to create one manually via {@link SearchAddressBooksRequest#builder()}
     * </p>
     *
     * @param searchAddressBooksRequest
     *        A {@link Consumer} that will call methods on {@link SearchAddressBooksRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchAddressBooks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchAddressBooksPublisher searchAddressBooksPaginator(
            Consumer<SearchAddressBooksRequest.Builder> searchAddressBooksRequest) {
        return searchAddressBooksPaginator(SearchAddressBooksRequest.builder().applyMutation(searchAddressBooksRequest).build());
    }

    /**
     * <p>
     * Searches contacts and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchContactsRequest
     * @return A Java Future containing the result of the SearchContacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchContacts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchContactsResponse> searchContacts(SearchContactsRequest searchContactsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches contacts and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchContactsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchContactsRequest#builder()}
     * </p>
     *
     * @param searchContactsRequest
     *        A {@link Consumer} that will call methods on {@link SearchContactsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchContacts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchContacts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchContactsResponse> searchContacts(Consumer<SearchContactsRequest.Builder> searchContactsRequest) {
        return searchContacts(SearchContactsRequest.builder().applyMutation(searchContactsRequest).build());
    }

    /**
     * <p>
     * Searches contacts and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchContacts(software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsPublisher publisher = client.searchContactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsPublisher publisher = client.searchContactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchContacts(software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchContactsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchContacts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchContactsPublisher searchContactsPaginator(SearchContactsRequest searchContactsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches contacts and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchContacts(software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsPublisher publisher = client.searchContactsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchContactsPublisher publisher = client.searchContactsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchContacts(software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchContactsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchContactsRequest#builder()}
     * </p>
     *
     * @param searchContactsRequest
     *        A {@link Consumer} that will call methods on {@link SearchContactsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchContacts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchContacts"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchContactsPublisher searchContactsPaginator(Consumer<SearchContactsRequest.Builder> searchContactsRequest) {
        return searchContactsPaginator(SearchContactsRequest.builder().applyMutation(searchContactsRequest).build());
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     *
     * @param searchDevicesRequest
     * @return A Java Future containing the result of the SearchDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchDevicesResponse> searchDevices(SearchDevicesRequest searchDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchDevicesRequest#builder()}
     * </p>
     *
     * @param searchDevicesRequest
     *        A {@link Consumer} that will call methods on {@link SearchDevicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchDevicesResponse> searchDevices(Consumer<SearchDevicesRequest.Builder> searchDevicesRequest) {
        return searchDevices(SearchDevicesRequest.builder().applyMutation(searchDevicesRequest).build());
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesPublisher publisher = client.searchDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesPublisher publisher = client.searchDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchDevicesPublisher searchDevicesPaginator(SearchDevicesRequest searchDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches devices and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesPublisher publisher = client.searchDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchDevicesPublisher publisher = client.searchDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDevices(software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchDevicesRequest#builder()}
     * </p>
     *
     * @param searchDevicesRequest
     *        A {@link Consumer} that will call methods on {@link SearchDevicesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchDevicesPublisher searchDevicesPaginator(Consumer<SearchDevicesRequest.Builder> searchDevicesRequest) {
        return searchDevicesPaginator(SearchDevicesRequest.builder().applyMutation(searchDevicesRequest).build());
    }

    /**
     * <p>
     * Searches network profiles and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchNetworkProfilesRequest
     * @return A Java Future containing the result of the SearchNetworkProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchNetworkProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchNetworkProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchNetworkProfilesResponse> searchNetworkProfiles(
            SearchNetworkProfilesRequest searchNetworkProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches network profiles and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchNetworkProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchNetworkProfilesRequest#builder()}
     * </p>
     *
     * @param searchNetworkProfilesRequest
     *        A {@link Consumer} that will call methods on {@link SearchNetworkProfilesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchNetworkProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchNetworkProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchNetworkProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchNetworkProfilesResponse> searchNetworkProfiles(
            Consumer<SearchNetworkProfilesRequest.Builder> searchNetworkProfilesRequest) {
        return searchNetworkProfiles(SearchNetworkProfilesRequest.builder().applyMutation(searchNetworkProfilesRequest).build());
    }

    /**
     * <p>
     * Searches network profiles and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchNetworkProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchNetworkProfilesPublisher publisher = client.searchNetworkProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchNetworkProfilesPublisher publisher = client.searchNetworkProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchNetworkProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchNetworkProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchNetworkProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchNetworkProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchNetworkProfilesPublisher searchNetworkProfilesPaginator(
            SearchNetworkProfilesRequest searchNetworkProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches network profiles and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchNetworkProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchNetworkProfilesPublisher publisher = client.searchNetworkProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchNetworkProfilesPublisher publisher = client.searchNetworkProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchNetworkProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchNetworkProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchNetworkProfilesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchNetworkProfilesRequest#builder()}
     * </p>
     *
     * @param searchNetworkProfilesRequest
     *        A {@link Consumer} that will call methods on {@link SearchNetworkProfilesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchNetworkProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchNetworkProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchNetworkProfilesPublisher searchNetworkProfilesPaginator(
            Consumer<SearchNetworkProfilesRequest.Builder> searchNetworkProfilesRequest) {
        return searchNetworkProfilesPaginator(SearchNetworkProfilesRequest.builder().applyMutation(searchNetworkProfilesRequest)
                .build());
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     *
     * @param searchProfilesRequest
     * @return A Java Future containing the result of the SearchProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchProfilesResponse> searchProfiles(SearchProfilesRequest searchProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchProfilesRequest#builder()}
     * </p>
     *
     * @param searchProfilesRequest
     *        A {@link Consumer} that will call methods on {@link SearchProfilesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchProfilesResponse> searchProfiles(Consumer<SearchProfilesRequest.Builder> searchProfilesRequest) {
        return searchProfiles(SearchProfilesRequest.builder().applyMutation(searchProfilesRequest).build());
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesPublisher publisher = client.searchProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesPublisher publisher = client.searchProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProfilesPublisher searchProfilesPaginator(SearchProfilesRequest searchProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches room profiles and lists the ones that meet a set of filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesPublisher publisher = client.searchProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchProfilesPublisher publisher = client.searchProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchProfiles(software.amazon.awssdk.services.alexaforbusiness.model.SearchProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchProfilesRequest#builder()}
     * </p>
     *
     * @param searchProfilesRequest
     *        A {@link Consumer} that will call methods on {@link SearchProfilesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProfilesPublisher searchProfilesPaginator(Consumer<SearchProfilesRequest.Builder> searchProfilesRequest) {
        return searchProfilesPaginator(SearchProfilesRequest.builder().applyMutation(searchProfilesRequest).build());
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchRoomsRequest
     * @return A Java Future containing the result of the SearchRooms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchRoomsResponse> searchRooms(SearchRoomsRequest searchRoomsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRoomsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchRoomsRequest#builder()}
     * </p>
     *
     * @param searchRoomsRequest
     *        A {@link Consumer} that will call methods on {@link SearchRoomsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchRooms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchRoomsResponse> searchRooms(Consumer<SearchRoomsRequest.Builder> searchRoomsRequest) {
        return searchRooms(SearchRoomsRequest.builder().applyMutation(searchRoomsRequest).build());
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsPublisher publisher = client.searchRoomsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsPublisher publisher = client.searchRoomsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation.</b>
     * </p>
     *
     * @param searchRoomsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchRoomsPublisher searchRoomsPaginator(SearchRoomsRequest searchRoomsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches rooms and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsPublisher publisher = client.searchRoomsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchRoomsPublisher publisher = client.searchRoomsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchRooms(software.amazon.awssdk.services.alexaforbusiness.model.SearchRoomsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRoomsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchRoomsRequest#builder()}
     * </p>
     *
     * @param searchRoomsRequest
     *        A {@link Consumer} that will call methods on {@link SearchRoomsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchRooms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchRooms" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchRoomsPublisher searchRoomsPaginator(Consumer<SearchRoomsRequest.Builder> searchRoomsRequest) {
        return searchRoomsPaginator(SearchRoomsRequest.builder().applyMutation(searchRoomsRequest).build());
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchSkillGroupsRequest
     * @return A Java Future containing the result of the SearchSkillGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchSkillGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchSkillGroupsResponse> searchSkillGroups(SearchSkillGroupsRequest searchSkillGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSkillGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link SearchSkillGroupsRequest#builder()}
     * </p>
     *
     * @param searchSkillGroupsRequest
     *        A {@link Consumer} that will call methods on {@link SearchSkillGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchSkillGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchSkillGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchSkillGroupsResponse> searchSkillGroups(
            Consumer<SearchSkillGroupsRequest.Builder> searchSkillGroupsRequest) {
        return searchSkillGroups(SearchSkillGroupsRequest.builder().applyMutation(searchSkillGroupsRequest).build());
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsPublisher publisher = client.searchSkillGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsPublisher publisher = client.searchSkillGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchSkillGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchSkillGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSkillGroupsPublisher searchSkillGroupsPaginator(SearchSkillGroupsRequest searchSkillGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches skill groups and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsPublisher publisher = client.searchSkillGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchSkillGroupsPublisher publisher = client.searchSkillGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSkillGroups(software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSkillGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link SearchSkillGroupsRequest#builder()}
     * </p>
     *
     * @param searchSkillGroupsRequest
     *        A {@link Consumer} that will call methods on {@link SearchSkillGroupsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchSkillGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchSkillGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSkillGroupsPublisher searchSkillGroupsPaginator(
            Consumer<SearchSkillGroupsRequest.Builder> searchSkillGroupsRequest) {
        return searchSkillGroupsPaginator(SearchSkillGroupsRequest.builder().applyMutation(searchSkillGroupsRequest).build());
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     *
     * @param searchUsersRequest
     * @return A Java Future containing the result of the SearchUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchUsersResponse> searchUsers(SearchUsersRequest searchUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchUsersRequest.Builder} avoiding the need to
     * create one manually via {@link SearchUsersRequest#builder()}
     * </p>
     *
     * @param searchUsersRequest
     *        A {@link Consumer} that will call methods on {@link SearchUsersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SearchUsersResponse> searchUsers(Consumer<SearchUsersRequest.Builder> searchUsersRequest) {
        return searchUsers(SearchUsersRequest.builder().applyMutation(searchUsersRequest).build());
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersPublisher publisher = client.searchUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersPublisher publisher = client.searchUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation.</b>
     * </p>
     *
     * @param searchUsersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchUsersPublisher searchUsersPaginator(SearchUsersRequest searchUsersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches users and lists the ones that meet a set of filter and sort criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersPublisher publisher = client.searchUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.alexaforbusiness.paginators.SearchUsersPublisher publisher = client.searchUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchUsers(software.amazon.awssdk.services.alexaforbusiness.model.SearchUsersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchUsersRequest.Builder} avoiding the need to
     * create one manually via {@link SearchUsersRequest#builder()}
     * </p>
     *
     * @param searchUsersRequest
     *        A {@link Consumer} that will call methods on {@link SearchUsersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SearchUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchUsers" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchUsersPublisher searchUsersPaginator(Consumer<SearchUsersRequest.Builder> searchUsersRequest) {
        return searchUsersPaginator(SearchUsersRequest.builder().applyMutation(searchUsersRequest).build());
    }

    /**
     * <p>
     * Triggers an asynchronous flow to send text, SSML, or audio announcements to rooms that are identified by a search
     * or filter.
     * </p>
     *
     * @param sendAnnouncementRequest
     * @return A Java Future containing the result of the SendAnnouncement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SendAnnouncement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendAnnouncementResponse> sendAnnouncement(SendAnnouncementRequest sendAnnouncementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Triggers an asynchronous flow to send text, SSML, or audio announcements to rooms that are identified by a search
     * or filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendAnnouncementRequest.Builder} avoiding the need
     * to create one manually via {@link SendAnnouncementRequest#builder()}
     * </p>
     *
     * @param sendAnnouncementRequest
     *        A {@link Consumer} that will call methods on {@link SendAnnouncementRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SendAnnouncement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException You are performing an action that would put you beyond your account's limits.</li>
     *         <li>AlreadyExistsException The resource being created already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SendAnnouncement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendAnnouncement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendAnnouncementResponse> sendAnnouncement(
            Consumer<SendAnnouncementRequest.Builder> sendAnnouncementRequest) {
        return sendAnnouncement(SendAnnouncementRequest.builder().applyMutation(sendAnnouncementRequest).build());
    }

    /**
     * <p>
     * Sends an enrollment invitation email with a URL to a user. The URL is valid for 30 days or until you call this
     * operation again, whichever comes first.
     * </p>
     *
     * @param sendInvitationRequest
     * @return A Java Future containing the result of the SendInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>InvalidUserStatusException The attempt to update a user is invalid due to the user's current status.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SendInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendInvitationResponse> sendInvitation(SendInvitationRequest sendInvitationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends an enrollment invitation email with a URL to a user. The URL is valid for 30 days or until you call this
     * operation again, whichever comes first.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendInvitationRequest.Builder} avoiding the need to
     * create one manually via {@link SendInvitationRequest#builder()}
     * </p>
     *
     * @param sendInvitationRequest
     *        A {@link Consumer} that will call methods on {@link SendInvitationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SendInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>InvalidUserStatusException The attempt to update a user is invalid due to the user's current status.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.SendInvitation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SendInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SendInvitationResponse> sendInvitation(Consumer<SendInvitationRequest.Builder> sendInvitationRequest) {
        return sendInvitation(SendInvitationRequest.builder().applyMutation(sendInvitationRequest).build());
    }

    /**
     * <p>
     * Resets a device and its account to the known default settings. This clears all information and settings set by
     * previous users in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Bluetooth - This unpairs all bluetooth devices paired with your echo device.
     * </p>
     * </li>
     * <li>
     * <p>
     * Volume - This resets the echo device's volume to the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notifications - This clears all notifications from your echo device.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists - This clears all to-do items from your echo device.
     * </p>
     * </li>
     * <li>
     * <p>
     * Settings - This internally syncs the room's profile (if the device is assigned to a room), contacts, address
     * books, delegation access for account linking, and communications (if enabled on the room profile).
     * </p>
     * </li>
     * </ul>
     *
     * @param startDeviceSyncRequest
     * @return A Java Future containing the result of the StartDeviceSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.StartDeviceSync
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartDeviceSync"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDeviceSyncResponse> startDeviceSync(StartDeviceSyncRequest startDeviceSyncRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resets a device and its account to the known default settings. This clears all information and settings set by
     * previous users in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Bluetooth - This unpairs all bluetooth devices paired with your echo device.
     * </p>
     * </li>
     * <li>
     * <p>
     * Volume - This resets the echo device's volume to the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notifications - This clears all notifications from your echo device.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists - This clears all to-do items from your echo device.
     * </p>
     * </li>
     * <li>
     * <p>
     * Settings - This internally syncs the room's profile (if the device is assigned to a room), contacts, address
     * books, delegation access for account linking, and communications (if enabled on the room profile).
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDeviceSyncRequest.Builder} avoiding the need
     * to create one manually via {@link StartDeviceSyncRequest#builder()}
     * </p>
     *
     * @param startDeviceSyncRequest
     *        A {@link Consumer} that will call methods on {@link StartDeviceSyncRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartDeviceSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.StartDeviceSync
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartDeviceSync"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartDeviceSyncResponse> startDeviceSync(
            Consumer<StartDeviceSyncRequest.Builder> startDeviceSyncRequest) {
        return startDeviceSync(StartDeviceSyncRequest.builder().applyMutation(startDeviceSyncRequest).build());
    }

    /**
     * <p>
     * Initiates the discovery of any smart home appliances associated with the room.
     * </p>
     *
     * @param startSmartHomeApplianceDiscoveryRequest
     * @return A Java Future containing the result of the StartSmartHomeApplianceDiscovery operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.StartSmartHomeApplianceDiscovery
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartSmartHomeApplianceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSmartHomeApplianceDiscoveryResponse> startSmartHomeApplianceDiscovery(
            StartSmartHomeApplianceDiscoveryRequest startSmartHomeApplianceDiscoveryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates the discovery of any smart home appliances associated with the room.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSmartHomeApplianceDiscoveryRequest.Builder}
     * avoiding the need to create one manually via {@link StartSmartHomeApplianceDiscoveryRequest#builder()}
     * </p>
     *
     * @param startSmartHomeApplianceDiscoveryRequest
     *        A {@link Consumer} that will call methods on {@link StartSmartHomeApplianceDiscoveryRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartSmartHomeApplianceDiscovery operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.StartSmartHomeApplianceDiscovery
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/StartSmartHomeApplianceDiscovery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSmartHomeApplianceDiscoveryResponse> startSmartHomeApplianceDiscovery(
            Consumer<StartSmartHomeApplianceDiscoveryRequest.Builder> startSmartHomeApplianceDiscoveryRequest) {
        return startSmartHomeApplianceDiscovery(StartSmartHomeApplianceDiscoveryRequest.builder()
                .applyMutation(startSmartHomeApplianceDiscoveryRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates address book details by the address book ARN.
     * </p>
     *
     * @param updateAddressBookRequest
     * @return A Java Future containing the result of the UpdateAddressBook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAddressBookResponse> updateAddressBook(UpdateAddressBookRequest updateAddressBookRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates address book details by the address book ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAddressBookRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAddressBookRequest#builder()}
     * </p>
     *
     * @param updateAddressBookRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAddressBookRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateAddressBook operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateAddressBook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateAddressBook"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAddressBookResponse> updateAddressBook(
            Consumer<UpdateAddressBookRequest.Builder> updateAddressBookRequest) {
        return updateAddressBook(UpdateAddressBookRequest.builder().applyMutation(updateAddressBookRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of the report delivery schedule with the specified schedule ARN.
     * </p>
     *
     * @param updateBusinessReportScheduleRequest
     * @return A Java Future containing the result of the UpdateBusinessReportSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateBusinessReportSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBusinessReportScheduleResponse> updateBusinessReportSchedule(
            UpdateBusinessReportScheduleRequest updateBusinessReportScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of the report delivery schedule with the specified schedule ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBusinessReportScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateBusinessReportScheduleRequest#builder()}
     * </p>
     *
     * @param updateBusinessReportScheduleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBusinessReportScheduleRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateBusinessReportSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateBusinessReportSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateBusinessReportSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBusinessReportScheduleResponse> updateBusinessReportSchedule(
            Consumer<UpdateBusinessReportScheduleRequest.Builder> updateBusinessReportScheduleRequest) {
        return updateBusinessReportSchedule(UpdateBusinessReportScheduleRequest.builder()
                .applyMutation(updateBusinessReportScheduleRequest).build());
    }

    /**
     * <p>
     * Updates an existing conference provider's settings.
     * </p>
     *
     * @param updateConferenceProviderRequest
     * @return A Java Future containing the result of the UpdateConferenceProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConferenceProviderResponse> updateConferenceProvider(
            UpdateConferenceProviderRequest updateConferenceProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing conference provider's settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConferenceProviderRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateConferenceProviderRequest#builder()}
     * </p>
     *
     * @param updateConferenceProviderRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConferenceProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateConferenceProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateConferenceProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateConferenceProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConferenceProviderResponse> updateConferenceProvider(
            Consumer<UpdateConferenceProviderRequest.Builder> updateConferenceProviderRequest) {
        return updateConferenceProvider(UpdateConferenceProviderRequest.builder().applyMutation(updateConferenceProviderRequest)
                .build());
    }

    /**
     * <p>
     * Updates the contact details by the contact ARN.
     * </p>
     *
     * @param updateContactRequest
     * @return A Java Future containing the result of the UpdateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateContactResponse> updateContact(UpdateContactRequest updateContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the contact details by the contact ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateContactRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateContactRequest#builder()}
     * </p>
     *
     * @param updateContactRequest
     *        A {@link Consumer} that will call methods on {@link UpdateContactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateContact
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateContact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateContactResponse> updateContact(Consumer<UpdateContactRequest.Builder> updateContactRequest) {
        return updateContact(UpdateContactRequest.builder().applyMutation(updateContactRequest).build());
    }

    /**
     * <p>
     * Updates the device name by device ARN.
     * </p>
     *
     * @param updateDeviceRequest
     * @return A Java Future containing the result of the UpdateDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDeviceResponse> updateDevice(UpdateDeviceRequest updateDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the device name by device ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDeviceRequest#builder()}
     * </p>
     *
     * @param updateDeviceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>DeviceNotRegisteredException The request failed because this device is no longer registered and
     *         therefore no longer managed by this account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDeviceResponse> updateDevice(Consumer<UpdateDeviceRequest.Builder> updateDeviceRequest) {
        return updateDevice(UpdateDeviceRequest.builder().applyMutation(updateDeviceRequest).build());
    }

    /**
     * <p>
     * Updates the details of a gateway. If any optional field is not provided, the existing corresponding value is left
     * unmodified.
     * </p>
     *
     * @param updateGatewayRequest
     * @return A Java Future containing the result of the UpdateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayResponse> updateGateway(UpdateGatewayRequest updateGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details of a gateway. If any optional field is not provided, the existing corresponding value is left
     * unmodified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGatewayRequest#builder()}
     * </p>
     *
     * @param updateGatewayRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGatewayRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGateway" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayResponse> updateGateway(Consumer<UpdateGatewayRequest.Builder> updateGatewayRequest) {
        return updateGateway(UpdateGatewayRequest.builder().applyMutation(updateGatewayRequest).build());
    }

    /**
     * <p>
     * Updates the details of a gateway group. If any optional field is not provided, the existing corresponding value
     * is left unmodified.
     * </p>
     *
     * @param updateGatewayGroupRequest
     * @return A Java Future containing the result of the UpdateGatewayGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayGroupResponse> updateGatewayGroup(UpdateGatewayGroupRequest updateGatewayGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details of a gateway group. If any optional field is not provided, the existing corresponding value
     * is left unmodified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGatewayGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGatewayGroupRequest#builder()}
     * </p>
     *
     * @param updateGatewayGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGatewayGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateGatewayGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateGatewayGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateGatewayGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGatewayGroupResponse> updateGatewayGroup(
            Consumer<UpdateGatewayGroupRequest.Builder> updateGatewayGroupRequest) {
        return updateGatewayGroup(UpdateGatewayGroupRequest.builder().applyMutation(updateGatewayGroupRequest).build());
    }

    /**
     * <p>
     * Updates a network profile by the network profile ARN.
     * </p>
     *
     * @param updateNetworkProfileRequest
     * @return A Java Future containing the result of the UpdateNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>InvalidCertificateAuthorityException The Certificate Authority can't issue or revoke a certificate.</li>
     *         <li>InvalidSecretsManagerResourceException A password in SecretsManager is in an invalid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNetworkProfileResponse> updateNetworkProfile(
            UpdateNetworkProfileRequest updateNetworkProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a network profile by the network profile ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNetworkProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNetworkProfileRequest#builder()}
     * </p>
     *
     * @param updateNetworkProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNetworkProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateNetworkProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>InvalidCertificateAuthorityException The Certificate Authority can't issue or revoke a certificate.</li>
     *         <li>InvalidSecretsManagerResourceException A password in SecretsManager is in an invalid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateNetworkProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateNetworkProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNetworkProfileResponse> updateNetworkProfile(
            Consumer<UpdateNetworkProfileRequest.Builder> updateNetworkProfileRequest) {
        return updateNetworkProfile(UpdateNetworkProfileRequest.builder().applyMutation(updateNetworkProfileRequest).build());
    }

    /**
     * <p>
     * Updates an existing room profile by room profile ARN.
     * </p>
     *
     * @param updateProfileRequest
     * @return A Java Future containing the result of the UpdateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateProfileResponse> updateProfile(UpdateProfileRequest updateProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing room profile by room profile ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProfileRequest#builder()}
     * </p>
     *
     * @param updateProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateProfileResponse> updateProfile(Consumer<UpdateProfileRequest.Builder> updateProfileRequest) {
        return updateProfile(UpdateProfileRequest.builder().applyMutation(updateProfileRequest).build());
    }

    /**
     * <p>
     * Updates room details by room ARN.
     * </p>
     *
     * @param updateRoomRequest
     * @return A Java Future containing the result of the UpdateRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateRoomResponse> updateRoom(UpdateRoomRequest updateRoomRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates room details by room ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRoomRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRoomRequest#builder()}
     * </p>
     *
     * @param updateRoomRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRoomRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateRoom operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateRoom
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateRoom" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateRoomResponse> updateRoom(Consumer<UpdateRoomRequest.Builder> updateRoomRequest) {
        return updateRoom(UpdateRoomRequest.builder().applyMutation(updateRoomRequest).build());
    }

    /**
     * <p>
     * Updates skill group details by skill group ARN.
     * </p>
     *
     * @param updateSkillGroupRequest
     * @return A Java Future containing the result of the UpdateSkillGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSkillGroupResponse> updateSkillGroup(UpdateSkillGroupRequest updateSkillGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates skill group details by skill group ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSkillGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSkillGroupRequest#builder()}
     * </p>
     *
     * @param updateSkillGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSkillGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSkillGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource is not found.</li>
     *         <li>NameInUseException The name sent in the request is already in use.</li>
     *         <li>ConcurrentModificationException There is a concurrent modification of resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AlexaForBusinessException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AlexaForBusinessAsyncClient.UpdateSkillGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateSkillGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSkillGroupResponse> updateSkillGroup(
            Consumer<UpdateSkillGroupRequest.Builder> updateSkillGroupRequest) {
        return updateSkillGroup(UpdateSkillGroupRequest.builder().applyMutation(updateSkillGroupRequest).build());
    }
}
