/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.NetworkEapMethod;
import software.amazon.awssdk.services.alexaforbusiness.model.NetworkSecurityType;
import software.amazon.awssdk.services.alexaforbusiness.model.TrustAnchorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNetworkProfileRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, CreateNetworkProfileRequest> {
    private static final SdkField<String> NETWORK_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNetworkProfileRequest.getter(CreateNetworkProfileRequest::networkProfileName)).setter(CreateNetworkProfileRequest.setter(Builder::networkProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkProfileName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNetworkProfileRequest.getter(CreateNetworkProfileRequest::description)).setter(CreateNetworkProfileRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SSID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNetworkProfileRequest.getter(CreateNetworkProfileRequest::ssid)).setter(CreateNetworkProfileRequest.setter(Builder::ssid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ssid").build()}).build();
    private static final SdkField<String> SECURITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNetworkProfileRequest.getter(CreateNetworkProfileRequest::securityTypeAsString)).setter(CreateNetworkProfileRequest.setter(Builder::securityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityType").build()}).build();
    private static final SdkField<String> EAP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNetworkProfileRequest.getter(CreateNetworkProfileRequest::eapMethodAsString)).setter(CreateNetworkProfileRequest.setter(Builder::eapMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EapMethod").build()}).build();
    private static final SdkField<String> CURRENT_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNetworkProfileRequest.getter(CreateNetworkProfileRequest::currentPassword)).setter(CreateNetworkProfileRequest.setter(Builder::currentPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentPassword").build()}).build();
    private static final SdkField<String> NEXT_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNetworkProfileRequest.getter(CreateNetworkProfileRequest::nextPassword)).setter(CreateNetworkProfileRequest.setter(Builder::nextPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPassword").build()}).build();
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNetworkProfileRequest.getter(CreateNetworkProfileRequest::certificateAuthorityArn)).setter(CreateNetworkProfileRequest.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<List<String>> TRUST_ANCHORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateNetworkProfileRequest.getter(CreateNetworkProfileRequest::trustAnchors)).setter(CreateNetworkProfileRequest.setter(Builder::trustAnchors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustAnchors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateNetworkProfileRequest.getter(CreateNetworkProfileRequest::clientRequestToken)).setter(CreateNetworkProfileRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PROFILE_NAME_FIELD, DESCRIPTION_FIELD, SSID_FIELD, SECURITY_TYPE_FIELD, EAP_METHOD_FIELD, CURRENT_PASSWORD_FIELD, NEXT_PASSWORD_FIELD, CERTIFICATE_AUTHORITY_ARN_FIELD, TRUST_ANCHORS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String networkProfileName;
    private final String description;
    private final String ssid;
    private final String securityType;
    private final String eapMethod;
    private final String currentPassword;
    private final String nextPassword;
    private final String certificateAuthorityArn;
    private final List<String> trustAnchors;
    private final String clientRequestToken;

    private CreateNetworkProfileRequest(BuilderImpl builder) {
        super(builder);
        this.networkProfileName = builder.networkProfileName;
        this.description = builder.description;
        this.ssid = builder.ssid;
        this.securityType = builder.securityType;
        this.eapMethod = builder.eapMethod;
        this.currentPassword = builder.currentPassword;
        this.nextPassword = builder.nextPassword;
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.trustAnchors = builder.trustAnchors;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public String networkProfileName() {
        return this.networkProfileName;
    }

    public String description() {
        return this.description;
    }

    public String ssid() {
        return this.ssid;
    }

    public NetworkSecurityType securityType() {
        return NetworkSecurityType.fromValue(this.securityType);
    }

    public String securityTypeAsString() {
        return this.securityType;
    }

    public NetworkEapMethod eapMethod() {
        return NetworkEapMethod.fromValue(this.eapMethod);
    }

    public String eapMethodAsString() {
        return this.eapMethod;
    }

    public String currentPassword() {
        return this.currentPassword;
    }

    public String nextPassword() {
        return this.nextPassword;
    }

    public String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public List<String> trustAnchors() {
        return this.trustAnchors;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssid());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eapMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustAnchors());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkProfileRequest)) {
            return false;
        }
        CreateNetworkProfileRequest other = (CreateNetworkProfileRequest)((Object)obj);
        return Objects.equals(this.networkProfileName(), other.networkProfileName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ssid(), other.ssid()) && Objects.equals(this.securityTypeAsString(), other.securityTypeAsString()) && Objects.equals(this.eapMethodAsString(), other.eapMethodAsString()) && Objects.equals(this.currentPassword(), other.currentPassword()) && Objects.equals(this.nextPassword(), other.nextPassword()) && Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && Objects.equals(this.trustAnchors(), other.trustAnchors()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateNetworkProfileRequest").add("NetworkProfileName", (Object)this.networkProfileName()).add("Description", (Object)this.description()).add("Ssid", (Object)this.ssid()).add("SecurityType", (Object)this.securityTypeAsString()).add("EapMethod", (Object)this.eapMethodAsString()).add("CurrentPassword", (Object)(this.currentPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("NextPassword", (Object)(this.nextPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("TrustAnchors", this.trustAnchors()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkProfileName": {
                return Optional.ofNullable(clazz.cast(this.networkProfileName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Ssid": {
                return Optional.ofNullable(clazz.cast(this.ssid()));
            }
            case "SecurityType": {
                return Optional.ofNullable(clazz.cast(this.securityTypeAsString()));
            }
            case "EapMethod": {
                return Optional.ofNullable(clazz.cast(this.eapMethodAsString()));
            }
            case "CurrentPassword": {
                return Optional.ofNullable(clazz.cast(this.currentPassword()));
            }
            case "NextPassword": {
                return Optional.ofNullable(clazz.cast(this.nextPassword()));
            }
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "TrustAnchors": {
                return Optional.ofNullable(clazz.cast(this.trustAnchors()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkProfileRequest, T> g) {
        return obj -> g.apply((CreateNetworkProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String networkProfileName;
        private String description;
        private String ssid;
        private String securityType;
        private String eapMethod;
        private String currentPassword;
        private String nextPassword;
        private String certificateAuthorityArn;
        private List<String> trustAnchors = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkProfileRequest model) {
            super(model);
            this.networkProfileName(model.networkProfileName);
            this.description(model.description);
            this.ssid(model.ssid);
            this.securityType(model.securityType);
            this.eapMethod(model.eapMethod);
            this.currentPassword(model.currentPassword);
            this.nextPassword(model.nextPassword);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.trustAnchors(model.trustAnchors);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getNetworkProfileName() {
            return this.networkProfileName;
        }

        @Override
        public final Builder networkProfileName(String networkProfileName) {
            this.networkProfileName = networkProfileName;
            return this;
        }

        public final void setNetworkProfileName(String networkProfileName) {
            this.networkProfileName = networkProfileName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSsid() {
            return this.ssid;
        }

        @Override
        public final Builder ssid(String ssid) {
            this.ssid = ssid;
            return this;
        }

        public final void setSsid(String ssid) {
            this.ssid = ssid;
        }

        public final String getSecurityTypeAsString() {
            return this.securityType;
        }

        @Override
        public final Builder securityType(String securityType) {
            this.securityType = securityType;
            return this;
        }

        @Override
        public final Builder securityType(NetworkSecurityType securityType) {
            this.securityType(securityType == null ? null : securityType.toString());
            return this;
        }

        public final void setSecurityType(String securityType) {
            this.securityType = securityType;
        }

        public final String getEapMethodAsString() {
            return this.eapMethod;
        }

        @Override
        public final Builder eapMethod(String eapMethod) {
            this.eapMethod = eapMethod;
            return this;
        }

        @Override
        public final Builder eapMethod(NetworkEapMethod eapMethod) {
            this.eapMethod(eapMethod == null ? null : eapMethod.toString());
            return this;
        }

        public final void setEapMethod(String eapMethod) {
            this.eapMethod = eapMethod;
        }

        public final String getCurrentPassword() {
            return this.currentPassword;
        }

        @Override
        public final Builder currentPassword(String currentPassword) {
            this.currentPassword = currentPassword;
            return this;
        }

        public final void setCurrentPassword(String currentPassword) {
            this.currentPassword = currentPassword;
        }

        public final String getNextPassword() {
            return this.nextPassword;
        }

        @Override
        public final Builder nextPassword(String nextPassword) {
            this.nextPassword = nextPassword;
            return this;
        }

        public final void setNextPassword(String nextPassword) {
            this.nextPassword = nextPassword;
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        public final Collection<String> getTrustAnchors() {
            return this.trustAnchors;
        }

        @Override
        public final Builder trustAnchors(Collection<String> trustAnchors) {
            this.trustAnchors = TrustAnchorListCopier.copy(trustAnchors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustAnchors(String ... trustAnchors) {
            this.trustAnchors(Arrays.asList(trustAnchors));
            return this;
        }

        public final void setTrustAnchors(Collection<String> trustAnchors) {
            this.trustAnchors = TrustAnchorListCopier.copy(trustAnchors);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkProfileRequest build() {
            return new CreateNetworkProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNetworkProfileRequest> {
        public Builder networkProfileName(String var1);

        public Builder description(String var1);

        public Builder ssid(String var1);

        public Builder securityType(String var1);

        public Builder securityType(NetworkSecurityType var1);

        public Builder eapMethod(String var1);

        public Builder eapMethod(NetworkEapMethod var1);

        public Builder currentPassword(String var1);

        public Builder nextPassword(String var1);

        public Builder certificateAuthorityArn(String var1);

        public Builder trustAnchors(Collection<String> var1);

        public Builder trustAnchors(String ... var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

