/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterAvsDeviceRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<RegisterAvsDeviceRequest.Builder, RegisterAvsDeviceRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterAvsDeviceRequest::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> USER_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterAvsDeviceRequest::userCode)).setter(setter(Builder::userCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCode").build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterAvsDeviceRequest::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> DEVICE_SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterAvsDeviceRequest::deviceSerialNumber)).setter(setter(Builder::deviceSerialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSerialNumber").build())
            .build();

    private static final SdkField<String> AMAZON_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterAvsDeviceRequest::amazonId)).setter(setter(Builder::amazonId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            USER_CODE_FIELD, PRODUCT_ID_FIELD, DEVICE_SERIAL_NUMBER_FIELD, AMAZON_ID_FIELD));

    private final String clientId;

    private final String userCode;

    private final String productId;

    private final String deviceSerialNumber;

    private final String amazonId;

    private RegisterAvsDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.userCode = builder.userCode;
        this.productId = builder.productId;
        this.deviceSerialNumber = builder.deviceSerialNumber;
        this.amazonId = builder.amazonId;
    }

    /**
     * <p>
     * The client ID of the OEM used for code-based linking authorization on an AVS device.
     * </p>
     * 
     * @return The client ID of the OEM used for code-based linking authorization on an AVS device.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device
     * Authorization Request component of the OAuth code-based linking specification.
     * </p>
     * 
     * @return The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device
     *         Authorization Request component of the OAuth code-based linking specification.
     */
    public String userCode() {
        return userCode;
    }

    /**
     * <p>
     * The product ID used to identify your AVS device during authorization.
     * </p>
     * 
     * @return The product ID used to identify your AVS device during authorization.
     */
    public String productId() {
        return productId;
    }

    /**
     * <p>
     * The key generated by the OEM that uniquely identifies a specified instance of your AVS device.
     * </p>
     * 
     * @return The key generated by the OEM that uniquely identifies a specified instance of your AVS device.
     */
    public String deviceSerialNumber() {
        return deviceSerialNumber;
    }

    /**
     * <p>
     * The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon's
     * Developer Console.
     * </p>
     * 
     * @return The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon's
     *         Developer Console.
     */
    public String amazonId() {
        return amazonId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(userCode());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceSerialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(amazonId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterAvsDeviceRequest)) {
            return false;
        }
        RegisterAvsDeviceRequest other = (RegisterAvsDeviceRequest) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(userCode(), other.userCode())
                && Objects.equals(productId(), other.productId())
                && Objects.equals(deviceSerialNumber(), other.deviceSerialNumber())
                && Objects.equals(amazonId(), other.amazonId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RegisterAvsDeviceRequest").add("ClientId", clientId()).add("UserCode", userCode())
                .add("ProductId", productId()).add("DeviceSerialNumber", deviceSerialNumber()).add("AmazonId", amazonId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "UserCode":
            return Optional.ofNullable(clazz.cast(userCode()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "DeviceSerialNumber":
            return Optional.ofNullable(clazz.cast(deviceSerialNumber()));
        case "AmazonId":
            return Optional.ofNullable(clazz.cast(amazonId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterAvsDeviceRequest, T> g) {
        return obj -> g.apply((RegisterAvsDeviceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterAvsDeviceRequest> {
        /**
         * <p>
         * The client ID of the OEM used for code-based linking authorization on an AVS device.
         * </p>
         * 
         * @param clientId
         *        The client ID of the OEM used for code-based linking authorization on an AVS device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device
         * Authorization Request component of the OAuth code-based linking specification.
         * </p>
         * 
         * @param userCode
         *        The code that is obtained after your AVS device has made a POST request to LWA as a part of the Device
         *        Authorization Request component of the OAuth code-based linking specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userCode(String userCode);

        /**
         * <p>
         * The product ID used to identify your AVS device during authorization.
         * </p>
         * 
         * @param productId
         *        The product ID used to identify your AVS device during authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * The key generated by the OEM that uniquely identifies a specified instance of your AVS device.
         * </p>
         * 
         * @param deviceSerialNumber
         *        The key generated by the OEM that uniquely identifies a specified instance of your AVS device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceSerialNumber(String deviceSerialNumber);

        /**
         * <p>
         * The device type ID for your AVS device generated by Amazon when the OEM creates a new product on Amazon's
         * Developer Console.
         * </p>
         * 
         * @param amazonId
         *        The device type ID for your AVS device generated by Amazon when the OEM creates a new product on
         *        Amazon's Developer Console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonId(String amazonId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String clientId;

        private String userCode;

        private String productId;

        private String deviceSerialNumber;

        private String amazonId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterAvsDeviceRequest model) {
            super(model);
            clientId(model.clientId);
            userCode(model.userCode);
            productId(model.productId);
            deviceSerialNumber(model.deviceSerialNumber);
            amazonId(model.amazonId);
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getUserCode() {
            return userCode;
        }

        @Override
        public final Builder userCode(String userCode) {
            this.userCode = userCode;
            return this;
        }

        public final void setUserCode(String userCode) {
            this.userCode = userCode;
        }

        public final String getProductId() {
            return productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getDeviceSerialNumber() {
            return deviceSerialNumber;
        }

        @Override
        public final Builder deviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
            return this;
        }

        public final void setDeviceSerialNumber(String deviceSerialNumber) {
            this.deviceSerialNumber = deviceSerialNumber;
        }

        public final String getAmazonId() {
            return amazonId;
        }

        @Override
        public final Builder amazonId(String amazonId) {
            this.amazonId = amazonId;
            return this;
        }

        public final void setAmazonId(String amazonId) {
            this.amazonId = amazonId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterAvsDeviceRequest build() {
            return new RegisterAvsDeviceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
