/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceEvent;
import software.amazon.awssdk.services.alexaforbusiness.model.DeviceEventListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeviceEventsResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, ListDeviceEventsResponse> {
    private static final SdkField<List<DeviceEvent>> DEVICE_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDeviceEventsResponse.getter(ListDeviceEventsResponse::deviceEvents)).setter(ListDeviceEventsResponse.setter(Builder::deviceEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDeviceEventsResponse.getter(ListDeviceEventsResponse::nextToken)).setter(ListDeviceEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_EVENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DeviceEvent> deviceEvents;
    private final String nextToken;

    private ListDeviceEventsResponse(BuilderImpl builder) {
        super(builder);
        this.deviceEvents = builder.deviceEvents;
        this.nextToken = builder.nextToken;
    }

    public List<DeviceEvent> deviceEvents() {
        return this.deviceEvents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceEventsResponse)) {
            return false;
        }
        ListDeviceEventsResponse other = (ListDeviceEventsResponse)((Object)obj);
        return Objects.equals(this.deviceEvents(), other.deviceEvents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDeviceEventsResponse").add("DeviceEvents", this.deviceEvents()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceEvents": {
                return Optional.ofNullable(clazz.cast(this.deviceEvents()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceEventsResponse, T> g) {
        return obj -> g.apply((ListDeviceEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<DeviceEvent> deviceEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceEventsResponse model) {
            super(model);
            this.deviceEvents(model.deviceEvents);
            this.nextToken(model.nextToken);
        }

        public final Collection<DeviceEvent.Builder> getDeviceEvents() {
            return this.deviceEvents != null ? (Collection)this.deviceEvents.stream().map(DeviceEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deviceEvents(Collection<DeviceEvent> deviceEvents) {
            this.deviceEvents = DeviceEventListCopier.copy(deviceEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceEvents(DeviceEvent ... deviceEvents) {
            this.deviceEvents(Arrays.asList(deviceEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceEvents(Consumer<DeviceEvent.Builder> ... deviceEvents) {
            this.deviceEvents(Stream.of(deviceEvents).map(c -> (DeviceEvent)((DeviceEvent.Builder)DeviceEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeviceEvents(Collection<DeviceEvent.BuilderImpl> deviceEvents) {
            this.deviceEvents = DeviceEventListCopier.copyFromBuilder(deviceEvents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeviceEventsResponse build() {
            return new ListDeviceEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeviceEventsResponse> {
        public Builder deviceEvents(Collection<DeviceEvent> var1);

        public Builder deviceEvents(DeviceEvent ... var1);

        public Builder deviceEvents(Consumer<DeviceEvent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

