/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of a gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GatewaySummary implements SdkPojo, Serializable, ToCopyableBuilder<GatewaySummary.Builder, GatewaySummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GatewaySummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GatewaySummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GatewaySummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> GATEWAY_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GatewaySummary::gatewayGroupArn)).setter(setter(Builder::gatewayGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayGroupArn").build()).build();

    private static final SdkField<String> SOFTWARE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GatewaySummary::softwareVersion)).setter(setter(Builder::softwareVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, GATEWAY_GROUP_ARN_FIELD, SOFTWARE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String description;

    private final String gatewayGroupArn;

    private final String softwareVersion;

    private GatewaySummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.gatewayGroupArn = builder.gatewayGroupArn;
        this.softwareVersion = builder.softwareVersion;
    }

    /**
     * <p>
     * The ARN of the gateway.
     * </p>
     * 
     * @return The ARN of the gateway.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the gateway.
     * </p>
     * 
     * @return The name of the gateway.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the gateway.
     * </p>
     * 
     * @return The description of the gateway.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the gateway group that the gateway is associated to.
     * </p>
     * 
     * @return The ARN of the gateway group that the gateway is associated to.
     */
    public String gatewayGroupArn() {
        return gatewayGroupArn;
    }

    /**
     * <p>
     * The software version of the gateway. The gateway automatically updates its software version during normal
     * operation.
     * </p>
     * 
     * @return The software version of the gateway. The gateway automatically updates its software version during normal
     *         operation.
     */
    public String softwareVersion() {
        return softwareVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(softwareVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewaySummary)) {
            return false;
        }
        GatewaySummary other = (GatewaySummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(gatewayGroupArn(), other.gatewayGroupArn())
                && Objects.equals(softwareVersion(), other.softwareVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GatewaySummary").add("Arn", arn()).add("Name", name()).add("Description", description())
                .add("GatewayGroupArn", gatewayGroupArn()).add("SoftwareVersion", softwareVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "GatewayGroupArn":
            return Optional.ofNullable(clazz.cast(gatewayGroupArn()));
        case "SoftwareVersion":
            return Optional.ofNullable(clazz.cast(softwareVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GatewaySummary, T> g) {
        return obj -> g.apply((GatewaySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GatewaySummary> {
        /**
         * <p>
         * The ARN of the gateway.
         * </p>
         * 
         * @param arn
         *        The ARN of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the gateway.
         * </p>
         * 
         * @param name
         *        The name of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the gateway.
         * </p>
         * 
         * @param description
         *        The description of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the gateway group that the gateway is associated to.
         * </p>
         * 
         * @param gatewayGroupArn
         *        The ARN of the gateway group that the gateway is associated to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayGroupArn(String gatewayGroupArn);

        /**
         * <p>
         * The software version of the gateway. The gateway automatically updates its software version during normal
         * operation.
         * </p>
         * 
         * @param softwareVersion
         *        The software version of the gateway. The gateway automatically updates its software version during
         *        normal operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareVersion(String softwareVersion);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String gatewayGroupArn;

        private String softwareVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewaySummary model) {
            arn(model.arn);
            name(model.name);
            description(model.description);
            gatewayGroupArn(model.gatewayGroupArn);
            softwareVersion(model.softwareVersion);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getGatewayGroupArn() {
            return gatewayGroupArn;
        }

        @Override
        public final Builder gatewayGroupArn(String gatewayGroupArn) {
            this.gatewayGroupArn = gatewayGroupArn;
            return this;
        }

        public final void setGatewayGroupArn(String gatewayGroupArn) {
            this.gatewayGroupArn = gatewayGroupArn;
        }

        public final String getSoftwareVersion() {
            return softwareVersion;
        }

        @Override
        public final Builder softwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
            return this;
        }

        public final void setSoftwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
        }

        @Override
        public GatewaySummary build() {
            return new GatewaySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
